DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-10
      0.00000000000000E+00  -1.15631605696904E-11   0.00000000000000E+00   2.32934819622496E-14   1.57119550077929E-22
      1.15632410964580E-08   1.15632643899402E-08  -7.94489340991896E-19  -2.48476022247972E-01  -2.48476022247982E-01
      0.00000000000000E+00   0.00000000000000E+00   1.07050858754043E-11   0.00000000000000E+00   1.07050858754043E-11
      3.70608115860510E-18  -2.48476022246968E-01  -2.44829628802432E-01   0.00000000000000E+00  -1.83871704394735E-14
     -9.83008693144307E-23  -1.15739510886450E-08  -1.15739694758156E-08  -2.91159181761320E-18
      1.17500000000000E-09
      0.00000000000000E+00  -1.11043042626016E-11   0.00000000000000E+00   3.63543159403164E-14   1.51846244927763E-22
      1.11043320300897E-08   1.11043683844058E-08  -7.98263410088321E-19  -2.46740124911844E-01  -2.46740124911856E-01
      0.00000000000000E+00   0.00000000000000E+00   1.12985080424110E-11   0.00000000000000E+00   1.12985080424110E-11
      3.71370765153373E-18  -2.46740124908287E-01  -2.43238121077015E-01   0.00000000000000E+00  -2.43605790140625E-14
     -9.82420313696365E-23  -1.11156425318691E-08  -1.11156668924482E-08  -2.91544424144541E-18
      2.08625000000000E-09
      0.00000000000000E+00  -1.06571122371382E-11   0.00000000000000E+00   9.36577883300248E-14   1.48183813461655E-22
      1.06570650600760E-08   1.06571587178645E-08  -8.02239875789330E-19  -2.44821708447268E-01  -2.44821708447279E-01
      0.00000000000000E+00   0.00000000000000E+00   1.10187083867088E-11   0.00000000000000E+00   1.10187083867088E-11
      3.72374844955112E-18  -2.44821708438775E-01  -2.41460702160463E-01   0.00000000000000E+00  -7.80739493209028E-14
     -9.81576022687568E-23  -1.06680993523018E-08  -1.06681774262512E-08  -2.92150857376179E-18
      2.39379687500000E-09
      0.00000000000000E+00  -1.05237536787128E-11   0.00000000000000E+00  -2.15294375511693E-14   1.47249169729898E-22
      1.05238080140890E-08   1.05237864846516E-08  -8.03472067521713E-19  -2.44217084400327E-01  -2.44217084400338E-01
      0.00000000000000E+00   0.00000000000000E+00   1.08367846878259E-11   0.00000000000000E+00   1.08367846878259E-11
      3.72708126881690E-18  -2.44217084405989E-01  -2.40898117551200E-01   0.00000000000000E+00   3.81434658235614E-14
     -9.81289940185986E-23  -1.05346614128052E-08  -1.05346232693394E-08  -2.92360920129519E-18
      2.80898515625000E-09
      0.00000000000000E+00  -1.03666991780880E-11   0.00000000000000E+00  -1.65286771657243E-14   1.46389101398854E-22
      1.03667304257095E-08   1.03667138970325E-08  -8.04967746270820E-19  -2.43469162858934E-01  -2.43469162858944E-01
      0.00000000000000E+00   0.00000000000000E+00   1.05054533210284E-11   0.00000000000000E+00   1.05054533210284E-11
      3.73144300992501E-18  -2.43469162882533E-01  -2.40199787123100E-01   0.00000000000000E+00   3.36557662584464E-14
     -9.80905977323544E-23  -1.03772530061197E-08  -1.03772193503535E-08  -2.92647526365419E-18
      3.36948933593750E-09
      0.00000000000000E+00  -1.01869590273728E-11   0.00000000000000E+00  -1.13687065385651E-14   1.45723686758548E-22
      1.01870160920301E-08   1.01870047233237E-08  -8.06738956701451E-19  -2.42565264197302E-01  -2.42565264197312E-01
      0.00000000000000E+00   0.00000000000000E+00   9.96001814154046E-12   0.00000000000000E+00   9.96001814154046E-12
      3.73702564172311E-18  -2.42565264241613E-01  -2.39352678697023E-01   0.00000000000000E+00   2.85692552189257E-14
     -9.80401861403389E-23  -1.01969933107204E-08  -1.01969647414653E-08  -2.93028668502166E-18
      4.12616997851563E-09
      0.00000000000000E+00  -9.98802332658133E-12   0.00000000000000E+00  -4.67335751965477E-15   1.45376957932088E-22
      9.98800736978015E-09   9.98800269642277E-09  -8.08777130542853E-19  -2.41503618152896E-01  -2.41503618152905E-01
      0.00000000000000E+00   0.00000000000000E+00   9.15765502495580E-12   0.00000000000000E+00   9.15765502495580E-12
      3.74395506201190E-18  -2.41503618220668E-01  -2.38353982517297E-01   0.00000000000000E+00   2.13118096261067E-14
     -9.79760495429483E-23  -9.99718166325724E-09  -9.99716035144772E-09  -2.93517793146905E-18
      5.14768884599610E-09
      0.00000000000000E+00  -9.77549460468311E-12   0.00000000000000E+00   3.82897569646229E-15   1.45440084021819E-22
      9.77547745634277E-09   9.77548128531861E-09  -8.11044408411273E-19  -2.40299793803533E-01  -2.40299793803541E-01
      0.00000000000000E+00   0.00000000000000E+00   8.08560810608363E-12   0.00000000000000E+00   8.08560810608363E-12
      3.75221466324732E-18  -2.40299793897438E-01  -2.37217452860112E-01   0.00000000000000E+00   1.14857151019710E-14
     -9.78978722803701E-23  -9.78357837913970E-09  -9.78356689342469E-09  -2.94117025483605E-18
      6.52673931709473E-09
      0.00000000000000E+00  -9.55763888802686E-12   0.00000000000000E+00   1.42077072588875E-14   1.45932802109173E-22
      9.55764316282634E-09   9.55765737053375E-09  -8.13465121360806E-19  -2.38993052584913E-01  -2.38993052584920E-01
      0.00000000000000E+00   0.00000000000000E+00   6.77948245779659E-12   0.00000000000000E+00   6.77948245779659E-12
      3.76156391172455E-18  -2.38993052707311E-01  -2.35979751263571E-01   0.00000000000000E+00  -9.70740843514705E-16
     -9.78077183400805E-23  -9.56443588225062E-09  -9.56443685299155E-09  -2.94809879036374E-18
      8.38845745307788E-09
      0.00000000000000E+00  -9.34492647665422E-12   0.00000000000000E+00   2.61580745766570E-14   1.46781369161281E-22
      9.34495036684922E-09   9.34497652492394E-09  -8.15920856194636E-19  -2.37649927110045E-01  -2.37649927110051E-01
      0.00000000000000E+00   0.00000000000000E+00   5.33099914798499E-12   0.00000000000000E+00   5.33099914798499E-12
      3.77148872952126E-18  -2.37649927262102E-01  -2.34704090494621E-01   0.00000000000000E+00  -1.55701217774627E-14
     -9.77106876077278E-23  -9.35029195395006E-09  -9.35030752407193E-09  -2.95556787332663E-18
      1.03884574530779E-08
      0.00000000000000E+00  -9.17905488125743E-12   0.00000000000000E+00   1.52991316522726E-14   1.47648341862456E-22
      9.17907870281786E-09   9.17909400194966E-09  -8.17895629654026E-19  -2.36560566511068E-01  -2.36560566511072E-01
      0.00000000000000E+00   0.00000000000000E+00   4.10763905567463E-12   0.00000000000000E+00   4.10763905567463E-12
      3.77970400763261E-18  -2.36560566683464E-01  -2.33667372832486E-01   0.00000000000000E+00  -7.04080662019676E-15
     -9.76297631554505E-23  -9.18319460019861E-09  -9.18320164100532E-09  -2.96180837797859E-18
      1.23884574530779E-08
      0.00000000000000E+00  -9.05653400182259E-12   0.00000000000000E+00   6.59164380697913E-15   1.48390386442976E-22
      9.05646962497468E-09   9.05647621661864E-09  -8.19387921402176E-19  -2.35732973831399E-01  -2.35732973831402E-01
      0.00000000000000E+00   0.00000000000000E+00   3.15885041527997E-12   0.00000000000000E+00   3.15885041527997E-12
      3.78602170846318E-18  -2.35732974011210E-01  -2.32878706811241E-01   0.00000000000000E+00  -1.93887958488180E-16
     -9.75673245169438E-23  -9.05963487314586E-09  -9.05963506703391E-09  -2.96663378706100E-18
      1.43884574530779E-08
      0.00000000000000E+00  -8.96468926461506E-12   0.00000000000000E+00   2.78818067962394E-15   1.48995605899046E-22
      8.96468362675674E-09   8.96468641493757E-09  -8.20522670763280E-19  -2.35101579541135E-01  -2.35101579541137E-01
      0.00000000000000E+00   0.00000000000000E+00   2.42746859845090E-12   0.00000000000000E+00   2.42746859845090E-12
      3.79087664566007E-18  -2.35101579710406E-01  -2.32276459929406E-01   0.00000000000000E+00   2.14226850998580E-15
     -9.75193038310709E-23  -8.96711602580443E-09  -8.96711388353602E-09  -2.97035397489679E-18
      1.63884574530779E-08
      0.00000000000000E+00  -8.89534648802338E-12   0.00000000000000E+00   3.60478809372626E-14   1.49476768355299E-22
      8.89536580891718E-09   8.89540185679826E-09  -8.21389087652870E-19  -2.34618481583726E-01  -2.34618481583728E-01
      0.00000000000000E+00   0.00000000000000E+00   1.86521028551921E-12   0.00000000000000E+00   1.86521028551921E-12
      3.79460706623112E-18  -2.34618481720563E-01  -2.31815377498037E-01   0.00000000000000E+00  -3.24414017798167E-14
     -9.74823890867603E-23  -8.89723462568191E-09  -8.89726706708379E-09  -2.97321797857825E-18
      1.83884574530779E-08
      0.00000000000000E+00  -8.84271945360347E-12   0.00000000000000E+00   3.01064045306582E-15   1.49854669762810E-22
      8.84273566103675E-09   8.84273867167735E-09  -8.22052590273637E-19  -2.34248051883365E-01  -2.34248051883366E-01
      0.00000000000000E+00   0.00000000000000E+00   1.43350865603651E-12   0.00000000000000E+00   1.43350865603651E-12
      3.79747408354319E-18  -2.34248051960399E-01  -2.31461664802953E-01   0.00000000000000E+00  -1.16962642557687E-16
     -9.74541313664869E-23  -8.84417206337064E-09  -8.84417218033338E-09  -2.97542149326955E-18
      2.03884574530779E-08
      0.00000000000000E+00  -8.80258330344378E-12   0.00000000000000E+00   2.48807393449309E-14   1.50148391894053E-22
      8.80257407686136E-09   8.80259895760086E-09  -8.22561598866799E-19  -2.33963633032899E-01  -2.33963633032900E-01
      0.00000000000000E+00   0.00000000000000E+00   1.10206402609223E-12   0.00000000000000E+00   1.10206402609223E-12
      3.79967821159537E-18  -2.33963633017677E-01  -2.31190003100017E-01   0.00000000000000E+00  -2.27881832374984E-14
     -9.74323900848083E-23  -8.80367823344362E-09  -8.80370102162695E-09  -2.97711661272857E-18
      2.23884574530779E-08
      0.00000000000000E+00  -8.77181531647926E-12   0.00000000000000E+00   6.49337648377107E-16   1.50376292828253E-22
      8.77186734139893E-09   8.77186799073672E-09  -8.22952679968565E-19  -2.33745000004296E-01  -2.33745000004297E-01
      0.00000000000000E+00   0.00000000000000E+00   8.47589905977151E-13   0.00000000000000E+00   8.47589905977151E-13
      3.80137339140733E-18  -2.33744999861832E-01  -2.30981124239206E-01   0.00000000000000E+00   1.05832955685484E-15
     -9.74157592756057E-23  -8.77271663897216E-09  -8.77271558064270E-09  -2.97842071143876E-18
      2.43884574530779E-08
      0.00000000000000E+00  -8.74839490849134E-12   0.00000000000000E+00   7.95280285698961E-15   1.50552158978262E-22
      8.74831828235052E-09   8.74832623515353E-09  -8.23253390656133E-19  -2.33576828177823E-01  -2.33576828177824E-01
      0.00000000000000E+00   0.00000000000000E+00   6.52093804681958E-13   0.00000000000000E+00   6.52093804681958E-13
      3.80267757901669E-18  -2.33576827871633E-01  -2.30820432925384E-01   0.00000000000000E+00  -6.68529090286762E-15
     -9.74029550314860E-23  -8.74897164366721E-09  -8.74897832895821E-09  -2.97942418836056E-18
      2.63884574530779E-08
      0.00000000000000E+00  -8.73020965052425E-12   0.00000000000000E+00   3.10851771516329E-17   1.50687967600046E-22
      8.73024488303034E-09   8.73024491411567E-09  -8.23484791162930E-19  -2.33447391686146E-01  -2.33447391686147E-01
      0.00000000000000E+00   0.00000000000000E+00   5.01857266503287E-13   0.00000000000000E+00   5.01857266503287E-13
      3.80368129354970E-18  -2.33447391181969E-01  -2.30696737568339E-01   0.00000000000000E+00   9.76812809007012E-16
     -9.73931391440559E-23  -8.73074774819489E-09  -8.73074677138218E-09  -2.98019650238677E-18
      2.83884574530779E-08
      0.00000000000000E+00  -8.71634109520591E-12   0.00000000000000E+00   2.57244501392360E-15   1.50792583574321E-22
      8.71635158406025E-09   8.71635415650541E-09  -8.23662926016477E-19  -2.33347734743348E-01  -2.33347734743348E-01
      0.00000000000000E+00   0.00000000000000E+00   3.86336976220298E-13   0.00000000000000E+00   3.86336976220298E-13
      3.80445396750214E-18  -2.33347734013323E-01  -2.30601493853368E-01   0.00000000000000E+00  -1.81293477942548E-15
     -9.73855832862557E-23  -8.71673868054676E-09  -8.71674049348163E-09  -2.98079104148566E-18
      3.03884574530779E-08
      0.00000000000000E+00  -8.70568710568984E-12   0.00000000000000E+00  -9.93678763493123E-17   1.50873238464607E-22
      8.70566766850032E-09   8.70566756913259E-09  -8.23800111236069E-19  -2.33270980589941E-01  -2.33270980589941E-01
      0.00000000000000E+00   0.00000000000000E+00   2.97480933872019E-13   0.00000000000000E+00   2.97480933872019E-13
      3.80504892936988E-18  -2.33270979617876E-01  -2.30528133404381E-01   0.00000000000000E+00   6.94986300017113E-16
     -9.73797809908612E-23  -8.70596574505267E-09  -8.70596505006646E-09  -2.98124881813381E-18
      3.23884574530779E-08
      0.00000000000000E+00  -8.69742107934116E-12   0.00000000000000E+00   8.08939267981158E-16   1.50935347967716E-22
      8.69744453210662E-09   8.69744534104604E-09  -8.23905781225133E-19  -2.33211855094555E-01  -2.33211855094555E-01
      0.00000000000000E+00   0.00000000000000E+00   2.29105186357539E-13   0.00000000000000E+00   2.29105186357539E-13
      3.80550713974260E-18  -2.33211853883106E-01  -2.30471619896569E-01   0.00000000000000E+00  -3.56066928447276E-16
     -9.73753139365605E-23  -8.69767409016537E-09  -8.69767444623239E-09  -2.98160135851746E-18
      3.43884574530779E-08
      0.00000000000000E+00  -8.69108379247384E-12   0.00000000000000E+00  -9.94200665299325E-17   1.50983208363075E-22
      8.69111426088322E-09   8.69111416146331E-09  -8.23987193322562E-19  -2.33166301107479E-01  -2.33166301107479E-01
      0.00000000000000E+00   0.00000000000000E+00   1.76475300435799E-13   0.00000000000000E+00   1.76475300435799E-13
      3.80586009034347E-18  -2.33166299685128E-01  -2.30428076622202E-01   0.00000000000000E+00   4.51881808787275E-16
     -9.73718793911938E-23  -8.69129108864546E-09  -8.69129063676374E-09  -2.98187289702090E-18
      3.63884574530779E-08
      0.00000000000000E+00  -8.68621602140184E-12   0.00000000000000E+00   2.33341348374643E-16   1.51020067923837E-22
      8.68623875356808E-09   8.68623898690958E-09  -8.24049922679694E-19  -2.33131200023237E-01  -2.33131200023237E-01
      0.00000000000000E+00   0.00000000000000E+00   1.35953187164665E-13   0.00000000000000E+00   1.35953187164665E-13
      3.80613199671780E-18  -2.33131198452065E-01  -2.30394524176215E-01   0.00000000000000E+00   3.60880769869999E-17
     -9.73692345452923E-23  -8.68637497618473E-09  -8.68637494009674E-09  -2.98208207403810E-18
      3.83884574530779E-08
      0.00000000000000E+00  -8.68245038717633E-12   0.00000000000000E+00   3.31068005671897E-16   1.51048476017299E-22
      8.68248324633940E-09   8.68248357740755E-09  -8.24098261852650E-19  -2.33104150774308E-01  -2.33104150774309E-01
      0.00000000000000E+00   0.00000000000000E+00   1.04747634069958E-13   0.00000000000000E+00   1.04747634069958E-13
      3.80634149198594E-18  -2.33104149156962E-01  -2.30368667879247E-01   0.00000000000000E+00  -1.26576378516025E-16
     -9.73671993375819E-23  -8.68258819846516E-09  -8.68258832504163E-09  -2.98224323013329E-18
      4.03884574530779E-08
      0.00000000000000E+00  -8.67960320032290E-12   0.00000000000000E+00   5.24226305675587E-17   1.51070346996520E-22
      8.67958997894870E-09   8.67959003137149E-09  -8.24135514948217E-19  -2.33083304791503E-01  -2.33083304791503E-01
      0.00000000000000E+00   0.00000000000000E+00   8.07115459282835E-14   0.00000000000000E+00   8.07115459282835E-14
      3.80650291507779E-18  -2.33083303278654E-01  -2.30348741093039E-01   0.00000000000000E+00   1.06945685011494E-16
     -9.73656316527262E-23  -8.67967084986300E-09  -8.67967074291742E-09  -2.98236740012958E-18
      4.23884574530779E-08
      0.00000000000000E+00  -8.67739892662992E-12   0.00000000000000E+00   9.39465900181571E-17   1.51087206155353E-22
      8.67736052253509E-09   8.67736061648184E-09  -8.24164225847883E-19  -2.33067238791464E-01  -2.33067238791464E-01
      0.00000000000000E+00   0.00000000000000E+00   6.21958176596985E-14   0.00000000000000E+00   6.21958176596985E-14
      3.80662730671311E-18  -2.33067237585464E-01  -2.30333383619805E-01   0.00000000000000E+00   2.83546140418665E-17
     -9.73644246697238E-23  -8.67742284065402E-09  -8.67742281229950E-09  -2.98246308086523E-18
      4.43884574530779E-08
      0.00000000000000E+00  -8.67556203188577E-12   0.00000000000000E+00   8.67047389325087E-16   1.51100206826968E-22
      8.67564228467997E-09   8.67564315172751E-09  -8.24186353223960E-19  -2.33054856610477E-01  -2.33054856610477E-01
      0.00000000000000E+00   0.00000000000000E+00   4.79309322758070E-14   0.00000000000000E+00   4.79309322758070E-14
      3.80672316857767E-18  -2.33054855964281E-01  -2.30321547820894E-01   0.00000000000000E+00  -7.81378991890011E-16
     -9.73634948493616E-23  -8.67569030128069E-09  -8.67569108265978E-09  -2.98253681535371E-18
      4.63884574530779E-08
      0.00000000000000E+00  -8.67427620556486E-12   0.00000000000000E+00   1.93851635497771E-17   1.51110202254513E-22
      8.67431857804580E-09   8.67431859743111E-09  -8.24203409234844E-19  -2.33045312402558E-01  -2.33045312402558E-01
      0.00000000000000E+00   0.00000000000000E+00   3.69393039656642E-14   0.00000000000000E+00   3.69393039656642E-14
      3.80679704718560E-18  -2.33045312616158E-01  -2.30312424967941E-01   0.00000000000000E+00   5.18829833318243E-17
     -9.73627786023155E-23  -8.67435558861796E-09  -8.67435553673507E-09  -2.98259363795075E-18
      4.83884574530779E-08
      0.00000000000000E+00  -8.67326591345558E-12   0.00000000000000E+00   2.95412282185255E-16   1.51117916972193E-22
      8.67329801342386E-09   8.67329830883630E-09  -8.24216555467130E-19  -2.33037956064073E-01  -2.33037956064073E-01
      0.00000000000000E+00   0.00000000000000E+00   2.84699872196569E-14   0.00000000000000E+00   2.84699872196569E-14
      3.80685398716004E-18  -2.33037957472271E-01  -2.30305394019079E-01   0.00000000000000E+00  -2.42237296979389E-16
     -9.73622268259044E-23  -8.67332653658611E-09  -8.67332677882351E-09  -2.98263743169291E-18
      5.03884574530779E-08
      0.00000000000000E+00  -8.67253115555792E-12   0.00000000000000E+00  -1.13705901766809E-18   1.51123854778200E-22
      8.67251159356016E-09   8.67251159242325E-09  -8.24226688988039E-19  -2.33032285589394E-01  -2.33032285589394E-01
      0.00000000000000E+00   0.00000000000000E+00   2.19435835469563E-14   0.00000000000000E+00   2.19435835469563E-14
      3.80689787432713E-18  -2.33032288540442E-01  -2.30299974903942E-01   0.00000000000000E+00   4.39559940688274E-17
     -9.73618017304838E-23  -8.67253357996270E-09  -8.67253353600680E-09  -2.98267118533909E-18
      5.23884574530779E-08
      0.00000000000000E+00  -8.67188824239747E-12   0.00000000000000E+00   9.80346647706798E-17   1.51128435357735E-22
      8.67190531122331E-09   8.67190540925813E-09  -8.24234500039539E-19  -2.33027914712746E-01  -2.33027914712747E-01
      0.00000000000000E+00   0.00000000000000E+00   1.69140778278940E-14   0.00000000000000E+00   1.69140778278940E-14
      3.80693170248279E-18  -2.33027919537724E-01  -2.30295798493892E-01   0.00000000000000E+00  -6.56536835448614E-17
     -9.73614742287091E-23  -8.67192225768217E-09  -8.67192232333595E-09  -2.98269720244325E-18
      5.43884574530779E-08
      0.00000000000000E+00  -8.67142901871143E-12   0.00000000000000E+00  -5.13446985968631E-18   1.51131963127174E-22
      8.67143805553640E-09   8.67143805040208E-09  -8.24240521196726E-19  -2.33024545411093E-01  -2.33024545411093E-01
      0.00000000000000E+00   0.00000000000000E+00   1.30378578276786E-14   0.00000000000000E+00   1.30378578276786E-14
      3.80695777819844E-18  -2.33024552382896E-01  -2.30292579768515E-01   0.00000000000000E+00   3.07275307574237E-17
     -9.73612219131632E-23  -8.67145111898734E-09  -8.67145108825990E-09  -2.98271725700172E-18
      5.63884574530779E-08
      0.00000000000000E+00  -8.67106163976260E-12   0.00000000000000E+00   3.09595545803527E-17   1.51134683881128E-22
      8.67107785294386E-09   8.67107788390357E-09  -8.24245162472225E-19  -2.33021948240382E-01  -2.33021948240382E-01
      0.00000000000000E+00   0.00000000000000E+00   1.00502169854582E-14   0.00000000000000E+00   1.00502169854582E-14
      3.80697787863241E-18  -2.33021957520780E-01  -2.30290099328856E-01   0.00000000000000E+00  -1.14537155258609E-17
     -9.73610275276660E-23  -8.67108792266675E-09  -8.67108793412056E-09  -2.98273271616019E-18
      5.83884574530779E-08
      0.00000000000000E+00  -8.67078610555098E-12   0.00000000000000E+00  -4.62242195169274E-18   1.51136780405403E-22
      8.67080024709012E-09   8.67080024246785E-09  -8.24248740013827E-19  -2.33019946283516E-01  -2.33019946283516E-01
      0.00000000000000E+00   0.00000000000000E+00   7.74713689538753E-15   0.00000000000000E+00   7.74713689538753E-15
      3.80699337290620E-18  -2.33019957860245E-01  -2.30288187853226E-01   0.00000000000000E+00   1.98737526692920E-17
     -9.73608777669929E-23  -8.67080800947840E-09  -8.67080798960475E-09  -2.98274463289237E-18
      6.03884574530779E-08
      0.00000000000000E+00  -8.67060241607656E-12   0.00000000000000E+00   8.77742018178620E-18   1.51138397556066E-22
      8.67058629179861E-09   8.67058630057618E-09  -8.24251497256434E-19  -2.33018403310267E-01  -2.33018403310267E-01
      0.00000000000000E+00   0.00000000000000E+00   5.97139091649684E-15   0.00000000000000E+00   5.97139091649684E-15
      3.80700531568804E-18  -2.33018416925902E-01  -2.30286714884589E-01   0.00000000000000E+00   2.90750166653992E-18
     -9.73607623766954E-23  -8.67059227487451E-09  -8.67059227196711E-09  -2.98275381843160E-18
      6.23884574530779E-08
      0.00000000000000E+00  -8.67041872660215E-12   0.00000000000000E+00  -3.29310584506924E-18   1.51139644654471E-22
      8.67042145589108E-09   8.67042145259813E-09  -8.24253621795874E-19  -2.33017214337744E-01  -2.33017214337744E-01
      0.00000000000000E+00   0.00000000000000E+00   4.60177347808360E-15   0.00000000000000E+00   4.60177347808360E-15
      3.80701451923499E-18  -2.33017229415244E-01  -2.30285579736736E-01   0.00000000000000E+00   1.23791973764970E-17
     -9.73606734408826E-23  -8.67042606675070E-09  -8.67042605437160E-09  -2.98276089743912E-18
      6.43884574530779E-08
      0.00000000000000E+00  -8.67023503712773E-12   0.00000000000000E+00   1.82509630404424E-18   1.51140607370612E-22
      8.67029451014167E-09   8.67029451196692E-09  -8.24255258066044E-19  -2.33016298536556E-01  -2.33016298536556E-01
      0.00000000000000E+00   0.00000000000000E+00   3.54486639749977E-15   0.00000000000000E+00   3.54486639749977E-15
      3.80702160896779E-18  -2.33016314106732E-01  -2.30284704755254E-01   0.00000000000000E+00   5.15438614615490E-18
     -9.73606048509620E-23  -8.67029806198760E-09  -8.67029805683331E-09  -2.98276635090174E-18
      6.63884574530779E-08
      0.00000000000000E+00  -8.67023503712773E-12   0.00000000000000E+00  -2.14108492293838E-18   1.51141350897681E-22
      8.67019682836206E-09   8.67019682622112E-09  -8.24256517319270E-19  -2.33015593647837E-01  -2.33015593647837E-01
      0.00000000000000E+00   0.00000000000000E+00   2.72867330866981E-15   0.00000000000000E+00   2.72867330866981E-15
      3.80702706631441E-18  -2.33015608287912E-01  -2.30284029968068E-01   0.00000000000000E+00   7.56733843812013E-18
     -9.73605518838689E-23  -8.67019956246167E-09  -8.67019955489443E-09  -2.98277054899513E-18
      6.83884574530779E-08
      0.00000000000000E+00  -8.67005134765332E-12   0.00000000000000E+00  -1.01053664721962E-19   1.51141925934849E-22
      8.67012175238597E-09   8.67012175228507E-09  -8.24257485219813E-19  -2.33015051735734E-01  -2.33015051735734E-01
      0.00000000000000E+00   0.00000000000000E+00   2.09774952220004E-15   0.00000000000000E+00   2.09774952220004E-15
      3.80703126181345E-18  -2.33015063530049E-01  -2.30283509061542E-01   0.00000000000000E+00   4.29130500206690E-18
     -9.73605108892322E-23  -8.67012385432579E-09  -8.67012385003458E-09  -2.98277377659363E-18
      7.03884574530779E-08
      0.00000000000000E+00  -8.67005134765332E-12   0.00000000000000E+00  -1.33510810655427E-18   1.51142371183269E-22
      8.67006415810126E-09   8.67006415676630E-09  -8.24258227779871E-19  -2.33014635867283E-01  -2.33014635867283E-01
      0.00000000000000E+00   0.00000000000000E+00   1.60943863952037E-15   0.00000000000000E+00   1.60943863952037E-15
      3.80703448069073E-18  -2.33014642402931E-01  -2.30283106233249E-01   0.00000000000000E+00   4.60363407190469E-18
     -9.73604790413066E-23  -8.67006577080847E-09  -8.67006576620493E-09  -2.98277625291086E-18
      7.23884574530779E-08
      0.00000000000000E+00  -8.67005134765332E-12   0.00000000000000E+00  -4.62602846380625E-19   1.51142716507287E-22
      8.67002008521892E-09   8.67002008475646E-09  -8.24258795922249E-19  -2.33014317561514E-01  -2.33014317561514E-01
      0.00000000000000E+00   0.00000000000000E+00   1.23100100904305E-15   0.00000000000000E+00   1.23100100904305E-15
      3.80703694269274E-18  -2.33014315974158E-01  -2.30282793808784E-01   0.00000000000000E+00   3.02633368027577E-18
     -9.73604541565914E-23  -8.67002131878370E-09  -8.67002131575747E-09  -2.98277814677050E-18
      7.43884574530779E-08
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00  -8.02917133439944E-19   1.51142984622884E-22
      8.66998647071815E-09   8.66998646991539E-09  -8.24259229039990E-19  -2.33014074799054E-01  -2.33014074799054E-01
      0.00000000000000E+00   0.00000000000000E+00   9.37393418554878E-16   0.00000000000000E+00   9.37393418554878E-16
      3.80703881747958E-18  -2.33014061884838E-01  -2.30282550402151E-01   0.00000000000000E+00   2.83087242842843E-18
     -9.73604345503554E-23  -8.66998741013957E-09  -8.66998740730880E-09  -2.98277958843959E-18
      7.63884574530779E-08
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00  -4.13527214507507E-19   1.51143192832338E-22
      8.66996092917414E-09   8.66996092876076E-09  -8.24259557755555E-19  -2.33013890480072E-01  -2.33013890480072E-01
      0.00000000000000E+00   0.00000000000000E+00   7.09575900769321E-16   0.00000000000000E+00   7.09575900769321E-16
      3.80704023663139E-18  -2.33013862889759E-01  -2.30282359525656E-01   0.00000000000000E+00   2.03631318563693E-18
     -9.73604189329001E-23  -8.66996164037288E-09  -8.66996163833666E-09  -2.98278067887583E-18
      7.83884574530779E-08
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00  -4.71553287700854E-19   1.51143354101859E-22
      8.66994158966276E-09   8.66994158919136E-09  -8.24259806073649E-19  -2.33013751220327E-01  -2.33013751220327E-01
      0.00000000000000E+00   0.00000000000000E+00   5.33195665361298E-16   0.00000000000000E+00   5.33195665361298E-16
      3.80704130302271E-18  -2.33013705748787E-01  -2.30282208533118E-01   0.00000000000000E+00   1.79353749419097E-18
     -9.73604063292321E-23  -8.66994212418046E-09  -8.66994212238702E-09  -2.98278149694907E-18
      8.03884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -2.87357814057978E-19   1.51143478052457E-22
      8.66992696440135E-09   8.66992696411414E-09  -8.24259993056390E-19  -2.33013646414195E-01  -2.33013646414195E-01
      0.00000000000000E+00   0.00000000000000E+00   3.97575297956251E-16   0.00000000000000E+00   3.97575297956251E-16
      3.80704209817331E-18  -2.33013580395064E-01  -2.30282087829771E-01   0.00000000000000E+00   1.37780467440512E-18
     -9.73603960224078E-23  -8.66992736306714E-09  -8.66992736168943E-09  -2.98278210511692E-18
      8.23884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -2.71814332084003E-19   1.51143571649043E-22
      8.66991585020169E-09   8.66991584993003E-09  -8.24260134121873E-19  -2.33013567506718E-01  -2.33013567506718E-01
      0.00000000000000E+00   0.00000000000000E+00   2.94910630954418E-16   0.00000000000000E+00   2.94910630954418E-16
      3.80704268799457E-18  -2.33013479314598E-01  -2.30281990283144E-01   0.00000000000000E+00   1.18500075628037E-18
     -9.73603875104721E-23  -8.66991614602556E-09  -8.66991614484066E-09  -2.98278255387270E-18
      8.43884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -1.90611114867103E-19   1.51143639813147E-22
      8.66990725187217E-09   8.66990725168171E-09  -8.24260242038362E-19  -2.33013507434636E-01  -2.33013507434636E-01
      0.00000000000000E+00   0.00000000000000E+00   2.19629973365491E-16   0.00000000000000E+00   2.19629973365491E-16
      3.80704312725452E-18  -2.33013397086741E-01  -2.30281910787882E-01   0.00000000000000E+00   9.46162600625677E-19
     -9.73603804763299E-23  -8.66990747225775E-09  -8.66990747131169E-09  -2.98278288521616E-18
      8.63884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -1.63414136347869E-19   1.51143685903989E-22
      8.66990032669696E-09   8.66990032653370E-09  -8.24260327664089E-19  -2.33013460207484E-01  -2.33013460207484E-01
      0.00000000000000E+00   0.00000000000000E+00   1.67858478321772E-16   0.00000000000000E+00   1.67858478321772E-16
      3.80704346297148E-18  -2.33013330043658E-01  -2.30281845942865E-01   0.00000000000000E+00   7.83037424173313E-19
     -9.73603747632266E-23  -8.66990049517512E-09  -8.66990049439218E-09  -2.98278313530739E-18
      8.83884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -7.26404942374737E-20   1.51143712156709E-22
      8.66989434542827E-09   8.66989434535578E-09  -8.24260400469777E-19  -2.33013420608135E-01  -2.33013420608135E-01
      0.00000000000000E+00   0.00000000000000E+00   1.36959848954344E-16   0.00000000000000E+00   1.36959848954344E-16
      3.80704373689117E-18  -2.33013276012592E-01  -2.30281793805922E-01   0.00000000000000E+00   5.44224872559996E-19
     -9.73603703579430E-23  -8.66989448285976E-09  -8.66989448231563E-09  -2.98278333642140E-18
      8.93884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   2.66900367886348E-18   1.51143758296969E-22
      8.66989150329144E-09   8.66989150596060E-09  -8.24260434797680E-19  -2.33013402094485E-01  -2.33013402094485E-01
      0.00000000000000E+00   0.00000000000000E+00   1.26525464168475E-16   0.00000000000000E+00   1.26525464168475E-16
      3.80704386341664E-18  -2.33013252067319E-01  -2.30281770759351E-01   0.00000000000000E+00  -2.28949509104122E-18
     -9.73603726587820E-23  -8.66989163019647E-09  -8.66989163248606E-09  -2.98278342861896E-18
      8.95572074530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -1.47305536603573E-19   1.51143722348523E-22
      8.66989102976856E-09   8.66989102962140E-09  -8.24260440525566E-19  -2.33013399008934E-01  -2.33013399008934E-01
      0.00000000000000E+00   0.00000000000000E+00   1.24758931651347E-16   0.00000000000000E+00   1.24758931651347E-16
      3.80704388446971E-18  -2.33013248112814E-01  -2.30281766954593E-01   0.00000000000000E+00   5.01515502688455E-19
     -9.73603681762937E-23  -8.66989115488176E-09  -8.66989115438034E-09  -2.98278344394414E-18
      8.97850199530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -1.38649541759142E-19   1.51143723937235E-22
      8.66989039511228E-09   8.66989039497378E-09  -8.24260448172491E-19  -2.33013394898327E-01  -2.33013394898327E-01
      0.00000000000000E+00   0.00000000000000E+00   1.22796182107684E-16   0.00000000000000E+00   1.22796182107684E-16
      3.80704391244421E-18  -2.33013242929957E-01  -2.30281761972294E-01   0.00000000000000E+00   5.02786560456653E-19
     -9.73603677154201E-23  -8.66989051827265E-09  -8.66989051776996E-09  -2.98278346427172E-18
      9.00925668280779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -1.36798735339838E-19   1.51143724931134E-22
      8.66988954708821E-09   8.66988954695156E-09  -8.24260458369679E-19  -2.33013389432078E-01  -2.33013389432078E-01
      0.00000000000000E+00   0.00000000000000E+00   1.20604219811956E-16   0.00000000000000E+00   1.20604219811956E-16
      3.80704394953567E-18  -2.33013236213251E-01  -2.30281755523449E-01   0.00000000000000E+00   4.79942268970959E-19
     -9.73603672880587E-23  -8.66988966803562E-09  -8.66988966755578E-09  -2.98278349116599E-18
      9.05077551093279E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -1.35805664306556E-19   1.51143726295350E-22
      8.66988841259461E-09   8.66988841245896E-09  -8.24260471979969E-19  -2.33013382163227E-01  -2.33013382163227E-01
      0.00000000000000E+00   0.00000000000000E+00   1.18456706371547E-16   0.00000000000000E+00   1.18456706371547E-16
      3.80704399871750E-18  -2.33013227649600E-01  -2.30281747317897E-01   0.00000000000000E+00   4.44886678610076E-19
     -9.73603666708253E-23  -8.66988853136045E-09  -8.66988853091566E-09  -2.98278352673753E-18
      9.10682592890154E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -1.31604772661160E-19   1.51143726740750E-22
      8.66988688652889E-09   8.66988688639744E-09  -8.24260490246386E-19  -2.33013372454355E-01  -2.33013372454355E-01
      0.00000000000000E+00   0.00000000000000E+00   1.17004242765687E-16   0.00000000000000E+00   1.17004242765687E-16
      3.80704406429887E-18  -2.33013216998095E-01  -2.30281737147638E-01   0.00000000000000E+00   3.92003360012660E-19
     -9.73603659489620E-23  -8.66988700379359E-09  -8.66988700340168E-09  -2.98278357405248E-18
      9.18249399315936E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   7.78889606047964E-17   1.51143779220854E-22
      8.66988838441278E-09   8.66988846230190E-09  -8.24260480105921E-19  -2.33013375661524E-01  -2.33013375661524E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.23299042587497E-18   0.00000000000000E+00  -2.23299042587497E-18
      3.80704406260921E-18  -2.33013201695691E-01  -2.30281721411729E-01   0.00000000000000E+00  -8.85635104033118E-17
     -9.73603626223602E-23  -8.66988837150530E-09  -8.66988846006891E-09  -2.98278358250329E-18
      9.23356993653338E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -3.03421855454843E-16   1.51143767733473E-22
      8.66988596397687E-09   8.66988566055517E-09  -8.24260503762666E-19  -2.33013364181459E-01  -2.33013364181459E-01
      0.00000000000000E+00   0.00000000000000E+00   1.18197661014500E-16   0.00000000000000E+00   1.18197661014500E-16
      3.80704412297978E-18  -2.33013192577582E-01  -2.30281713015843E-01   0.00000000000000E+00   3.23915284448903E-16
     -9.73603918038042E-23  -8.66988610266800E-09  -8.66988577875282E-09  -2.98278361921711E-18
      9.30252246008831E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -2.25441755435916E-19   1.51143728067296E-22
      8.66988285080253E-09   8.66988285057724E-09  -8.24260537141305E-19  -2.33013347640431E-01  -2.33013347640431E-01
      0.00000000000000E+00   0.00000000000000E+00   1.43574072851023E-16   0.00000000000000E+00   1.43574072851023E-16
      3.80704422197772E-18  -2.33013182456792E-01  -2.30281703869448E-01   0.00000000000000E+00   1.72622446941934E-19
     -9.73603633007504E-23  -8.66988299432383E-09  -8.66988299415131E-09  -2.98278368483642E-18
      9.39560836688747E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -2.06871509999543E-19   1.51143697887518E-22
      8.66987899233157E-09   8.66987899212486E-09  -8.24260582214857E-19  -2.33013324853074E-01  -2.33013324853074E-01
      0.00000000000000E+00   0.00000000000000E+00   1.59324186319369E-16   0.00000000000000E+00   1.59324186319369E-16
      3.80704437028609E-18  -2.33013172439140E-01  -2.30281695062457E-01   0.00000000000000E+00   6.64315142043354E-20
     -9.73603636006252E-23  -8.66987915151537E-09  -8.66987915144904E-09  -2.98278378807123E-18
      9.52127434106633E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -2.09126494500532E-19   1.51143663078851E-22
      8.66987371942862E-09   8.66987371921965E-09  -8.24260645587981E-19  -2.33013292209698E-01  -2.33013292209698E-01
      0.00000000000000E+00   0.00000000000000E+00   1.82171133916254E-16   0.00000000000000E+00   1.82171133916254E-16
      3.80704459921322E-18  -2.33013165550480E-01  -2.30281689827855E-01   0.00000000000000E+00  -8.16567745212358E-20
     -9.73603648195874E-23  -8.66987390130902E-09  -8.66987390139077E-09  -2.98278395362523E-18
      9.69092340620780E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -4.59720562865978E-19   1.51143616528595E-22
      8.66986602457114E-09   8.66986602411157E-09  -8.24260740687660E-19  -2.33013242551952E-01  -2.33013242551952E-01
      0.00000000000000E+00   0.00000000000000E+00   2.19426517761307E-16   0.00000000000000E+00   2.19426517761307E-16
      3.80704497146826E-18  -2.33013169081311E-01  -2.30281695771269E-01   0.00000000000000E+00  -7.47418544902207E-20
     -9.73603681817895E-23  -8.66986624346324E-09  -8.66986624353808E-09  -2.98278423078059E-18
      9.89092340620780E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -2.55828265966283E-19   1.51143556594758E-22
      8.66985572822299E-09   8.66985572796732E-09  -8.24260871314921E-19  -2.33013173648762E-01  -2.33013173648762E-01
      0.00000000000000E+00   0.00000000000000E+00   2.73181607508671E-16   0.00000000000000E+00   2.73181607508671E-16
      3.80704551783147E-18  -2.33013193085458E-01  -2.30281723002434E-01   0.00000000000000E+00  -6.14917630792965E-19
     -9.73603749137121E-23  -8.66985600053392E-09  -8.66985600114893E-09  -2.98278464651655E-18
      9.94092340620780E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -1.19146175323503E-16   1.51143561929095E-22
      8.66985425279556E-09   8.66985413364953E-09  -8.24260895477380E-19  -2.33013160272299E-01  -2.33013160272299E-01
      0.00000000000000E+00   0.00000000000000E+00   2.37662316714859E-16   0.00000000000000E+00   2.37662316714859E-16
      3.80704563666263E-18  -2.33013199800081E-01  -2.30281730192632E-01   0.00000000000000E+00   1.24578052583486E-16
     -9.73603779109644E-23  -8.66985449588979E-09  -8.66985437131184E-09  -2.98278474118525E-18
      1.00084234062078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -2.51828548931681E-19   1.51143544324873E-22
      8.66985081836008E-09   8.66985081810841E-09  -8.24260936772817E-19  -2.33013138082556E-01  -2.33013138082556E-01
      0.00000000000000E+00   0.00000000000000E+00   2.74913150842528E-16   0.00000000000000E+00   2.74913150842528E-16
      3.80704582222901E-18  -2.33013211064183E-01  -2.30281742527508E-01   0.00000000000000E+00  -6.95409421431695E-19
     -9.73603788349842E-23  -8.66985109232604E-09  -8.66985109302155E-09  -2.98278488545619E-18
      1.00995484062078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -2.70314666803540E-19   1.51143516632398E-22
      8.66984589782244E-09   8.66984589755228E-09  -8.24261000560878E-19  -2.33013104153725E-01  -2.33013104153725E-01
      0.00000000000000E+00   0.00000000000000E+00   3.08659541927049E-16   0.00000000000000E+00   3.08659541927049E-16
      3.80704610349501E-18  -2.33013230510434E-01  -2.30281763513392E-01   0.00000000000000E+00  -8.83434528120047E-19
     -9.73603829704153E-23  -8.66984620532829E-09  -8.66984620621182E-09  -2.98278510293413E-18
      1.02225671562078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -3.04128461157795E-19   1.51143472501035E-22
      8.66983840978563E-09   8.66983840948165E-09  -8.24261098349324E-19  -2.33013052118016E-01  -2.33013052118016E-01
      0.00000000000000E+00   0.00000000000000E+00   3.55090296008095E-16   0.00000000000000E+00   3.55090296008095E-16
      3.80704654032266E-18  -2.33013265413549E-01  -2.30281800761067E-01   0.00000000000000E+00  -1.11410499457651E-18
     -9.73603899013101E-23  -8.66983876345774E-09  -8.66983876457194E-09  -2.98278544197333E-18
      1.03886424687078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -3.35696415311551E-19   1.51143411759453E-22
      8.66982723850074E-09   8.66982723816520E-09  -8.24261246946993E-19  -2.33012972451620E-01  -2.33012972451620E-01
      0.00000000000000E+00   0.00000000000000E+00   4.14950370633684E-16   0.00000000000000E+00   4.14950370633684E-16
      3.80704722945278E-18  -2.33013329764015E-01  -2.30281868612310E-01   0.00000000000000E+00  -1.43415185402839E-18
     -9.73604016615516E-23  -8.66982765168131E-09  -8.66982765311556E-09  -2.98278598250579E-18
      1.05886424687078E-07
      0.00000000000000E+00  -8.66977581344170E-12   0.00000000000000E+00  -3.52628002100003E-19   1.51143349528631E-22
      8.66981308492209E-09   8.66981308456961E-09  -8.24261440707005E-19  -2.33012867240196E-01  -2.33012867240196E-01
      0.00000000000000E+00   0.00000000000000E+00   4.75024726264472E-16   0.00000000000000E+00   4.75024726264472E-16
      3.80704817950223E-18  -2.33013433136885E-01  -2.30281976425503E-01   0.00000000000000E+00  -1.80362731535233E-18
     -9.73604190490854E-23  -8.66981355779062E-09  -8.66981355959434E-09  -2.98278673879523E-18
      1.07886424687078E-07
      0.00000000000000E+00  -8.66977581344170E-12   0.00000000000000E+00  -2.51153699555472E-19   1.51143310418947E-22
      8.66979933636016E-09   8.66979933610915E-09  -8.24261636218935E-19  -2.33012759311681E-01  -2.33012759311681E-01
      0.00000000000000E+00   0.00000000000000E+00   5.12599292219997E-16   0.00000000000000E+00   5.12599292219997E-16
      3.80704920470082E-18  -2.33013561126043E-01  -2.30282108734478E-01   0.00000000000000E+00  -2.21784766783703E-18
     -9.73604390617973E-23  -8.66979984649050E-09  -8.66979984870844E-09  -2.98278756848188E-18
      1.08886424687078E-07
      0.00000000000000E+00  -8.66977581344170E-12   0.00000000000000E+00  -3.30412838488064E-19   1.51143298233910E-22
      8.66979272259194E-09   8.66979272226168E-09  -8.24261732490286E-19  -2.33012705646845E-01  -2.33012705646845E-01
      0.00000000000000E+00   0.00000000000000E+00   5.24299283428644E-16   0.00000000000000E+00   5.24299283428644E-16
      3.80704972900010E-18  -2.33013630963510E-01  -2.30282180652011E-01   0.00000000000000E+00  -2.26105265879516E-18
     -9.73604496179992E-23  -8.66979324429981E-09  -8.66979324656096E-09  -2.98278799650981E-18
      1.10236424687078E-07
      0.00000000000000E+00  -8.66977581344170E-12   0.00000000000000E+00  -2.94265418648600E-19   1.51143299553539E-22
      8.66978474637500E-09   8.66978474608089E-09  -8.24261853852931E-19  -2.33012636784108E-01  -2.33012636784108E-01
      0.00000000000000E+00   0.00000000000000E+00   5.22991223793999E-16   0.00000000000000E+00   5.22991223793999E-16
      3.80705043503825E-18  -2.33013734511780E-01  -2.30282286713708E-01   0.00000000000000E+00  -2.40038619423100E-18
     -9.73604645312233E-23  -8.66978526667162E-09  -8.66978526907210E-09  -2.98278858118532E-18
      1.12058924687078E-07
      0.00000000000000E+00  -8.66977581344170E-12   0.00000000000000E+00  -2.06026576634209E-19   1.51143345717787E-22
      8.66977719589482E-09   8.66977719568894E-09  -8.24261983252197E-19  -2.33012560145680E-01  -2.33012560145680E-01
      0.00000000000000E+00   0.00000000000000E+00   4.78345364148035E-16   0.00000000000000E+00   4.78345364148035E-16
      3.80705130682268E-18  -2.33013885244921E-01  -2.30282439839816E-01   0.00000000000000E+00  -2.45160707899922E-18
     -9.73604845837946E-23  -8.66977767158260E-09  -8.66977767403430E-09  -2.98278932357048E-18
      1.14058924687078E-07
      0.00000000000000E+00  -8.66977581344170E-12   0.00000000000000E+00  -4.71955636922442E-20   1.51143466821597E-22
      8.66977517282827E-09   8.66977517278123E-09  -8.24262052783176E-19  -2.33012512084991E-01  -2.33012512084991E-01
      0.00000000000000E+00   0.00000000000000E+00   3.61071210338702E-16   0.00000000000000E+00   3.61071210338702E-16
      3.80705202896510E-18  -2.33014051518853E-01  -2.30282606788138E-01   0.00000000000000E+00  -2.27713748335818E-18
     -9.73605041231865E-23  -8.66977553157521E-09  -8.66977553385244E-09  -2.98278997618192E-18
      1.16058924687078E-07
      0.00000000000000E+00  -8.66977581344170E-12   0.00000000000000E+00   1.82816513128889E-19   1.51143675150648E-22
      8.66978215777027E-09   8.66978215795324E-09  -8.24262013323093E-19  -2.33012519597495E-01  -2.33012519597495E-01
      0.00000000000000E+00   0.00000000000000E+00   1.59075102082454E-16   0.00000000000000E+00   1.59075102082454E-16
      3.80705234711530E-18  -2.33014201270676E-01  -2.30282754402980E-01   0.00000000000000E+00  -1.78760832975285E-18
     -9.73605181100369E-23  -8.66978231524063E-09  -8.66978231702833E-09  -2.98279033379221E-18
      1.18058924687078E-07
      0.00000000000000E+00  -8.66977581344170E-12   0.00000000000000E+00   4.91171469973454E-19   1.51143985372633E-22
      8.66980111045812E-09   8.66980111094944E-09  -8.24261824389659E-19  -2.33012604614893E-01  -2.33012604614893E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.42030052501162E-16   0.00000000000000E+00  -1.42030052501162E-16
      3.80705206305520E-18  -2.33014311733191E-01  -2.30282858989175E-01   0.00000000000000E+00  -9.06686655407624E-19
     -9.73605227634870E-23  -8.66980096801259E-09  -8.66980096891938E-09  -2.98279023866554E-18
      1.20058924687078E-07
      0.00000000000000E+00  -8.66977581344170E-12   0.00000000000000E+00   1.05218344937415E-18   1.51144407590537E-22
      8.66983498092367E-09   8.66983498197600E-09  -8.24261444166612E-19  -2.33012790153390E-01  -2.33012790153390E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.52196199974191E-16   0.00000000000000E+00  -5.52196199974191E-16
      3.80705095866280E-18  -2.33014354872336E-01  -2.30282891586352E-01   0.00000000000000E+00   2.55533819490484E-19
     -9.73605137133351E-23  -8.66983443003524E-09  -8.66983442977981E-09  -2.98278951449618E-18
      1.22058924687078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   1.36757585987630E-18   1.51144944368010E-22
      8.66988639426299E-09   8.66988639563072E-09  -8.24260833356466E-19  -2.33013098340305E-01  -2.33013098340305E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07405745749026E-15   0.00000000000000E+00  -1.07405745749026E-15
      3.80704881054788E-18  -2.33014298110292E-01  -2.30282818790447E-01   0.00000000000000E+00   2.24545065329805E-18
     -9.73604862115093E-23  -8.66988532381862E-09  -8.66988532157326E-09  -2.98278797719142E-18
      1.24058924687078E-07
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00   2.46783089692970E-18   1.51145587332497E-22
      8.66995723812233E-09   8.66995724059032E-09  -8.24259960362161E-19  -2.33013547717307E-01  -2.33013547717307E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.69961436984171E-15   0.00000000000000E+00  -1.69961436984171E-15
      3.80704541131914E-18  -2.33014105831178E-01  -2.30282604388326E-01   0.00000000000000E+00   4.02591362664751E-18
     -9.73604354694957E-23  -8.66995554500176E-09  -8.66995554097594E-09  -2.98278545095698E-18
      1.26058924687078E-07
      0.00000000000000E+00  -8.67005134765332E-12   0.00000000000000E+00   2.39577380906353E-18   1.51146313492821E-22
      8.67004815919702E-09   8.67004816159294E-09  -8.24258807807515E-19  -2.33014149802766E-01  -2.33014149802766E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.40667837541369E-15   0.00000000000000E+00  -2.40667837541369E-15
      3.80704059796239E-18  -2.33013741828155E-01  -2.30282211962403E-01   0.00000000000000E+00   7.49702059620728E-18
     -9.73603571433444E-23  -8.67004576241149E-09  -8.67004575491456E-09  -2.98278179015488E-18
      1.28058924687078E-07
      0.00000000000000E+00  -8.67014319239053E-12   0.00000000000000E+00   3.67944156763780E-18   1.51147081615966E-22
      8.67015797661802E-09   8.67015798029761E-09  -8.24257380268883E-19  -2.33014904965237E-01  -2.33014904965237E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.15529004012048E-15   0.00000000000000E+00  -3.15529004012048E-15
      3.80703428738231E-18  -2.33013172838757E-01  -2.30281608609649E-01   0.00000000000000E+00   9.97341055839621E-18
     -9.73602479684958E-23  -8.67015483498088E-09  -8.67015482500756E-09  -2.98277690711343E-18
      1.30058924687078E-07
      0.00000000000000E+00  -8.67023503712773E-12   0.00000000000000E+00   3.21635773105137E-18   1.51147828923196E-22
      8.67028304997598E-09   8.67028305319249E-09  -8.24255712916316E-19  -2.33015797752839E-01  -2.33015797752839E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.88456456361173E-15   0.00000000000000E+00  -3.88456456361173E-15
      3.80702651825318E-18  -2.33012373229735E-01  -2.30280769824576E-01   0.00000000000000E+00   1.43726731720555E-17
     -9.73601065524351E-23  -8.67027918300050E-09  -8.67027916862793E-09  -2.98277080533687E-18
      1.32058924687078E-07
      0.00000000000000E+00  -8.67041872660215E-12   0.00000000000000E+00   3.90707612633137E-18   1.51148468780819E-22
      8.67041663382897E-09   8.67041663773620E-09  -8.24253880543027E-19  -2.33016791937636E-01  -2.33016791937636E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.51032914709722E-15   0.00000000000000E+00  -4.51032914709722E-15
      3.80701749759489E-18  -2.33011330844718E-01  -2.30279685549496E-01   0.00000000000000E+00   1.73588469134365E-17
     -9.73599342916644E-23  -8.67041214476580E-09  -8.67041212740705E-09  -2.98276361705186E-18
      1.34058924687078E-07
      0.00000000000000E+00  -8.67051057133935E-12   0.00000000000000E+00   3.28759731845368E-18   1.51148889792634E-22
      8.67054829844003E-09   8.67054830172778E-09  -8.24252006188978E-19  -2.33017825681141E-01  -2.33017825681141E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.92432276390933E-15   0.00000000000000E+00  -4.92432276390933E-15
      3.80700764894936E-18  -2.33010053855180E-01  -2.30278367207775E-01   0.00000000000000E+00   2.10217427837666E-17
     -9.73597363883615E-23  -8.67054339842665E-09  -8.67054337740501E-09  -2.98275564276039E-18
      1.36058924687078E-07
      0.00000000000000E+00  -8.67069426081377E-12   0.00000000000000E+00   2.86699058650633E-18   1.51148957243511E-22
      8.67066348701904E-09   8.67066348988619E-09  -8.24250268308866E-19  -2.33018807366369E-01  -2.33018807366369E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.99546000708058E-15   0.00000000000000E+00  -4.99546000708058E-15
      3.80699765802935E-18  -2.33008578344551E-01  -2.30276855427801E-01   0.00000000000000E+00   2.31442464881080E-17
     -9.73595228791462E-23  -8.67065851757033E-09  -8.67065849442618E-09  -2.98274738972048E-18
      1.38058924687078E-07
      0.00000000000000E+00  -8.67078610555098E-12   0.00000000000000E+00   2.22488512149462E-18   1.51148517444679E-22
      8.67074332630090E-09   8.67074332852594E-09  -8.24248905119889E-19  -2.33019612814182E-01  -2.33019612814182E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.57410369522257E-15   0.00000000000000E+00  -4.57410369522257E-15
      3.80698850982196E-18  -2.33006976111614E-01  -2.30275227907440E-01   0.00000000000000E+00   2.35396442124628E-17
     -9.73593095987346E-23  -8.67073877796178E-09  -8.67073875442224E-09  -2.98273960470207E-18
      1.40058924687078E-07
      0.00000000000000E+00  -8.67069426081377E-12   0.00000000000000E+00   3.13843000227022E-18   1.51147405967720E-22
      8.67076480803169E-09   8.67076481117027E-09  -8.24248214492348E-19  -2.33020084755068E-01  -2.33020084755068E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.49999980242306E-15   0.00000000000000E+00  -3.49999980242306E-15
      3.80698150982235E-18  -2.33005361986844E-01  -2.30273606675689E-01   0.00000000000000E+00   1.95328183986594E-17
     -9.73591189238770E-23  -8.67076133070319E-09  -8.67076131117046E-09  -2.98273329533000E-18
      1.42058924687078E-07
      0.00000000000000E+00  -8.67069426081377E-12   0.00000000000000E+00   1.74433018439079E-19   1.51145460315783E-22
      8.67070147788939E-09   8.67070147806398E-09  -8.24248547624762E-19  -2.33020035510164E-01  -2.33020035510164E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.61456735572997E-15   0.00000000000000E+00  -1.61456735572997E-15
      3.80697828068764E-18  -2.33003899679535E-01  -2.30272163726612E-01   0.00000000000000E+00   1.57524548442267E-17
     -9.73589801558598E-23  -8.67069987924898E-09  -8.67069986349662E-09  -2.98272973306288E-18
      1.44058924687078E-07
      0.00000000000000E+00  -8.67051057133935E-12   0.00000000000000E+00   1.14051867231571E-17   1.51142537797480E-22
      8.67052476653603E-09   8.67052477794136E-09  -8.24250294384767E-19  -2.33019254025156E-01  -2.33019254025156E-01
      0.00000000000000E+00   0.00000000000000E+00   1.22171741094702E-15   0.00000000000000E+00   1.22171741094702E-15
      3.80698072412246E-18  -2.33002804956520E-01  -2.30271123784205E-01   0.00000000000000E+00  -6.75327074466191E-18
     -9.73589293257600E-23  -8.67052599290540E-09  -8.67052599965877E-09  -2.98273042973770E-18
      1.46058924687078E-07
      0.00000000000000E+00  -8.67023503712773E-12   0.00000000000000E+00  -2.36571466449073E-18   1.51138538359180E-22
      8.67020611711222E-09   8.67020611474666E-09  -8.24253858787068E-19  -2.33017518147695E-01  -2.33017518147695E-01
      0.00000000000000E+00   0.00000000000000E+00   5.10700132768711E-15   0.00000000000000E+00   5.10700132768711E-15
      3.80699093812512E-18  -2.33002344658376E-01  -2.30270762655327E-01   0.00000000000000E+00  -9.33376125249628E-18
     -9.73590082246994E-23  -8.67021121241413E-09  -8.67021122174799E-09  -2.98273707933805E-18
      1.48058924687078E-07
      0.00000000000000E+00  -8.66977581344170E-12   0.00000000000000E+00   3.32854677625280E-17   1.51133433344281E-22
      8.66971992845624E-09   8.66971996174186E-09  -8.24259622404104E-19  -2.33014613343529E-01  -2.33014613343529E-01
      0.00000000000000E+00   0.00000000000000E+00   1.00704759035601E-14   0.00000000000000E+00   1.00704759035601E-14
      3.80701107907693E-18  -2.33002830059083E-01  -2.30271399670729E-01   0.00000000000000E+00  -6.73829804992456E-17
     -9.73592624265252E-23  -8.66972996483468E-09  -8.66973003221775E-09  -2.98275145667282E-18
      1.50058924687078E-07
      0.00000000000000E+00  -8.66904105554404E-12   0.00000000000000E+00  -6.03465308858499E-18   1.51127296829798E-22
      8.66904755176642E-09   8.66904754573192E-09  -8.24267895523082E-19  -2.33010358125195E-01  -2.33010358125195E-01
      0.00000000000000E+00   0.00000000000000E+00   1.60407133237106E-14   0.00000000000000E+00   1.60407133237106E-14
      3.80704316050358E-18  -2.33004602650244E-01  -2.30273382220180E-01   0.00000000000000E+00  -5.52936428174208E-17
     -9.73597380860570E-23  -8.66906353115150E-09  -8.66906358644524E-09  -2.98277526498049E-18
      1.52058924687078E-07
      0.00000000000000E+00  -8.66821445290917E-12   0.00000000000000E+00   5.82796720788541E-17   1.51120342721598E-22
      8.66818196097888E-09   8.66818201925870E-09  -8.24278854729777E-19  -2.33004636907842E-01  -2.33004636907842E-01
      0.00000000000000E+00   0.00000000000000E+00   2.28117209852183E-14   0.00000000000000E+00   2.28117209852183E-14
      3.80708878394555E-18  -2.33008011170434E-01  -2.30277061320792E-01   0.00000000000000E+00  -1.53649310941384E-16
     -9.73604773750806E-23  -8.66820467733027E-09  -8.66820483097968E-09  -2.98280992921577E-18
      1.54058924687078E-07
      0.00000000000000E+00  -8.66711231606268E-12   0.00000000000000E+00  -1.39817122622988E-17   1.51112956994185E-22
      8.66713354908445E-09   8.66713353510289E-09  -8.24292469384025E-19  -2.32997439261235E-01  -2.32997439261235E-01
      0.00000000000000E+00   0.00000000000000E+00   3.00076819184435E-14   0.00000000000000E+00   3.00076819184435E-14
      3.80714879930938E-18  -2.33013377904995E-01  -2.30282756102173E-01   0.00000000000000E+00  -1.16453562889633E-16
     -9.73615123849715E-23  -8.66716342633115E-09  -8.66716354278481E-09  -2.98285632992535E-18
      1.56058924687078E-07
      0.00000000000000E+00  -8.66591833447898E-12   0.00000000000000E+00   4.96454626159118E-17   1.51105733681833E-22
      8.66593593638612E-09   8.66593598603174E-09  -8.24308418447247E-19  -2.32988904792461E-01  -2.32988904792461E-01
      0.00000000000000E+00   0.00000000000000E+00   3.70535739788519E-14   0.00000000000000E+00   3.70535739788519E-14
      3.80722290645734E-18  -2.33020954384060E-01  -2.30290707683095E-01   0.00000000000000E+00  -2.20618283235916E-16
     -9.73628576499501E-23  -8.66597281898734E-09  -8.66597303960572E-09  -2.98291448801009E-18
      1.58058924687078E-07
      0.00000000000000E+00  -8.66463250815807E-12   0.00000000000000E+00  -2.72750178084816E-17   1.51099493108599E-22
      8.66465246624992E-09   8.66465243897505E-09  -8.24326003707461E-19  -2.32979370750139E-01  -2.32979370750139E-01
      0.00000000000000E+00   0.00000000000000E+00   4.31498665073130E-14   0.00000000000000E+00   4.31498665073130E-14
      3.80730920619035E-18  -2.33030865407101E-01  -2.30301021158305E-01   0.00000000000000E+00  -1.76908139172360E-16
     -9.73645012604633E-23  -8.66469541193333E-09  -8.66469558884156E-09  -2.98298320248289E-18
      1.60058924687078E-07
      0.00000000000000E+00  -8.66343852657438E-12   0.00000000000000E+00  -1.21107865530556E-17   1.51095297133247E-22
      8.66338151869831E-09   8.66338150658768E-09  -8.24344066190087E-19  -2.32969418800561E-01  -2.32969418800561E-01
      0.00000000000000E+00   0.00000000000000E+00   4.72665151413337E-14   0.00000000000000E+00   4.72665151413337E-14
      3.80740373922064E-18  -2.33043043818034E-01  -2.30313598700380E-01   0.00000000000000E+00  -2.24574703836555E-16
     -9.73663952490251E-23  -8.66342854852802E-09  -8.66342877310282E-09  -2.98305967303055E-18
      1.62058924687078E-07
      0.00000000000000E+00  -8.66224454499068E-12   0.00000000000000E+00  -2.59997865815399E-17   1.51094431641103E-22
      8.66226106305452E-09   8.66226103705488E-09  -8.24360916137627E-19  -2.32959915633467E-01  -2.32959915633467E-01
      0.00000000000000E+00   0.00000000000000E+00   4.81514713823742E-14   0.00000000000000E+00   4.81514713823742E-14
      3.80750004216340E-18  -2.33057157750970E-01  -2.30328065369510E-01   0.00000000000000E+00  -2.24677383357904E-16
     -9.73684455392094E-23  -8.66230896384878E-09  -8.66230918852626E-09  -2.98313912602577E-18
      1.64058924687078E-07
      0.00000000000000E+00  -8.66150978709302E-12   0.00000000000000E+00   2.22218554110377E-17   1.51098370934306E-22
      8.66147050651732E-09   8.66147052873932E-09  -8.24374289147160E-19  -2.32952040763022E-01  -2.32952040763022E-01
      0.00000000000000E+00   0.00000000000000E+00   4.43719251928961E-14   0.00000000000000E+00   4.43719251928961E-14
      3.80758878601379E-18  -2.33072535601157E-01  -2.30343693488009E-01   0.00000000000000E+00  -2.72260782437997E-16
     -9.73705027555266E-23  -8.66151462840363E-09  -8.66151490066451E-09  -2.98321449686663E-18
      1.66058924687078E-07
      0.00000000000000E+00  -8.66123425288140E-12   0.00000000000000E+00   5.91343002315686E-17   1.51108697250817E-22
      8.66122915530721E-09   8.66122921444166E-09  -8.24381346184379E-19  -2.32947292197025E-01  -2.32947292197025E-01
      0.00000000000000E+00   0.00000000000000E+00   3.43896659685307E-14   0.00000000000000E+00   3.43896659685307E-14
      3.80765756534572E-18  -2.33088095401419E-01  -2.30359332478610E-01   0.00000000000000E+00  -2.79762146576938E-16
     -9.73723548826529E-23  -8.66126332434538E-09  -8.66126360410762E-09  -2.98327621916135E-18
      1.68058924687078E-07
      0.00000000000000E+00  -8.66178532130464E-12   0.00000000000000E+00   6.63187995447417E-16   1.51126983554774E-22
      8.66178990025104E-09   8.66179056343919E-09  -8.24378728549029E-19  -2.32947463561038E-01  -2.32947463561038E-01
      0.00000000000000E+00   0.00000000000000E+00   1.66732550113095E-14   0.00000000000000E+00   1.66732550113095E-14
      3.80769091185575E-18  -2.33102287618308E-01  -2.30373353614043E-01   0.00000000000000E+00  -8.21520764717409E-16
     -9.73737233608986E-23  -8.66180641517333E-09  -8.66180723669419E-09  -2.98331218330671E-18
      1.70058924687078E-07
      0.00000000000000E+00  -8.66343852657438E-12   0.00000000000000E+00   3.41385834479413E-16   1.51154615656642E-22
      8.66342725216350E-09   8.66342759354949E-09  -8.24362701754227E-19  -2.32954575424468E-01  -2.32954575424468E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01292359128900E-14   0.00000000000000E+00  -1.01292359128900E-14
      3.80767065338392E-18  -2.33113062090785E-01  -2.30383620671809E-01   0.00000000000000E+00  -3.96862456578511E-16
     -9.73742648557241E-23  -8.66341706745102E-09  -8.66341746431357E-09  -2.98330795162969E-18
      1.72058924687078E-07
      0.00000000000000E+00  -8.66637755816502E-12   0.00000000000000E+00   7.42946341861254E-17   1.51192578482398E-22
      8.66641660953579E-09   8.66641668383057E-09  -8.24329380259962E-19  -2.32970762700199E-01  -2.32970762700199E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.69886039283415E-14   0.00000000000000E+00  -4.69886039283415E-14
      3.80757667617606E-18  -2.33117875536457E-01  -2.30387503906640E-01   0.00000000000000E+00   2.75013154704434E-17
     -9.73735798660804E-23  -8.66636972272787E-09  -8.66636969522665E-09  -2.98324729591610E-18
      1.74058924687078E-07
      0.00000000000000E+00  -8.67106163976260E-12   0.00000000000000E+00   8.60120561585973E-16   1.51241189921238E-22
      8.67100690953444E-09   8.67100776965515E-09  -8.24275077047379E-19  -2.32998095923460E-01  -2.32998095923460E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.42209578153945E-14   0.00000000000000E+00  -9.42209578153945E-14
      3.80738823426043E-18  -2.33113751659175E-01  -2.30381948691313E-01   0.00000000000000E+00  -5.60938947530398E-16
     -9.73712313461991E-23  -8.67091298775828E-09  -8.67091354869732E-09  -2.98311315721305E-18
      1.76058924687078E-07
      0.00000000000000E+00  -8.67739892662992E-12   0.00000000000000E+00   1.58604395229485E-16   1.51299760637549E-22
      8.67738453613179E-09   8.67738469473634E-09  -8.24196773256513E-19  -2.33038337616318E-01  -2.33038337616318E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.51197932012064E-13   0.00000000000000E+00  -1.51197932012064E-13
      3.80708583839641E-18  -2.33097409632878E-01  -2.30363615279691E-01   0.00000000000000E+00   4.11964790063916E-16
     -9.73667747142409E-23  -8.67723390876902E-09  -8.67723349680433E-09  -2.98288906513990E-18
      1.78058924687078E-07
      0.00000000000000E+00  -8.68566495297860E-12   0.00000000000000E+00   1.34434705969928E-15   1.51366298314746E-22
      8.68562483113769E-09   8.68562617548490E-09  -8.24092703485331E-19  -2.33092633375916E-01  -2.33092633375915E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.16004755809296E-13   0.00000000000000E+00  -2.16004755809296E-13
      3.80665382888479E-18  -2.33065483841543E-01  -2.30329113711900E-01   0.00000000000000E+00  -4.91885537425606E-16
     -9.73598008854847E-23  -8.68540967884345E-09  -8.68541017072909E-09  -2.98256112539946E-18
      1.80058924687078E-07
      0.00000000000000E+00  -8.69567602933422E-12   0.00000000000000E+00   2.49255741465118E-16   1.51437111096401E-22
      8.69564266553884E-09   8.69564291479473E-09  -8.23963062081545E-19  -2.33161135739486E-01  -2.33161135739486E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.85135329115643E-13   0.00000000000000E+00  -2.85135329115643E-13
      3.80608355822656E-18  -2.33014834656421E-01  -2.30275330077216E-01   0.00000000000000E+00   9.77545172375587E-16
     -9.73499935728589E-23  -8.69535875701068E-09  -8.69535777946561E-09  -2.98212049614502E-18
      1.82058924687078E-07
      0.00000000000000E+00  -8.70715662148516E-12   0.00000000000000E+00   2.86360083089165E-16   1.51506575488527E-22
      8.70712866564067E-09   8.70712895200090E-09  -8.23810787962402E-19  -2.33242579816433E-01  -2.33242579816432E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.53160153517840E-13   0.00000000000000E+00  -3.53160153517840E-13
      3.80537723791952E-18  -2.32942976662057E-01  -2.30199874715936E-01   0.00000000000000E+00   1.30581738315574E-15
     -9.73372008108966E-23  -8.70677709766467E-09  -8.70677579184739E-09  -2.98156644995712E-18
      1.84058924687078E-07
      0.00000000000000E+00  -8.71946381627097E-12   0.00000000000000E+00   3.08338091096740E-16   1.51566871652803E-22
      8.71949250000012E-09   8.71949280833837E-09  -8.23642391458550E-19  -2.33333829512881E-01  -2.33333829512880E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.12531473746850E-13   0.00000000000000E+00  -4.12531473746850E-13
      3.80455217497203E-18  -2.32848608182213E-01  -2.30101629565835E-01   0.00000000000000E+00   1.62996600089140E-15
     -9.73215188488125E-23  -8.71908190683053E-09  -8.71908027686463E-09  -2.98090978351348E-18
      1.86058924687078E-07
      0.00000000000000E+00  -8.73177101105678E-12   0.00000000000000E+00   3.07167602345338E-16   1.51607924114256E-22
      8.73180434821465E-09   8.73180465538241E-09  -8.23468752128563E-19  -2.33429431220203E-01  -2.33429431220203E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.53469129935050E-13   0.00000000000000E+00  -4.53469129935050E-13
      3.80364523671216E-18  -2.32732243968577E-01  -2.29981399245169E-01   0.00000000000000E+00   1.91833485819084E-15
     -9.73033855171654E-23  -8.73135310458724E-09  -8.73135118625248E-09  -2.98017648458360E-18
      1.88058924687078E-07
      0.00000000000000E+00  -8.74279237952168E-12   0.00000000000000E+00   2.73283841290309E-16   1.51617526640631E-22
      8.74275092723785E-09   8.74275120052184E-09  -8.23305795030684E-19  -2.33521221887555E-01  -2.33521221887555E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.64051490096468E-13   0.00000000000000E+00  -4.64051490096468E-13
      3.80271713373197E-18  -2.32596921040262E-01  -2.29842630780362E-01   0.00000000000000E+00   2.12621682436776E-15
     -9.72836769282222E-23  -8.74228927524848E-09  -8.74228714903175E-09  -2.97941133870128E-18
      1.90058924687078E-07
      0.00000000000000E+00  -8.75059918218432E-12   0.00000000000000E+00   1.96577138151646E-16   1.51581730171947E-22
      8.75061345995765E-09   8.75061365653494E-09  -8.23174931136930E-19  -2.33598052749923E-01  -2.33598052749923E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.30561624714999E-13   0.00000000000000E+00  -4.30561624714999E-13
      3.80185601048253E-18  -2.32448933996424E-01  -2.29692155968227E-01   0.00000000000000E+00   2.19879968573696E-15
     -9.72637990500764E-23  -8.75018529370981E-09  -8.75018309491022E-09  -2.97868107934561E-18
      1.92058924687078E-07
      0.00000000000000E+00  -8.75326267956334E-12   0.00000000000000E+00   6.72524510963221E-17   1.51485550807071E-22
      8.75328055040169E-09   8.75328061765429E-09  -8.23103122685569E-19  -2.33645702986766E-01  -2.33645702986766E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.38162159941841E-13   0.00000000000000E+00  -3.38162159941841E-13
      3.80117968616265E-18  -2.32298531927834E-01  -2.29540884443960E-01   0.00000000000000E+00   2.07258877564979E-15
     -9.72457622777779E-23  -8.75294452808303E-09  -8.75294245549435E-09  -2.97807656347709E-18
      1.94058924687078E-07
      0.00000000000000E+00  -8.74830306375413E-12   0.00000000000000E+00  -1.22948993622220E-16   1.51314044907693E-22
      8.74831012027572E-09   8.74830999732688E-09  -8.23122414168046E-19  -2.33647069525823E-01  -2.33647069525823E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.71970825926402E-13   0.00000000000000E+00  -1.71970825926402E-13
      3.80083574451080E-18  -2.32160482977405E-01  -2.29404349066986E-01   0.00000000000000E+00   1.67819000028464E-15
     -9.72322236915663E-23  -8.74813970469086E-09  -8.74813802650095E-09  -2.97771333034275E-18
      1.96058924687078E-07
      0.00000000000000E+00  -8.73305683737768E-12   0.00000000000000E+00  -3.79360424550272E-16   1.51053784557032E-22
      8.73305504738495E-09   8.73305466802468E-09  -8.23268753823906E-19  -2.33582728776127E-01  -2.33582728776127E-01
      0.00000000000000E+00   0.00000000000000E+00   8.14009339695629E-14   0.00000000000000E+00   8.14009339695629E-14
      3.80099854637874E-18  -2.32054386080036E-01  -2.29302978561960E-01   0.00000000000000E+00   9.44998542146381E-16
     -9.72264782982216E-23  -8.73313701395709E-09  -8.73313606895865E-09  -2.97772979255483E-18
      1.98058924687078E-07
      0.00000000000000E+00  -8.70486050305497E-12   0.00000000000000E+00  -7.01517411810215E-16   1.50694751512873E-22
      8.70486566503542E-09   8.70486496351815E-09  -8.23579922356050E-19  -2.33431971618745E-01  -2.33431971618745E-01
      0.00000000000000E+00   0.00000000000000E+00   4.31803991822877E-13   0.00000000000000E+00   4.31803991822877E-13
      3.80186215436238E-18  -2.32004586262239E-01  -2.29261949662717E-01   0.00000000000000E+00  -1.93281989469847E-16
     -9.72323777116200E-23  -8.70529657422789E-09  -8.70529676750997E-09  -2.97828223200634E-18
      2.00058924687078E-07
      0.00000000000000E+00  -8.66141794235581E-12   0.00000000000000E+00  -1.08468172271350E-15   1.50232654093730E-22
      8.66137796802143E-09   8.66137688333986E-09  -8.24092389868915E-19  -2.33174411922791E-01  -2.33174411922792E-01
      0.00000000000000E+00   0.00000000000000E+00   8.82996078571730E-13   0.00000000000000E+00   8.82996078571730E-13
      3.80362814651953E-18  -2.32039535526555E-01  -2.29310457999189E-01   0.00000000000000E+00  -1.78627905936772E-15
     -9.72541531832743E-23  -8.66225809313926E-09  -8.66225987941842E-09  -2.97953575665061E-18
      2.02058924687078E-07
      0.00000000000000E+00  -8.60089226053605E-12   0.00000000000000E+00  -1.50699865465809E-15   1.49671660030075E-22
      8.60088850309417E-09   8.60088699609567E-09  -8.24836946399330E-19  -2.32792257126341E-01  -2.32792257126343E-01
      0.00000000000000E+00   0.00000000000000E+00   1.42962695762860E-12   0.00000000000000E+00   1.42962695762860E-12
      3.80648740043478E-18  -2.32190442499583E-01  -2.29480250581581E-01   0.00000000000000E+00  -3.86631248620481E-15
     -9.72961206300930E-23  -8.60231275674071E-09  -8.60231662305330E-09  -2.98165045403546E-18
      2.04058924687078E-07
      0.00000000000000E+00  -8.52282423390965E-12   0.00000000000000E+00  -1.95194153962557E-15   1.49027523434378E-22
      8.52280532805439E-09   8.52280337611299E-09  -8.25833007734039E-19  -2.32273300810915E-01  -2.32273300810917E-01
      0.00000000000000E+00   0.00000000000000E+00   2.05390201567638E-12   0.00000000000000E+00   2.05390201567638E-12
      3.81059520446614E-18  -2.32489077601722E-01  -2.29803289941227E-01   0.00000000000000E+00  -6.41032222055419E-15
     -9.73622495857657E-23  -8.52485086780635E-09  -8.52485727812867E-09  -2.98476219673210E-18
      2.06058924687078E-07
      0.00000000000000E+00  -8.42813230984869E-12   0.00000000000000E+00  -2.35996589881268E-15   1.48331052246723E-22
      8.42814986080974E-09   8.42814750084399E-09  -8.27081602756825E-19  -2.31614643136090E-01  -2.31614643136093E-01
      0.00000000000000E+00   0.00000000000000E+00   2.72217885357278E-12   0.00000000000000E+00   2.72217885357278E-12
      3.81603956217328E-18  -2.32964651780998E-01  -2.30308475823343E-01   0.00000000000000E+00  -9.37008505126133E-15
     -9.74555871206657E-23  -8.43086030961242E-09  -8.43086967969757E-09  -2.98895795941646E-18
      2.08058924687078E-07
      0.00000000000000E+00  -8.32003105415543E-12   0.00000000000000E+00  -2.70216997078658E-15   1.47631781898650E-22
      8.32006935809179E-09   8.32006665592197E-09  -8.28557222766362E-19  -2.30827054655307E-01  -2.30827054655311E-01
      0.00000000000000E+00   0.00000000000000E+00   3.38189292736972E-12   0.00000000000000E+00   3.38189292736972E-12
      3.82280334802802E-18  -2.33639766267161E-01  -2.31017434447653E-01   0.00000000000000E+00  -1.25805094462447E-14
     -9.75775429679241E-23  -8.32343596833979E-09  -8.32344854884933E-09  -2.99424612526166E-18
      2.10058924687078E-07
      0.00000000000000E+00  -8.20430668527395E-12   0.00000000000000E+00  -2.88852893654631E-15   1.47001554709853E-22
      8.20430782392286E-09   8.20430493539407E-09  -8.30198979090687E-19  -2.29939761190311E-01  -2.29939761190315E-01
      0.00000000000000E+00   0.00000000000000E+00   3.95936513228475E-12   0.00000000000000E+00   3.95936513228475E-12
      3.83072207829259E-18  -2.34525531586500E-01  -2.31939489849860E-01   0.00000000000000E+00  -1.58324397361130E-14
     -9.77270637028032E-23  -8.20824846808652E-09  -8.20826430052635E-09  -3.00052309920191E-18
      2.12058924687078E-07
      0.00000000000000E+00  -8.08959260850175E-12   0.00000000000000E+00  -2.86525087785141E-15   1.46537400236936E-22
      8.08957978196137E-09   8.08957691671064E-09  -8.31901892470855E-19  -2.29005233650387E-01  -2.29005233650392E-01
      0.00000000000000E+00   0.00000000000000E+00   4.35917932024522E-12   0.00000000000000E+00   4.35917932024522E-12
      3.83944043693308E-18  -2.35616059104022E-01  -2.33066037860029E-01   0.00000000000000E+00  -1.87627508095467E-14
     -9.78997510845487E-23  -8.09391733327998E-09  -8.09393609603088E-09  -3.00753854446223E-18
      2.14058924687078E-07
      0.00000000000000E+00  -7.98782863967581E-12   0.00000000000000E+00  -2.54309846182728E-15   1.46362648381797E-22
      7.98780017375857E-09   7.98779763066025E-09  -8.33509626199879E-19  -2.28103318065303E-01  -2.28103318065307E-01
      0.00000000000000E+00   0.00000000000000E+00   4.46590811755044E-12   0.00000000000000E+00   4.46590811755044E-12
      3.84837225316818E-18  -2.36882613778720E-01  -2.34364625884218E-01   0.00000000000000E+00  -2.09188771585282E-14
     -9.80870091430030E-23  -7.99224261990056E-09  -7.99226353877781E-09  -3.01486262696831E-18
      2.16058924687078E-07
      0.00000000000000E+00  -7.91416916043537E-12   0.00000000000000E+00  -1.83815029501671E-15   1.46624603203238E-22
      7.91414579307040E-09   7.91414395492025E-09  -8.34810537665019E-19  -2.27343758349290E-01  -2.27343758349294E-01
      0.00000000000000E+00   0.00000000000000E+00   4.14895208814752E-12   0.00000000000000E+00   4.14895208814752E-12
      3.85667015734448E-18  -2.38267757150456E-01  -2.35773075012302E-01   0.00000000000000E+00  -2.17292029200981E-14
     -9.82753306710472E-23  -7.91827117780537E-09  -7.91829290700839E-09  -3.02185961967946E-18
      2.18058924687078E-07
      0.00000000000000E+00  -7.88698311822195E-12   0.00000000000000E+00  -6.88461668789768E-16   1.47486482215818E-22
      7.88695137460246E-09   7.88695068614094E-09  -8.35539445751622E-19  -2.26865901381826E-01  -2.26865901381829E-01
      0.00000000000000E+00   0.00000000000000E+00   3.27112965720344E-12   0.00000000000000E+00   3.27112965720344E-12
      3.86321241665888E-18  -2.39679795082165E-01  -2.37193957791740E-01   0.00000000000000E+00  -2.05166999915263E-14
     -9.84458478879232E-23  -7.89020129909805E-09  -7.89022181579814E-09  -3.02767297090727E-18
      2.20058924687078E-07
      0.00000000000000E+00  -7.92748664733046E-12   0.00000000000000E+00   1.00191850703593E-15   1.49110945270425E-22
      7.92746004655116E-09   7.92746104846981E-09  -8.35387766328954E-19  -2.26834233099213E-01  -2.26834233099215E-01
      0.00000000000000E+00   0.00000000000000E+00   1.70137639516335E-12   0.00000000000000E+00   1.70137639516335E-12
      3.86661516944921E-18  -2.40987798319491E-01  -2.38489693403632E-01   0.00000000000000E+00  -1.66176187536324E-14
     -9.85742656528949E-23  -7.92914580724612E-09  -7.92916242486498E-09  -3.03122740312026E-18
      2.22058924687078E-07
      0.00000000000000E+00  -8.05937568996047E-12   0.00000000000000E+00   3.21112805347827E-15   1.51632836020319E-22
      8.05942748383781E-09   8.05943069496601E-09  -8.34024294863902E-19  -2.27428529517498E-01  -2.27428529517497E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.68524067791535E-13   0.00000000000000E+00  -6.68524067791535E-13
      3.86527812131363E-18  -2.42017458434066E-01  -2.39478523038282E-01   0.00000000000000E+00  -9.32314180716695E-15
     -9.86312619356320E-23  -8.05875284775631E-09  -8.05876217089822E-09  -3.03125382644973E-18
      2.24058924687078E-07
      0.00000000000000E+00  -8.30845861726729E-12   0.00000000000000E+00   6.20158862921284E-15   1.55120376183026E-22
      8.30849470301455E-09   8.30850090460333E-09  -8.31127499334748E-19  -2.28827995806928E-01  -2.28827995806924E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.90388922183572E-12   0.00000000000000E+00  -3.90388922183572E-12
      3.85747034286996E-18  -2.42548201052423E-01  -2.39931814392130E-01   0.00000000000000E+00   1.59748107091532E-15
     -9.85833806652771E-23  -8.30459861286248E-09  -8.30459701538151E-09  -3.02634284353521E-18
      2.26058924687078E-07
      0.00000000000000E+00  -8.70109486882946E-12   0.00000000000000E+00   9.38517808499313E-15   1.59527605116352E-22
      8.70108734096097E-09   8.70109672613921E-09  -8.26427497637056E-19  -2.31189929898741E-01  -2.31189929898733E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.00542070025536E-12   0.00000000000000E+00  -8.00542070025536E-12
      3.84145950146945E-18  -2.42312441470269E-01  -2.39573657199161E-01   0.00000000000000E+00   1.68871259229224E-14
     -9.83943735359952E-23  -8.69310819256478E-09  -8.69309130543895E-09  -3.01503200383239E-18
      2.28058924687078E-07
      0.00000000000000E+00  -9.26244990264187E-12   0.00000000000000E+00   1.39781611811060E-14   1.64646474525716E-22
      9.26239649222687E-09   9.26241047038822E-09  -8.19752284824900E-19  -2.34625103392665E-01  -2.34625103392652E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.28888033597238E-11   0.00000000000000E+00  -1.28888033597238E-11
      3.81568189475000E-18  -2.40998718439019E-01  -2.38084626704827E-01   0.00000000000000E+00   3.50305542976164E-14
     -9.80269166678933E-23  -9.24955669758268E-09  -9.24952166702848E-09  -2.99592960992510E-18
      2.30058924687077E-07
      0.00000000000000E+00  -1.00128214056274E-11   0.00000000000000E+00   1.86823384005805E-14   1.70072726331906E-22
      1.00128399204150E-08   1.00128586027536E-08  -8.11069646384130E-19  -2.39173732663424E-01  -2.39173732663405E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.83702684129424E-11   0.00000000000000E+00  -1.83702684129424E-11
      3.77894135792412E-18  -2.38261584924543E-01  -2.35112784761098E-01   0.00000000000000E+00   5.64332250914200E-14
     -9.74447299197517E-23  -9.99454476756561E-09  -9.99448833434061E-09  -2.96787171153999E-18
      2.32058924687077E-07
      0.00000000000000E+00  -1.09624041436160E-11   0.00000000000000E+00   2.36294328049203E-14   1.75201295357952E-22
      1.09624035843483E-08   1.09624272137813E-08  -8.00515724913743E-19  -2.44786743897600E-01  -2.44786743897576E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.41636015740198E-11   0.00000000000000E+00  -2.41636015740198E-11
      3.73061415477608E-18  -2.33742260333999E-01  -2.30296113854027E-01   0.00000000000000E+00   7.94176815251526E-14
     -9.66154833673424E-23  -1.09383430298887E-08  -1.09382636122073E-08  -2.93009842986233E-18
      2.34058924687077E-07
      0.00000000000000E+00  -1.21025647113102E-11   0.00000000000000E+00   2.83589227594456E-14   1.79258870937134E-22
      1.21025270159302E-08   1.21025553748531E-08  -7.88405491397317E-19  -2.51315921636020E-01  -2.51315921635990E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.98917728566349E-11   0.00000000000000E+00  -2.98917728566349E-11
      3.67083060906281E-18  -2.27104647732895E-01  -2.23301094619865E-01   0.00000000000000E+00   1.02195940054637E-13
     -9.55155589076369E-23  -1.20727657979365E-08  -1.20726636019965E-08  -2.88242511766549E-18
      2.36058924687077E-07
      0.00000000000000E+00  -1.33957386111922E-11   0.00000000000000E+00   3.21538232845261E-14   1.81366489418306E-22
      1.33957021142196E-08   1.33957342680431E-08  -7.75229120486377E-19  -2.58512919484531E-01  -2.58512919484496E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.51065733305061E-11   0.00000000000000E+00  -3.51065733305061E-11
      3.60061746240179E-18  -2.18090924216835E-01  -2.13881579567498E-01   0.00000000000000E+00   1.22561946943091E-13
     -9.41384673569238E-23  -1.33607502566594E-08  -1.33606276947126E-08  -2.82538834191542E-18
      2.38058924687077E-07
      0.00000000000000E+00  -1.47637659718983E-11   0.00000000000000E+00   3.40085341427399E-14   1.80623416193334E-22
      1.47637753058006E-08   1.47638093143349E-08  -7.61647946071498E-19  -2.66031794949221E-01  -2.66031794949181E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.92923243662956E-11   0.00000000000000E+00  -3.92923243662956E-11
      3.52203281366920E-18  -2.06598915131351E-01  -2.01959854324939E-01   0.00000000000000E+00   1.38157763027146E-13
     -9.25086784953615E-23  -1.47246551477315E-08  -1.47245169899686E-08  -2.76038486759771E-18
      2.40058924687077E-07
      0.00000000000000E+00  -1.60774212481776E-11   0.00000000000000E+00   3.26565442547442E-14   1.76245326524042E-22
      1.60774036822226E-08   1.60774363387670E-08  -7.48508399151843E-19  -2.73425361323856E-01  -2.73425361323814E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.18169784902728E-11   0.00000000000000E+00  -4.18169784902728E-11
      3.43839885668866E-18  -1.92778628159479E-01  -1.87726478647824E-01   0.00000000000000E+00   1.47047932567489E-13
     -9.06999169190742E-23  -1.60357664082092E-08  -1.60356193602768E-08  -2.68989045753681E-18
      2.42058924687077E-07
      0.00000000000000E+00  -1.71510862261335E-11   0.00000000000000E+00   2.67069976335271E-14   1.67838971334019E-22
      1.71510807279886E-08   1.71511074349864E-08  -7.36887817953452E-19  -2.80126115089702E-01  -2.80126115089660E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.18253182449454E-11   0.00000000000000E+00  -4.18253182449454E-11
      3.35474822019877E-18  -1.77136738494466E-01  -1.71746305439836E-01   0.00000000000000E+00   1.48449170446448E-13
     -8.88493355204697E-23  -1.71094305659118E-08  -1.71092821167414E-08  -2.61786040224532E-18
      2.44058924687077E-07
      0.00000000000000E+00  -1.77495465337778E-11   0.00000000000000E+00   1.49263038574693E-14   1.55769067851186E-22
      1.77495568523858E-08   1.77495717786898E-08  -7.28168708891888E-19  -2.85412190912883E-01  -2.85412190912844E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.81783123290511E-11   0.00000000000000E+00  -3.81783123290511E-11
      3.27839159554066E-18  -1.60626717581900E-01  -1.55046567541924E-01   0.00000000000000E+00   1.42834264225632E-13
     -8.71413180689483E-23  -1.77115363006249E-08  -1.77113934663607E-08  -2.55022288664878E-18
      2.46058924687077E-07
      0.00000000000000E+00  -1.76159124411408E-11   0.00000000000000E+00  -3.22558077128467E-15   1.41240411444201E-22
      1.76159237729101E-08   1.76159205473295E-08  -7.24097380502690E-19  -2.88380082629738E-01  -2.88380082629708E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.96215322425176E-11   0.00000000000000E+00  -2.96215322425176E-11
      3.21914853105563E-18  -1.44682805142535E-01  -1.39142054127635E-01   0.00000000000000E+00   1.30707484005716E-13
     -8.57359630044458E-23  -1.75864297225709E-08  -1.75862990150869E-08  -2.49505115055294E-18
      2.48058924687077E-07
      0.00000000000000E+00  -1.65427066868709E-11   0.00000000000000E+00  -2.65287306183824E-14   1.25800654678316E-22
      1.65427674506542E-08   1.65427409219237E-08  -7.26726274614320E-19  -2.87967032347956E-01  -2.87967032347941E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.51968601661381E-11   0.00000000000000E+00  -1.51968601661381E-11
      3.18875481072335E-18  -1.31114947263187E-01  -1.25907760016021E-01   0.00000000000000E+00   1.10819425864716E-13
     -8.47308598782569E-23  -1.65276548811833E-08  -1.65275440617575E-08  -2.46202853610903E-18
      2.50058924687077E-07
      0.00000000000000E+00  -1.44865785550060E-11   0.00000000000000E+00  -5.09344502614979E-14   1.10589406960550E-22
      1.44866273813928E-08   1.44865764469427E-08  -7.38165932917940E-19  -2.83049882256597E-01  -2.83049882256602E-01
      0.00000000000000E+00   0.00000000000000E+00   5.31958319425642E-12   0.00000000000000E+00   5.31958319425642E-12
      3.19939397711187E-18  -1.21782686251883E-01  -1.17216850159577E-01   0.00000000000000E+00   7.94567673909714E-14
     -8.42822731480714E-23  -1.44919754869042E-08  -1.44918960301369E-08  -2.46122804419393E-18
      2.52058924687077E-07
      0.00000000000000E+00  -1.16486680200306E-11   0.00000000000000E+00  -6.47142403225451E-14   9.56155501481458E-23
      1.16486544557269E-08   1.16485897414866E-08  -7.60253612916059E-19  -2.72582877069336E-01  -2.72582877069367E-01
      0.00000000000000E+00   0.00000000000000E+00   3.11000525035090E-11   0.00000000000000E+00   3.11000525035090E-11
      3.26159408211888E-18  -1.18118144828311E-01  -1.14438330682072E-01   0.00000000000000E+00   2.54152837464276E-14
     -8.46438706268840E-23  -1.16797152092738E-08  -1.16796897939901E-08  -2.50134046920282E-18
      2.54058924687077E-07
      0.00000000000000E+00  -8.44347038096235E-12   0.00000000000000E+00  -7.96892066760490E-14   7.92345860354507E-23
      8.44355032133880E-09   8.44347063213220E-09  -7.94368931512272E-19  -2.55707236922952E-01  -2.55707236923012E-01
      0.00000000000000E+00   0.00000000000000E+00   6.01451874086458E-11   0.00000000000000E+00   6.01451874086458E-11
      3.38188445693617E-18  -1.20719123736220E-01  -1.18039971121464E-01   0.00000000000000E+00  -3.98940417828216E-14
     -8.59249382813535E-23  -8.50357592549898E-09  -8.50361581954085E-09  -2.58751552542390E-18
      2.56058924687077E-07
      0.00000000000000E+00  -5.38485694247729E-12   0.00000000000000E+00  -7.63739475404482E-14   5.87245913998865E-23
      5.38493048270763E-09   5.38485410876014E-09  -8.41503835931752E-19  -2.31833420797402E-01  -2.31833420797492E-01
      0.00000000000000E+00   0.00000000000000E+00   8.93271984005201E-11   0.00000000000000E+00   8.93271984005201E-11
      3.56053885373721E-18  -1.29174216817516E-01  -1.27449525865420E-01   0.00000000000000E+00  -1.39879754033836E-13
     -8.80944462010715E-23  -5.47404142740654E-09  -5.47418130716066E-09  -2.71903501780546E-18
      2.58058924687077E-07
      0.00000000000000E+00  -2.93076556429218E-12   0.00000000000000E+00  -6.18628761888232E-14   3.25545190445791E-23
      2.93078071831550E-09   2.93071885543934E-09  -9.02459803735987E-19  -2.00774448239166E-01  -2.00774448239280E-01
      0.00000000000000E+00   0.00000000000000E+00   1.14530020970932E-10   0.00000000000000E+00   1.14530020970932E-10
      3.78959889567908E-18  -1.42193359671244E-01  -1.41233931793252E-01   0.00000000000000E+00  -2.75114847813630E-13
     -9.13389538211028E-23  -3.04497376156237E-09  -3.04524887641027E-09  -2.88713909194309E-18
      2.60058924687077E-07
      0.00000000000000E+00  -1.31337974206763E-12   0.00000000000000E+00  -4.17367250817904E-14   2.92691103524722E-24
      1.31346473350594E-09   1.31342299678086E-09  -9.77872154616752E-19  -1.62906173616064E-01  -1.62906173616196E-01
      0.00000000000000E+00   0.00000000000000E+00   1.31862566241754E-10   0.00000000000000E+00   1.31862566241754E-10
      4.05332402816259E-18  -1.58065936688271E-01  -1.57610592513079E-01   0.00000000000000E+00  -4.50022006340713E-13
     -9.58568551639012E-23  -1.44483554101618E-09  -1.44528556302261E-09  -3.07545187354583E-18
      2.62058924687077E-07
      0.00000000000000E+00  -4.63081165000350E-13   0.00000000000000E+00  -2.34354774111023E-14  -2.27423813303711E-23
      4.63123768993185E-10   4.63100333515751E-10  -1.06701723198964E-18  -1.19400517164120E-01  -1.19400517164260E-01
      0.00000000000000E+00   0.00000000000000E+00   1.39791476373703E-10   0.00000000000000E+00   1.39791476373703E-10
      4.33290698090999E-18  -1.75255581261539E-01  -1.75065638909733E-01   0.00000000000000E+00  -6.55742337162644E-13
     -1.01245007288517E-22  -6.02236067552189E-10  -6.02891809889453E-10  -3.26588974892036E-18
      2.64058924687077E-07
      0.00000000000000E+00  -1.23531171544123E-13   0.00000000000000E+00  -1.13182111736567E-14  -3.70543157641004E-23
      1.23532502016155E-10   1.23521183804944E-10  -1.16089428139447E-18  -7.46154986757548E-02  -7.46154986758900E-02
      0.00000000000000E+00   0.00000000000000E+00   1.35152565165937E-10   0.00000000000000E+00   1.35152565165937E-10
      4.60321211124187E-18  -1.92764299271537E-01  -1.92682803959476E-01   0.00000000000000E+00  -8.23098832593093E-13
     -1.06706579211754E-22  -2.57850650138182E-10  -2.58673748970882E-10  -3.44231782984740E-18
      2.66058924687077E-07
      0.00000000000000E+00  -3.61868264597655E-14   0.00000000000000E+00  -4.57580422441406E-15  -4.17964295153149E-23
      3.62297124351074E-11   3.62251366308412E-11  -1.23410340378063E-18  -4.03260573036039E-02  -4.03260573037118E-02
      0.00000000000000E+00   0.00000000000000E+00   1.07897027764391E-10   0.00000000000000E+00   1.07897027764391E-10
      4.81900616677065E-18  -2.10139203861526E-01  -2.10093798220568E-01   0.00000000000000E+00  -7.69741530060433E-13
     -1.11139581128239E-22  -1.43352422865060E-10  -1.44122164395232E-10  -3.58490276299002E-18
      2.68058924687077E-07
      0.00000000000000E+00  -2.98495395924462E-14   0.00000000000000E+00  -1.33036207694933E-15  -4.22532979177872E-23
      2.98517235347496E-11   2.98503931726304E-11  -1.27537225394333E-18  -2.18595096591318E-02  -2.18595096592039E-02
      0.00000000000000E+00   0.00000000000000E+00   7.20968105931653E-11   0.00000000000000E+00   7.20968105931653E-11
      4.96319978795698E-18  -2.27243814944351E-01  -2.27211696753599E-01   0.00000000000000E+00  -5.49504593600410E-13
     -1.14084587315516E-22  -1.01397699172081E-10  -1.01947203765796E-10  -3.68782753401364E-18
      2.70058924687077E-07
      0.00000000000000E+00  -3.82992554155387E-14   0.00000000000000E+00  -1.07043706168990E-16  -4.05374443111567E-23
      3.83442357498844E-11   3.83441287061377E-11  -1.29494508393740E-18  -1.36540552639578E-02  -1.36540552640050E-02
      0.00000000000000E+00   0.00000000000000E+00   4.72622658316867E-11   0.00000000000000E+00   4.72622658316867E-11
      5.05772431962036E-18  -2.44035104657382E-01  -2.44008134849640E-01   0.00000000000000E+00  -3.89290585275732E-13
     -1.16097012117336E-22  -8.52171039524328E-11  -8.56063945378247E-11  -3.76277923568296E-18
      2.72058924687077E-07
      0.00000000000000E+00  -4.71163501874612E-14   0.00000000000000E+00   2.41357902367506E-16  -3.68357157881228E-23
      4.71652579553262E-11   4.71654993131918E-11  -1.30347940706224E-18  -1.01542428276617E-02  -1.01542428276952E-02
      0.00000000000000E+00   0.00000000000000E+00   3.34772444451263E-11   0.00000000000000E+00   3.34772444451263E-11
      5.12467880851061E-18  -2.60498671648135E-01  -2.60473265815685E-01   0.00000000000000E+00  -3.21729283326364E-13
     -1.17726118726516E-22  -8.03210144748739E-11  -8.06427437583180E-11  -3.82119940144836E-18
      2.74058924687077E-07
      0.00000000000000E+00  -5.44639291640634E-14   0.00000000000000E+00   2.82356365644562E-16  -3.09168341929103E-23
      5.44783156392457E-11   5.44785979955805E-11  -1.30687990692005E-18  -8.53356419918018E-03  -8.53356419920619E-03
      0.00000000000000E+00   0.00000000000000E+00   2.60167804765982E-11   0.00000000000000E+00   2.60167804765982E-11
      5.17671236946381E-18  -2.76632337806765E-01  -2.76606978567745E-01   0.00000000000000E+00  -3.02101954683119E-13
     -1.19231499587757E-22  -8.01932765173773E-11  -8.04953784721796E-11  -3.86983246254376E-18
      2.76058924687077E-07
      0.00000000000000E+00  -6.05256818197601E-14   0.00000000000000E+00   2.50458037458443E-16  -2.25554622376465E-23
      6.05374270606853E-11   6.05376775187002E-11  -1.30789945654598E-18  -7.65399926031252E-03  -7.65399926033423E-03
      0.00000000000000E+00   0.00000000000000E+00   2.17071830879592E-11   0.00000000000000E+00   2.17071830879592E-11
      5.22012673563972E-18  -2.92438065511602E-01  -2.92412155271397E-01   0.00000000000000E+00  -2.99600882774958E-13
     -1.20701660303073E-22  -8.19452597237623E-11  -8.22448606066580E-11  -3.91222727909374E-18
      2.78058924687077E-07
      0.00000000000000E+00  -6.57608318405892E-14   0.00000000000000E+00   2.11931555240526E-16  -1.16901881246786E-23
      6.57508480012601E-11   6.57510599328037E-11  -1.30777639315460E-18  -7.09830484833631E-03  -7.09830484835529E-03
      0.00000000000000E+00   0.00000000000000E+00   1.89763962874188E-11   0.00000000000000E+00   1.89763962874188E-11
      5.25807952821456E-18  -3.07917370268608E-01  -3.07890678070233E-01   0.00000000000000E+00  -3.01773159676205E-13
     -1.22160031471825E-22  -8.44256830604251E-11  -8.47274562202235E-11  -3.95030313505996E-18
      2.80058924687077E-07
      0.00000000000000E+00  -7.04449134381730E-14   0.00000000000000E+00   1.82807353968910E-16   1.44294216374632E-24
      7.04194515336817E-11   7.04196343410371E-11  -1.30708399939387E-18  -6.71243777877821E-03  -6.71243777879531E-03
      0.00000000000000E+00   0.00000000000000E+00   1.70962352199620E-11   0.00000000000000E+00   1.70962352199620E-11
      5.29227199865448E-18  -3.23071267858457E-01  -3.23043697365098E-01   0.00000000000000E+00  -3.04859445891993E-13
     -1.23611167345663E-22  -8.72110101149832E-11  -8.75158695609988E-11  -3.98518799926061E-18
      2.82058924687077E-07
      0.00000000000000E+00  -7.47616160869268E-14   0.00000000000000E+00   1.63496229119780E-16   1.58029062336827E-23
      7.47436633971493E-11   7.47438268933942E-11  -1.30610064398371E-18  -6.43320827529504E-03  -6.43320827531076E-03
      0.00000000000000E+00   0.00000000000000E+00   1.57189394312776E-11   0.00000000000000E+00   1.57189394312776E-11
      5.32370987751704E-18  -3.37906700187147E-01  -3.37878201479561E-01   0.00000000000000E+00  -3.08228454516180E-13
     -1.25056513499657E-22  -9.01545378700308E-11  -9.04627663246720E-11  -4.01760923353333E-18
      2.84058924687077E-07
      0.00000000000000E+00  -7.88946292612655E-14   0.00000000000000E+00   1.51779265642534E-16   3.03674754805811E-23
      7.88581080013001E-11   7.88582597805961E-11  -1.30496531882858E-18  -6.23022522686727E-03  -6.23022522688194E-03
      0.00000000000000E+00   0.00000000000000E+00   1.46656324354478E-11   0.00000000000000E+00   1.46656324354478E-11
      5.35304114238794E-18  -3.52442556504088E-01  -3.52413093605738E-01   0.00000000000000E+00  -3.12206398286405E-13
     -1.26499035157189E-22  -9.32116858176314E-11  -9.35238922160444E-11  -4.04807582355936E-18
      2.86058924687077E-07
      0.00000000000000E+00  -8.28439529611891E-14   0.00000000000000E+00   1.45383796630886E-16   4.44608066036940E-23
      8.28621299529803E-11   8.28622753368214E-11  -1.30374446995675E-18  -6.08708685779475E-03  -6.08708685780860E-03
      0.00000000000000E+00   0.00000000000000E+00   1.38497092583325E-11   0.00000000000000E+00   1.38497092583325E-11
      5.38074056090460E-18  -3.66729326235773E-01  -3.66698859158053E-01   0.00000000000000E+00  -3.17839856297860E-13
     -1.27946291629329E-22  -9.63941447387281E-11  -9.67119845951539E-11  -4.07699609094784E-18
      2.88058924687077E-07
      0.00000000000000E+00  -8.67932766611128E-14   0.00000000000000E+00   1.42496863882399E-16   5.75148837457307E-23
      8.68200451310926E-11   8.68201876280140E-11  -1.30246883932968E-18  -5.99509949071004E-03  -5.99509949072321E-03
      0.00000000000000E+00   0.00000000000000E+00   1.31697084328647E-11   0.00000000000000E+00   1.31697084328647E-11
      5.40707997777033E-18  -3.80777081562288E-01  -3.80745582021566E-01   0.00000000000000E+00  -3.24100158406424E-13
     -1.29400739735416E-22  -9.96657959023422E-11  -9.99898960608781E-11  -4.10461113844065E-18
      2.90058924687077E-07
      0.00000000000000E+00  -9.07426003610364E-14   0.00000000000000E+00   1.42121626811655E-16   6.91533799878131E-23
      9.07782426869730E-11   9.07783848086690E-11  -1.30114805687924E-18  -5.95138902141531E-03  -5.95138902142786E-03
      0.00000000000000E+00   0.00000000000000E+00   1.25530085811246E-11   0.00000000000000E+00   1.25530085811246E-11
      5.43218599493258E-18  -3.94565442942891E-01  -3.94532890921510E-01   0.00000000000000E+00  -3.30117600161508E-13
     -1.30860766178182E-22  -1.03001275789501E-10  -1.03331393389794E-10  -4.13103793805334E-18
      2.92058924687077E-07
      0.00000000000000E+00  -9.47837687981676E-14   0.00000000000000E+00   1.44334744561487E-16   7.92278232558000E-23
      9.47870913380113E-11   9.47872356728351E-11  -1.29977279666508E-18  -5.95933830420523E-03  -5.95933830421720E-03
      0.00000000000000E+00   0.00000000000000E+00   1.19694660408178E-11   0.00000000000000E+00   1.19694660408178E-11
      5.45612492701421E-18  -4.08084126043148E-01  -4.08050495152755E-01   0.00000000000000E+00  -3.36098604870709E-13
     -1.32325626043093E-22  -1.06420603108650E-10  -1.06756701713653E-10  -4.15635213034914E-18
      2.94058924687077E-07
      0.00000000000000E+00  -9.89167819725063E-14   0.00000000000000E+00   1.50193219984827E-16   8.77955350094613E-23
      9.89204469225242E-11   9.89205971158320E-11  -1.29831080188528E-18  -6.03162118057343E-03  -6.03162118058482E-03
      0.00000000000000E+00   0.00000000000000E+00   1.13921048915312E-11   0.00000000000000E+00   1.13921048915312E-11
      5.47890913679728E-18  -4.21332176849663E-01  -4.21297425934335E-01   0.00000000000000E+00  -3.42023751735081E-13
     -1.33794260308684E-22  -1.09970678255494E-10  -1.10312702007363E-10  -4.18059833491200E-18
      2.96058924687077E-07
      0.00000000000000E+00  -1.03325329358468E-13   0.00000000000000E+00   1.63635370339146E-16   9.50791253953575E-23
      1.03312608606767E-10   1.03312772242232E-10  -1.29669034546713E-18  -6.19839417263303E-03  -6.19839417264381E-03
      0.00000000000000E+00   0.00000000000000E+00   1.07803797788665E-11   0.00000000000000E+00   1.07803797788665E-11
      5.50046989635501E-18  -4.34312426097319E-01  -4.34276484467613E-01   0.00000000000000E+00  -3.47343264390452E-13
     -1.35263085908856E-22  -1.13745808756573E-10  -1.14093152021098E-10  -4.20377955088788E-18
      2.98058924687077E-07
      0.00000000000000E+00  -1.08284945167674E-13   0.00000000000000E+00   1.88507582157167E-16   1.01460279433526E-22
      1.08251382583075E-10   1.08251571090759E-10  -1.29475351341993E-18  -6.52870710629645E-03  -6.52870710630650E-03
      0.00000000000000E+00   0.00000000000000E+00   1.00552752679786E-11   0.00000000000000E+00   1.00552752679786E-11
      5.52058044689097E-18  -4.47028677975705E-01  -4.46991409169986E-01   0.00000000000000E+00  -3.50555574306720E-13
     -1.36722235111476E-22  -1.17956290784294E-10  -1.18306846358738E-10  -4.22582693347104E-18
      3.00058924687077E-07
      0.00000000000000E+00  -1.14438542560578E-13   0.00000000000000E+00   2.45048385470810E-16   1.07597855947494E-22
      1.14447432494066E-10   1.14447677542559E-10  -1.29212293394490E-18  -7.19084019734699E-03  -7.19084019735601E-03
      0.00000000000000E+00   0.00000000000000E+00   9.02621130942833E-12   0.00000000000000E+00   9.02621130942833E-12
      5.53863286950982E-18  -4.59484166183324E-01  -4.59445269904766E-01   0.00000000000000E+00  -3.47764582772942E-13
     -1.38146263079291E-22  -1.23126124269077E-10  -1.23473888851988E-10  -4.24650993556492E-18
      3.02058924687077E-07
      0.00000000000000E+00  -1.23898550492954E-13   0.00000000000000E+00   4.01406187395211E-16   1.14926042535867E-22
      1.23917356456664E-10   1.23917757862966E-10  -1.28779390547202E-18  -8.63619569692761E-03  -8.63619569693477E-03
      0.00000000000000E+00   0.00000000000000E+00   7.15810959483194E-12   0.00000000000000E+00   7.15810959483194E-12
      5.55294908869949E-18  -4.71679381099118E-01  -4.71638090345752E-01   0.00000000000000E+00  -3.27819752403957E-13
     -1.39466358388992E-22  -1.30748047705254E-10  -1.31075867457798E-10  -4.26515518322747E-18
      3.04058924687077E-07
      0.00000000000000E+00  -1.43002255832119E-13   0.00000000000000E+00   8.10357563846743E-16   1.27222667466428E-22
      1.42971957062201E-10   1.42972767419892E-10  -1.27894777226781E-18  -1.21254814515153E-02  -1.21254814515182E-02
      0.00000000000000E+00   0.00000000000000E+00   2.91050762626893E-12   0.00000000000000E+00   2.91050762626893E-12
      5.55877010395202E-18  -4.83605621848545E-01  -4.83559666875521E-01   0.00000000000000E+00  -2.58588319892373E-13
     -1.40491014742546E-22  -1.45624686726130E-10  -1.45883275046163E-10  -4.27982233168421E-18
      3.06058924687077E-07
      0.00000000000000E+00  -1.89475692859128E-13   0.00000000000000E+00   1.88437823680688E-15   1.52602387544723E-22
      1.89438688950327E-10   1.89440573328716E-10  -1.25930851675735E-18  -2.03767499078939E-02  -2.03767499078872E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.67401990560887E-12   0.00000000000000E+00  -6.67401990560887E-12
      5.54542206414081E-18  -4.95225518181926E-01  -4.95167944919533E-01   0.00000000000000E+00  -8.32864397340504E-14
     -1.40813076752504E-22  -1.82683266983232E-10  -1.82766553423107E-10  -4.28611354738346E-18
      3.08058924687077E-07
      0.00000000000000E+00  -2.93443935378048E-13   0.00000000000000E+00   3.77075403405404E-15   1.93957872981128E-22
      2.93445636029866E-10   2.93449406784094E-10  -1.22409771870181E-18  -3.50867546781119E-02  -3.50867546780913E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.05724431710294E-11   0.00000000000000E+00  -2.05724431710294E-11
      5.50427717779875E-18  -5.06441974814938E-01  -5.06356016036466E-01   0.00000000000000E+00   1.50780920212106E-13
     -1.40206557461249E-22  -2.73027744533136E-10  -2.72876963613064E-10  -4.28017945909694E-18
      3.10058924687077E-07
      0.00000000000000E+00  -4.84297299295289E-13   0.00000000000000E+00   6.07048068697201E-15   2.35642456760868E-22
      4.84279340671632E-10   4.84285411152554E-10  -1.17815423231986E-18  -5.36890091296231E-02  -5.36890091295918E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.13492776226807E-11   0.00000000000000E+00  -3.13492776226807E-11
      5.44157862255339E-18  -5.17088556305719E-01  -5.16945876627011E-01   0.00000000000000E+00   2.71027059166952E-13
     -1.39108763128339E-22  -4.53207160588901E-10  -4.52936133529873E-10  -4.26342439023353E-18
      3.12058924687077E-07
      0.00000000000000E+00  -7.98589990019445E-13   0.00000000000000E+00   9.05806744555685E-15   2.66113362370426E-22
      7.98561434465992E-10   7.98570492533704E-10  -1.12865306472653E-18  -7.34060864245642E-02  -7.34060864245265E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.77259790011913E-11   0.00000000000000E+00  -3.77259790011913E-11
      5.36612666455100E-18  -5.26928581366436E-01  -5.26688905930880E-01   0.00000000000000E+00   2.82333669207443E-13
     -1.37945924054189E-22  -7.61126847201582E-10  -7.60844513532512E-10  -4.23747359982447E-18
      3.14058924687077E-07
      0.00000000000000E+00  -1.28674476827745E-12   0.00000000000000E+00   1.32047183255227E-14   2.87506454256329E-22
      1.28673843558192E-09   1.28675164030054E-09  -1.07993218389821E-18  -9.31208321286371E-02  -9.31208321285948E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.23098328260572E-11   0.00000000000000E+00  -4.23098328260572E-11
      5.28150699889889E-18  -5.35637209845316E-01  -5.35245193199451E-01   0.00000000000000E+00   2.59748625075159E-13
     -1.36853751952558E-22  -1.24470155609942E-09  -1.24444180747448E-09  -4.20157481500068E-18
      3.16058924687077E-07
      0.00000000000000E+00  -2.01057314220997E-12   0.00000000000000E+00   1.89038273124376E-14   3.04544975883527E-22
      2.01053757969429E-09   2.01055648352190E-09  -1.03395831258827E-18  -1.12565165405443E-01  -1.12565165405396E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.69518907743335E-11   0.00000000000000E+00  -4.69518907743335E-11
      5.18760321735022E-18  -5.42779794143089E-01  -5.42161228188715E-01   0.00000000000000E+00   2.37549978608593E-13
     -1.35829386948800E-22  -1.96384214272604E-09  -1.96360459274757E-09  -4.15364490476195E-18
      3.18058924687077E-07
      0.00000000000000E+00  -3.03207030943208E-12   0.00000000000000E+00   2.61459427678143E-14   3.19212762950806E-22
      3.03202808736488E-09   3.03205423330797E-09  -9.91446386580127E-19  -1.31670945932938E-01  -1.31670945932886E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.23123833494773E-11   0.00000000000000E+00  -5.23123833494773E-11
      5.08297845065127E-18  -5.47811005556790E-01  -5.46872336430916E-01   0.00000000000000E+00   2.24287500182144E-13
     -1.34833597903403E-22  -2.97996613745854E-09  -2.97974184995849E-09  -4.09153206407115E-18
      3.20058924687077E-07
      0.00000000000000E+00  -4.40211825435676E-12   0.00000000000000E+00   3.46513528165539E-14   3.31604366019160E-22
      4.40205741798188E-09   4.40209206933502E-09  -9.52379253763745E-19  -1.50410203441134E-01  -1.50410203441075E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.84003350574420E-11   0.00000000000000E+00  -5.84003350574420E-11
      4.96617778053639E-18  -5.50097397263055E-01  -5.48729054815567E-01   0.00000000000000E+00   2.25223459221598E-13
     -1.33803496824985E-22  -4.34391695773666E-09  -4.34369173427758E-09  -4.01379852677264E-18
      3.22058924687077E-07
      0.00000000000000E+00  -6.15561797712286E-12   0.00000000000000E+00   4.40307012206973E-14   3.41202201058160E-22
      6.15559977618260E-09   6.15564380688416E-09  -9.16324945911965E-19  -1.68774941727852E-01  -1.68774941727787E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.48705552899050E-11   0.00000000000000E+00  -6.48705552899050E-11
      4.83643666995657E-18  -5.48949035076266E-01  -5.47030320824427E-01   0.00000000000000E+00   2.47277460065119E-13
     -1.32643952132796E-22  -6.09102052905419E-09  -6.09077325159426E-09  -3.92011172404461E-18
      3.24058924687077E-07
      0.00000000000000E+00  -8.31534697255785E-12   0.00000000000000E+00   3.85169126088669E-14   3.47393133551810E-22
      8.31531176854166E-09   8.31535028545462E-09  -8.82701634644323E-19  -1.86766892494094E-01  -1.86766892494023E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.12465708021149E-11   0.00000000000000E+00  -7.12465708021149E-11
      4.69394352835234E-18  -5.43643927774651E-01  -5.41046852326849E-01   0.00000000000000E+00   3.12596499680795E-13
     -1.31225535355692E-22  -8.24441631115205E-09  -8.24410371465250E-09  -3.81124189370802E-18
      3.26058924687077E-07
      0.00000000000000E+00  -1.08989394302056E-11   0.00000000000000E+00   6.43908940019593E-14   3.49567946783097E-22
      1.08989122689737E-08   1.08989766598681E-08  -8.50943441507341E-19  -2.04391904666547E-01  -2.04391904666470E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.71393814201131E-11   0.00000000000000E+00  -7.71393814201131E-11
      4.53966476551212E-18  -5.33437919823011E-01  -5.30028783699056E-01   0.00000000000000E+00   3.77378220727267E-13
     -1.29395892957963E-22  -1.08222146566686E-08  -1.08218372784480E-08  -3.68872132400478E-18
      3.28058924687077E-07
      0.00000000000000E+00  -1.39236621606611E-11   0.00000000000000E+00   7.52388778680952E-14   3.47059138763632E-22
      1.39235117711687E-08   1.39235870100469E-08  -8.20573475060722E-19  -2.21657288977536E-01  -2.21657288977453E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.23705735887486E-11   0.00000000000000E+00  -8.23705735887486E-11
      4.37492361833462E-18  -5.17565956080090E-01  -5.13205605211013E-01   0.00000000000000E+00   4.83994980824272E-13
     -1.27006477741419E-22  -1.38417004314388E-08  -1.38412164364581E-08  -3.55435014327390E-18
      3.30058924687077E-07
      0.00000000000000E+00  -1.74020978929217E-11   0.00000000000000E+00   8.64274545676565E-14   3.39047164604665E-22
      1.74020749468413E-08   1.74021613742962E-08  -7.91221091187063E-19  -2.38570592752189E-01  -2.38570592752102E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.69791132590386E-11   0.00000000000000E+00  -8.69791132590386E-11
      4.20096539181654E-18  -4.95249760800732E-01  -4.89794958775348E-01   0.00000000000000E+00   6.04388272123713E-13
     -1.23947459739889E-22  -1.73157866493091E-08  -1.73151822610371E-08  -3.40974430062948E-18
      3.32058924687077E-07
      0.00000000000000E+00  -2.13326852664550E-11   0.00000000000000E+00   9.75866535796928E-14   3.24562107513414E-22
      2.13326201149101E-08   2.13327177015640E-08  -7.62613534209657E-19  -2.55139112670019E-01  -2.55139112669928E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.11277625682829E-11   0.00000000000000E+00  -9.11277625682829E-11
      4.01870986667998E-18  -4.65725643158048E-01  -4.59033817727333E-01   0.00000000000000E+00   7.21223379246820E-13
     -1.20170939985634E-22  -2.12423111623748E-08  -2.12415899389957E-08  -3.25609633247032E-18
      3.34058924687077E-07
      0.00000000000000E+00  -2.56865850337778E-11   0.00000000000000E+00   1.08058165634478E-13   3.03064657541688E-22
      2.56864267605653E-08   2.56865348187312E-08  -7.34551619342204E-19  -2.71369958143120E-01  -2.71369958143025E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.49104383226111E-11   0.00000000000000E+00  -9.49104383226111E-11
      3.82888899003476E-18  -4.28294594515601E-01  -4.20232239670325E-01   0.00000000000000E+00   8.21111743382572E-13
     -1.15665350190966E-22  -2.55924454921519E-08  -2.55916243804086E-08  -3.09433737069255E-18
      3.36058924687077E-07
      0.00000000000000E+00  -3.04017101525378E-11   0.00000000000000E+00   1.17027733071197E-13   2.76198655760386E-22
      3.04015924097014E-08   3.04017094374347E-08  -7.06878282605093E-19  -2.87270429064515E-01  -2.87270429064417E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.82109005969099E-11   0.00000000000000E+00  -9.82109005969099E-11
      3.63246718884094E-18  -3.82388563320091E-01  -3.72841626795384E-01   0.00000000000000E+00   8.99176965317248E-13
     -1.10374997807858E-22  -3.03043977138030E-08  -3.03034985368378E-08  -2.92558890623584E-18
      3.38058924687077E-07
      0.00000000000000E+00  -3.53433243932516E-11   0.00000000000000E+00   1.22679421640872E-13   2.49158647692607E-22
      3.53431735711841E-08   3.53432962506060E-08  -6.79492242418573E-19  -3.02847521186234E-01  -3.02847521186133E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01149131990239E-10   0.00000000000000E+00  -1.01149131990239E-10
      3.43016892486046E-18  -3.27730698826245E-01  -3.16627671551251E-01   0.00000000000000E+00   9.38289645648776E-13
     -1.04123763332191E-22  -3.52430854082613E-08  -3.52421471186158E-08  -2.75067668244188E-18
      3.40058924687077E-07
      0.00000000000000E+00  -4.01051066385130E-11   0.00000000000000E+00   1.18288883267800E-13   2.25593703353645E-22
      4.01050351631949E-08   4.01051534520783E-08  -6.52472093908006E-19  -3.18104978283469E-01  -3.18104978283363E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05343321421953E-10   0.00000000000000E+00  -1.05343321421953E-10
      3.21948228201655E-18  -2.64871759425833E-01  -2.52269607181323E-01   0.00000000000000E+00   8.83461122745205E-13
     -9.66056815259656E-23  -4.00006935917790E-08  -3.99998101306564E-08  -2.56701018810854E-18
      3.42058924687077E-07
      0.00000000000000E+00  -4.37873458426372E-11   0.00000000000000E+00   9.15871984106770E-14   1.94021177305466E-22
      4.37872115012061E-08   4.37873030884047E-08  -6.26157351788928E-19  -3.33040558796543E-01  -3.33040558796429E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13833813487656E-10   0.00000000000000E+00  -1.13833813487656E-10
      2.99181465504124E-18  -1.96077880622895E-01  -1.82318115848485E-01   0.00000000000000E+00   7.07592362353343E-13
     -8.83140618969566E-23  -4.36741768672793E-08  -4.36734692749170E-08  -2.36565730325231E-18
      3.44058924687077E-07
      0.00000000000000E+00  -4.55106286468620E-11   0.00000000000000E+00   2.46587297336975E-13   1.38120190700913E-22
      4.55106645365193E-08   4.55109111238167E-08  -6.00738471460691E-19  -3.47655981379242E-01  -3.47655981379118E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.24634541857445E-10   0.00000000000000E+00  -1.24634541857445E-10
      2.74254557132635E-18  -1.25262644125134E-01  -1.10963155742511E-01   0.00000000000000E+00   3.06620451413668E-13
     -8.07510445209063E-23  -4.53865832024106E-08  -4.53862765819593E-08  -2.14180709986566E-18
      3.46058924687077E-07
      0.00000000000000E+00  -4.13563993382284E-11   0.00000000000000E+00  -1.02707057464217E-13   6.89989106968295E-23
      4.13564530796003E-08   4.13563503725429E-08  -5.75017451571082E-19  -3.61977457534401E-01  -3.61977457534276E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.25222447755036E-10   0.00000000000000E+00  -1.25222447755036E-10
      2.49210067581628E-18  -6.39094886549755E-02  -5.09189808024344E-02   0.00000000000000E+00   4.41614222051288E-13
     -5.64236764253360E-23  -4.12315695390099E-08  -4.12311279247879E-08  -1.91708322424519E-18
      3.48058924687077E-07
      0.00000000000000E+00  -2.80625165405993E-11   0.00000000000000E+00  -3.28581829574424E-13   2.67085484801176E-23
      2.80628296052380E-08   2.80625010234084E-08  -5.44393286404575E-19  -3.76070957707846E-01  -3.76070957707751E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.50204443467867E-11   0.00000000000000E+00  -9.50204443467867E-11
      2.30205978712270E-18  -2.96352451450281E-02  -2.08236263273820E-02   0.00000000000000E+00   4.80989262883496E-13
     -2.47326151723343E-23  -2.79679615683245E-08  -2.79674805790616E-08  -1.75766650071813E-18
      3.50058924687077E-07
      0.00000000000000E+00  -1.80023950953101E-11   0.00000000000000E+00  -2.48138535221265E-13   1.18539829065502E-23
      1.80026403296023E-08   1.80023921910671E-08  -5.10735928326126E-19  -3.89935850623855E-01  -3.89935850623788E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.73909874065706E-11   0.00000000000000E+00  -6.73909874065706E-11
      2.16727781230956E-18  -1.56077074525252E-02  -9.95697863400490E-03   0.00000000000000E+00   3.18664735478117E-13
     -1.19809342958092E-23  -1.79353198683960E-08  -1.79350012036606E-08  -1.65654188398343E-18
      3.52058924687077E-07
      0.00000000000000E+00  -1.36014708225371E-11   0.00000000000000E+00  -1.08270213257482E-13   7.17182764370700E-24
      1.36015494344592E-08   1.36014411642460E-08  -4.76883756005830E-19  -4.03544274430025E-01  -4.03544274429969E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.62606506363723E-11   0.00000000000000E+00  -5.62606506363723E-11
      2.05475651103682E-18  -1.04115749770914E-02  -6.14392993166236E-03   0.00000000000000E+00   1.52007907340882E-13
     -7.10094835962902E-24  -1.35453325215169E-08  -1.35451805136096E-08  -1.57787275503099E-18
      3.54058924687077E-07
      0.00000000000000E+00  -1.20166898820212E-11   0.00000000000000E+00  -3.87861853100624E-14   5.06015739115001E-24
      1.20166853222936E-08   1.20166465361083E-08  -4.43613724995128E-19  -4.16885632292646E-01  -4.16885632292592E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.30937998598657E-11   0.00000000000000E+00  -5.30937998598657E-11
      1.94856891131709E-18  -8.39205541789470E-03  -4.62272685258502E-03   0.00000000000000E+00   7.27094369192439E-14
     -5.71215463711878E-24  -1.19636254456854E-08  -1.19635527362484E-08  -1.50495518632196E-18
      3.56058924687077E-07
      0.00000000000000E+00  -1.14757243798688E-11   0.00000000000000E+00  -1.30630651947019E-14   4.13250657762356E-24
      1.14757757391821E-08   1.14757626761169E-08  -4.11122552058375E-19  -4.29959711302220E-01  -4.29959711302167E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.26882609490175E-11   0.00000000000000E+00  -5.26882609490175E-11
      1.84319238941905E-18  -7.45687778234894E-03  -3.85783412531049E-03   0.00000000000000E+00   4.22047199477113E-14
     -4.74760525594375E-24  -1.14231166198878E-08  -1.14230744151679E-08  -1.43206983736068E-18
      3.58058924687077E-07
      0.00000000000000E+00  -1.12795440211936E-11   0.00000000000000E+00  -4.58554101081626E-15   3.56272064650206E-24
      1.12795420032401E-08   1.12795374176991E-08  -3.79503547325845E-19  -4.42770031451123E-01  -4.42770031451070E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.31252603401995E-11   0.00000000000000E+00  -5.31252603401995E-11
      1.73694186873865E-18  -6.91624478569383E-03  -3.37916107142869E-03   0.00000000000000E+00   3.05793016007490E-14
     -4.11522825313194E-24  -1.12264427366604E-08  -1.12264121573588E-08  -1.35743832141281E-18
      3.60058924687077E-07
      0.00000000000000E+00  -1.11946794840138E-11   0.00000000000000E+00  -1.86036468776412E-15   3.16321525885341E-24
      1.11946462809784E-08   1.11946444206137E-08  -3.48820382534894E-19  -4.55321227573800E-01  -4.55321227573747E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.37684065116397E-11   0.00000000000000E+00  -5.37684065116397E-11
      1.62940505571537E-18  -6.54760553405264E-03  -3.03746974500490E-03   0.00000000000000E+00   2.53877762183194E-14
     -3.64536442232518E-24  -1.11409014018782E-08  -1.11408760141020E-08  -1.28058467318048E-18
      3.62058924687077E-07
      0.00000000000000E+00  -1.11487571154100E-11   0.00000000000000E+00  -9.16170518523814E-16   2.86341576385944E-24
      1.11487836375165E-08   1.11487827213460E-08  -3.19112607862494E-19  -4.67618122393063E-01  -4.67618122393008E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.44053847020246E-11   0.00000000000000E+00  -5.44053847020246E-11
      1.52059428631132E-18  -6.27292170508039E-03  -2.77743457686893E-03   0.00000000000000E+00   2.23756625708942E-14
     -3.27615758748738E-24  -1.10943997123065E-08  -1.10943773366440E-08  -1.20148167844883E-18
      3.64058924687077E-07
      0.00000000000000E+00  -1.11194586442408E-11   0.00000000000000E+00  -5.25215590968467E-16   2.62960054667734E-24
      1.11194402328786E-08   1.11194397076631E-08  -2.90397609242562E-19  -4.79665271176259E-01  -4.79665271176204E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.49588121659361E-11   0.00000000000000E+00  -5.49588121659361E-11
      1.41067666197945E-18  -6.05901908458871E-03  -2.57294993883576E-03   0.00000000000000E+00   2.02085886150717E-14
     -2.97842434845142E-24  -1.10645011040857E-08  -1.10644808954971E-08  -1.12027905273689E-18
      3.66058924687077E-07
      0.00000000000000E+00  -1.10987935783692E-11   0.00000000000000E+00  -3.24757624490618E-16   2.44241023305820E-24
      1.10988078071187E-08   1.10988074823611E-08  -2.62675627112277E-19  -4.91466331188427E-01  -4.91466331188371E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.53950474429124E-11   0.00000000000000E+00  -5.53950474429124E-11
      1.29988656709362E-18  -5.88821460741183E-03  -2.40878216356816E-03   0.00000000000000E+00   1.84656825384352E-14
     -2.73454108675893E-24  -1.10434309006007E-08  -1.10434124349182E-08  -1.03721093998135E-18
      3.68058924687077E-07
      0.00000000000000E+00  -1.10835473519927E-11   0.00000000000000E+00  -2.04842270844765E-16   2.28947892095599E-24
      1.10835451574417E-08   1.10835449525994E-08  -2.35938575297277E-19  -5.03022117612289E-01  -5.03022117612233E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.56895267266990E-11   0.00000000000000E+00  -5.56895267266990E-11
      1.18850751364023E-18  -5.74941142623204E-03  -2.27487931894458E-03   0.00000000000000E+00   1.69935539600563E-14
     -2.53232699901481E-24  -1.10278724194267E-08  -1.10278554258727E-08  -9.52568938342951E-19
      3.70058924687077E-07
      0.00000000000000E+00  -1.10717912256301E-11   0.00000000000000E+00  -1.29880400827020E-16   2.16249457359821E-24
      1.10718101627043E-08   1.10718100328239E-08  -2.10191742371665E-19  -5.14322657718076E-01  -5.14322657718021E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.57860193026573E-11   0.00000000000000E+00  -5.57860193026573E-11
      1.07693547503491E-18  -5.63505447610474E-03  -2.16424897756988E-03   0.00000000000000E+00   1.57112690757566E-14
     -2.36298295314628E-24  -1.10160397247903E-08  -1.10160240135212E-08  -8.66743732663249E-19
      3.72058924687077E-07
      0.00000000000000E+00  -1.10622393729606E-11   0.00000000000000E+00  -8.79830905605498E-17   2.05586416751295E-24
      1.10622216477813E-08   1.10622215597982E-08  -1.85517992458017E-19  -5.25319135965640E-01  -5.25319135965584E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.54853491222551E-11   0.00000000000000E+00  -5.54853491222551E-11
      9.65964776790403E-19  -5.53993006987738E-03  -2.07204988025459E-03   0.00000000000000E+00   1.45310945130200E-14
     -2.22033461739346E-24  -1.10067507417705E-08  -1.10067362106759E-08  -7.80446784332386E-19
      3.74058924687077E-07
      0.00000000000000E+00  -1.10535141229258E-11   0.00000000000000E+00  -7.75067215288477E-17   1.96597915291917E-24
      1.10535233061258E-08   1.10535232286191E-08  -1.62148882924440E-19  -5.35889974971749E-01  -5.35889974971694E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.43977280797166E-11   0.00000000000000E+00  -5.43977280797166E-11
      8.57169320630969E-19  -5.46053283124492E-03  -1.99504976895270E-03   0.00000000000000E+00   1.33440263913384E-14
     -2.10030420841596E-24  -1.09991388445657E-08  -1.09991255005393E-08  -6.95020437706528E-19
      3.76058924687077E-07
      0.00000000000000E+00  -1.10447888728911E-11   0.00000000000000E+00  -9.56893418962832E-17   1.89052602445408E-24
      1.10447709506101E-08   1.10447708549208E-08  -1.40439895512874E-19  -5.45848701815698E-01  -5.45848701815646E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.21491197466739E-11   0.00000000000000E+00  -5.21491197466739E-11
      7.52871081137621E-19  -5.39448096788752E-03  -1.93104643898812E-03   0.00000000000000E+00   1.20787636790967E-14
     -2.00008335751433E-24  -1.09926338139378E-08  -1.09926217351741E-08  -6.12431185624748E-19
      3.78058924687077E-07
      0.00000000000000E+00  -1.10351451754843E-11   0.00000000000000E+00  -1.26675208286868E-16   1.82805608852322E-24
      1.10351767714893E-08   1.10351766448141E-08  -1.20871529304327E-19  -5.54941497516841E-01  -5.54941497516793E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.83393383688184E-11   0.00000000000000E+00  -4.83393383688184E-11
      6.56192404399984E-19  -5.34018319574577E-03  -1.87857058259136E-03   0.00000000000000E+00   1.06472149806394E-14
     -1.91785129042579E-24  -1.09868479536603E-08  -1.09868373064453E-08  -5.35320875095658E-19
      3.80058924687077E-07
      0.00000000000000E+00  -1.10238482728078E-11   0.00000000000000E+00  -1.86323109128653E-16   1.77788712913371E-24
      1.10238653254340E-08   1.10238651391109E-08  -1.04105818899136E-19  -5.62819966046405E-01  -5.62819966046362E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.24165427297423E-11   0.00000000000000E+00  -4.24165427297423E-11
      5.71359318940500E-19  -5.29675496102620E-03  -1.83683966223612E-03   0.00000000000000E+00   8.96994781950251E-15
     -1.85281383666565E-24  -1.09814575663290E-08  -1.09814485963812E-08  -4.67253500041365E-19
      3.82058924687077E-07
      0.00000000000000E+00  -1.10097960280151E-11   0.00000000000000E+00  -2.75054390013066E-16   1.74009004184080E-24
      1.10098196139305E-08   1.10098193388761E-08  -9.10287720625476E-20  -5.69021346893009E-01  -5.69021346892975E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.37218052015434E-11   0.00000000000000E+00  -3.37218052015434E-11
      5.03915708537413E-19  -5.26398462315302E-03  -1.80575489697993E-03   0.00000000000000E+00   6.92726127040025E-15
     -1.80522400344232E-24  -1.09761044609359E-08  -1.09760975336746E-08  -4.12886936474867E-19
      3.84058924687077E-07
      0.00000000000000E+00  -1.09920699937340E-11   0.00000000000000E+00  -3.93834422058344E-16   1.71549160711454E-24
      1.09920322085425E-08   1.09920318147081E-08  -8.27446335742010E-20  -5.72974973024088E-01  -5.72974973024066E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.16506643176132E-11   0.00000000000000E+00  -2.16506643176132E-11
      4.60614379902187E-19  -5.24234384048971E-03  -1.78591493173708E-03   0.00000000000000E+00   4.40388053112856E-15
     -1.77641269983655E-24  -1.09703855542710E-08  -1.09703811503905E-08  -3.77869746327987E-19
      3.86058924687077E-07
      0.00000000000000E+00  -1.09696598778554E-11   0.00000000000000E+00  -5.39313830880778E-16   1.70577912794908E-24
      1.09696802757657E-08   1.09696797364519E-08  -8.05418061255285E-20  -5.74028648802019E-01  -5.74028648802014E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.79760736793758E-12   0.00000000000000E+00  -5.79760736793758E-12
      4.49019165166311E-19  -5.23311559790236E-03  -1.77873426398644E-03   0.00000000000000E+00   1.28958051082188E-15
     -1.76902744587149E-24  -1.09638834186645E-08  -1.09638821290839E-08  -3.68477359040782E-19
      3.88058924687077E-07
      0.00000000000000E+00  -1.09421064566931E-11   0.00000000000000E+00  -7.09499383923202E-16   1.71381704269238E-24
      1.09420698184359E-08   1.09420691089365E-08  -8.58652105611035E-20  -5.71480230545931E-01  -5.71480230545945E-01
      0.00000000000000E+00   0.00000000000000E+00   1.39686692228338E-11   0.00000000000000E+00   1.39686692228338E-11
      4.76956503611980E-19  -5.23867496095401E-03  -1.78676528698749E-03   0.00000000000000E+00  -2.53414321334828E-15
     -1.78769124736972E-24  -1.09560352440161E-08  -1.09560377781593E-08  -3.91091293050876E-19
      3.90058924687077E-07
      0.00000000000000E+00  -1.09083994381380E-11   0.00000000000000E+00  -9.09034445414293E-16   1.74440636656736E-24
      1.09083956292547E-08   1.09083947202203E-08  -1.00331411804004E-19  -5.64598687972146E-01  -5.64598687972183E-01
      0.00000000000000E+00   0.00000000000000E+00   3.75038772436595E-11   0.00000000000000E+00   3.75038772436595E-11
      5.51964258099298E-19  -5.26321410743117E-03  -1.81449938447504E-03   0.00000000000000E+00  -7.23180529063612E-15
     -1.84055620642797E-24  -1.09458913656587E-08  -1.09458985974640E-08  -4.51632846295293E-19
      3.92058924687077E-07
      0.00000000000000E+00  -1.08672529958690E-11   0.00000000000000E+00  -2.45427746529632E-15   1.80589305466892E-24
      1.08672447322930E-08   1.08672422780155E-08  -1.25803977425582E-19  -5.52629895624437E-01  -5.52629895624501E-01
      0.00000000000000E+00   0.00000000000000E+00   6.43824196423581E-11   0.00000000000000E+00   6.43824196423581E-11
      6.80729097384014E-19  -5.31443947935174E-03  -1.87022235912653E-03   0.00000000000000E+00  -1.17779276525923E-14
     -1.94282785442709E-24  -1.09316129197302E-08  -1.09316246976579E-08  -5.54925119958432E-19
      3.94058924687077E-07
      0.00000000000000E+00  -1.08155444088211E-11   0.00000000000000E+00  -1.16939459744197E-15   1.91353985655860E-24
      1.08155296243211E-08   1.08155284549265E-08  -1.64522334982635E-19  -5.34796621171452E-01  -5.34796621171546E-01
      0.00000000000000E+00   0.00000000000000E+00   9.37730538522699E-11   0.00000000000000E+00   9.37730538522699E-11
      8.68275205088554E-19  -5.40756591261649E-03  -1.97038372814015E-03   0.00000000000000E+00  -2.08752745176045E-14
     -2.12533620481308E-24  -1.09092806335043E-08  -1.09093015087788E-08  -7.03752870105919E-19
      3.96058924687077E-07
      0.00000000000000E+00  -1.07456505638062E-11   0.00000000000000E+00  -2.05130585518427E-15   2.09681123779521E-24
      1.07456140805918E-08   1.07456120292859E-08  -2.19249429641788E-19  -5.10310258373162E-01  -5.10310258373286E-01
      0.00000000000000E+00   0.00000000000000E+00   1.24112073719727E-10   0.00000000000000E+00   1.24112073719727E-10
      1.11649935252801E-18  -5.57548759963039E-03  -2.15077695989167E-03   0.00000000000000E+00  -3.05017070738180E-14
     -2.45847868533094E-24  -1.08696936012986E-08  -1.08697241030056E-08  -8.97249922886220E-19
      3.98058924687077E-07
      0.00000000000000E+00  -1.06358961028432E-11   0.00000000000000E+00  -2.74954514134248E-15   2.41468977376435E-24
      1.06358326933213E-08   1.06358299437762E-08  -2.93317082892067E-19  -4.78409503973540E-01  -4.78409503973693E-01
      0.00000000000000E+00   0.00000000000000E+00   1.52617514113102E-10   0.00000000000000E+00   1.52617514113102E-10
      1.42173438075421E-18  -5.89822202853745E-03  -2.49912250544752E-03   0.00000000000000E+00  -4.49067704902757E-14
     -3.13289200266689E-24  -1.07884025511188E-08  -1.07884474578893E-08  -1.12841729786214E-18
      4.00058924687077E-07
      0.00000000000000E+00  -1.04143665966987E-11   0.00000000000000E+00  -6.16983780916673E-15   2.97429504013103E-24
      1.04144449911574E-08   1.04144388213196E-08  -3.90119070034071E-19  -4.38424274409584E-01  -4.38424274409759E-01
      0.00000000000000E+00   0.00000000000000E+00   1.75173329738151E-10   0.00000000000000E+00   1.75173329738151E-10
      1.77208104023051E-18  -6.60243004708917E-03  -3.26598212501387E-03   0.00000000000000E+00  -6.51975052169919E-14
     -4.79562701694095E-24  -1.05895469535526E-08  -1.05896121510578E-08  -1.38196197019644E-18
      4.02058924687077E-07
      0.00000000000000E+00  -9.81223249956612E-12   0.00000000000000E+00  -1.59339648526210E-14   3.78443959700128E-24
      9.81220115011413E-09   9.81218521614928E-09  -5.10734479508748E-19  -3.89844335125378E-01  -3.89844335125567E-01
      0.00000000000000E+00   0.00000000000000E+00   1.88758573020495E-10   0.00000000000000E+00   1.88758573020495E-10
      2.14959818627150E-18  -8.44229395404057E-03  -5.29132435061612E-03   0.00000000000000E+00  -9.64810403336930E-14
     -1.01522723935489E-23  -1.00008473081294E-08  -1.00009437891698E-08  -1.63886370676276E-18
      4.04058924687077E-07
      0.00000000000000E+00  -7.92537421837469E-12   0.00000000000000E+00  -5.41325642772814E-14   2.93902447940682E-24
      7.92548259970772E-09   7.92542846714344E-09  -6.48442084154977E-19  -3.32464566626095E-01  -3.32464566626296E-01
      0.00000000000000E+00   0.00000000000000E+00   2.01011958610758E-10   0.00000000000000E+00   2.01011958610758E-10
      2.55162210349302E-18  -1.39076600280910E-02  -1.13472935924547E-02   0.00000000000000E+00  -1.33940972160883E-13
     -2.94888273736306E-23  -8.12630648478200E-09  -8.12644042575419E-09  -1.90318001933804E-18
      4.06058924687077E-07
      0.00000000000000E+00  -4.04952630821706E-12   0.00000000000000E+00  -9.79303124316910E-14  -8.73744872330641E-24
      4.04963642679847E-09   4.04953849648603E-09  -7.90402292689061E-19  -2.66943895747317E-01  -2.66943895747544E-01
      0.00000000000000E+00   0.00000000000000E+00   2.27138919604545E-10   0.00000000000000E+00   2.27138919604545E-10
      3.00589994270211E-18  -2.67853717949868E-02  -2.54379449948983E-02   0.00000000000000E+00  -2.17059059036223E-13
     -6.46663146248604E-23  -4.27646035703148E-09  -4.27667741609058E-09  -2.21549765001305E-18
      4.08058924687077E-07
      0.00000000000000E+00  -1.11738307286677E-12   0.00000000000000E+00  -7.55097443326237E-14  -2.91364040078687E-23
      1.11742091592566E-09   1.11734540618129E-09  -9.34538458613744E-19  -1.95761396579916E-01  -1.95761396580160E-01
      0.00000000000000E+00   0.00000000000000E+00   2.43980934306268E-10   0.00000000000000E+00   2.43980934306268E-10
      3.49386181131465E-18  -4.51012324221737E-02  -4.46723310854594E-02   0.00000000000000E+00  -4.02282556981449E-13
     -8.41503997794191E-23  -1.36092405793050E-09  -1.36132634048756E-09  -2.55932335270090E-18
      4.10058924687077E-07
      0.00000000000000E+00  -1.60177221689927E-13   0.00000000000000E+00  -2.77609381816725E-14  -4.14440063533041E-23
      1.60170532072619E-10   1.60142771134396E-10  -1.08154588977866E-18  -1.23125704671500E-01  -1.23125704671735E-01
      0.00000000000000E+00   0.00000000000000E+00   2.35565582666555E-10   0.00000000000000E+00   2.35565582666555E-10
      3.96499297664776E-18  -6.49375337540430E-02  -6.48128621211066E-02   0.00000000000000E+00  -6.47725492795206E-13
     -9.16781319912822E-23  -3.95060628308063E-10  -3.95708353800950E-10  -2.88344708686910E-18
      4.12058924687077E-07
      0.00000000000000E+00   2.13079790321462E-14   0.00000000000000E+00  -8.76535284979921E-15  -4.51462860578836E-23
     -2.12905744988324E-11  -2.12993398517274E-11  -1.20679252162863E-18  -6.16308089751757E-02  -6.16308089753699E-02
      0.00000000000000E+00   0.00000000000000E+00   1.94190800571154E-10   0.00000000000000E+00   1.94190800571154E-10
      4.35337457779007E-18  -8.48128828417447E-02  -8.47584118049265E-02   0.00000000000000E+00  -7.84304821191350E-13
     -9.85491971117016E-23  -1.72107155898138E-10  -1.72891460719428E-10  -3.14658205616144E-18
      4.14058924687077E-07
      0.00000000000000E+00   1.91955500763731E-14   0.00000000000000E+00  -2.23743780920147E-15  -4.59553535831058E-23
     -1.92091762197958E-11  -1.92114136576510E-11  -1.27626337180018E-18  -2.84016380604400E-02  -2.84016380605649E-02
      0.00000000000000E+00   0.00000000000000E+00   1.24990824844546E-10   0.00000000000000E+00   1.24990824844546E-10
      4.60335622747916E-18  -1.04421453184376E-01  -1.04388126569796E-01   0.00000000000000E+00  -5.90506124543785E-13
     -1.02959090820736E-22  -1.05188905062248E-10  -1.05779411186895E-10  -3.32709285567898E-18
      4.16058924687077E-07
      0.00000000000000E+00  -1.37767105811290E-15   0.00000000000000E+00  -4.81396402533389E-17  -4.59192123731311E-23
      1.37627998024137E-12   1.37623184055520E-12  -1.30612495734068E-18  -1.50685626053699E-02  -1.50685626054460E-02
      0.00000000000000E+00   0.00000000000000E+00   7.61469181578423E-11   0.00000000000000E+00   7.61469181578423E-11
      4.75565006379484E-18  -1.23690936233902E-01  -1.23666512176998E-01   0.00000000000000E+00  -3.79047982637152E-13
     -1.05461044944114E-22  -7.71441020156553E-11  -7.75231499983979E-11  -3.44952510645416E-18
      4.18058924687077E-07
      0.00000000000000E+00  -1.63483632229398E-14   0.00000000000000E+00   4.68622616987997E-16  -4.52891133027514E-23
      1.63206182602355E-11   1.63210868828072E-11  -1.31761207106354E-18  -1.01759993765746E-02  -1.01759993766253E-02
      0.00000000000000E+00   0.00000000000000E+00   5.07097785202668E-11   0.00000000000000E+00   5.07097785202668E-11
      4.85706962083537E-18  -1.42591547064638E-01  -1.42570428810744E-01   0.00000000000000E+00  -2.90870861830626E-13
     -1.07256125784422E-22  -6.67399945411356E-11  -6.70308654030734E-11  -3.53945754977184E-18
      4.20058924687077E-07
      0.00000000000000E+00  -2.65431290529752E-14   0.00000000000000E+00   4.83189615611196E-16  -4.38580037067276E-23
      2.65712076471231E-11   2.65716908366948E-11  -1.32140758821569E-18  -8.27455543379931E-03  -8.27455543383681E-03
      0.00000000000000E+00   0.00000000000000E+00   3.75082588608561E-11   0.00000000000000E+00   3.75082588608561E-11
      4.93208613855709E-18  -1.61114674497870E-01  -1.61094486055051E-01   0.00000000000000E+00  -2.71217153766420E-13
     -1.08857469522252E-22  -6.38087325436754E-11  -6.40799496975506E-11  -3.61067855034140E-18
      4.22058924687077E-07
      0.00000000000000E+00  -3.41662422412000E-14   0.00000000000000E+00   3.92187574910797E-16  -4.12520379529825E-23
      3.41250108084684E-11   3.41254029960020E-11  -1.32198562331503E-18  -7.38680534474821E-03  -7.38680534477819E-03
      0.00000000000000E+00   0.00000000000000E+00   2.99754391290892E-11   0.00000000000000E+00   2.99754391290892E-11
      4.99203701681527E-18  -1.79261797175292E-01  -1.79241602254667E-01   0.00000000000000E+00  -2.74446334334301E-13
     -1.10420752483624E-22  -6.38263957906465E-11  -6.41008421250913E-11  -3.67005139350024E-18
      4.24058924687077E-07
      0.00000000000000E+00  -4.01361501596892E-14   0.00000000000000E+00   3.05473798378925E-16  -3.70462056350988E-23
      4.01172626155145E-11   4.01175680892759E-11  -1.32118752907883E-18  -6.86824046014159E-03  -6.86824046016681E-03
      0.00000000000000E+00   0.00000000000000E+00   2.52273550618008E-11   0.00000000000000E+00   2.52273550618008E-11
      5.04249172693887E-18  -1.97038696575785E-01  -1.97018109813336E-01   0.00000000000000E+00  -2.82313402143936E-13
     -1.11979288325400E-22  -6.50626097488207E-11  -6.53449231510766E-11  -3.72130419786004E-18
      4.26058924687077E-07
      0.00000000000000E+00  -4.51876107061032E-14   0.00000000000000E+00   2.43269142582898E-16  -3.08297621446018E-23
      4.51731828251176E-11   4.51734260942294E-11  -1.31980599924484E-18  -6.51199895473245E-03  -6.51199895475447E-03
      0.00000000000000E+00   0.00000000000000E+00   2.20208615123710E-11   0.00000000000000E+00   2.20208615123710E-11
      5.08653344996361E-18  -2.14452759870662E-01  -2.14431590580654E-01   0.00000000000000E+00  -2.89393282214377E-13
     -1.13533488529276E-22  -6.69048943242735E-11  -6.71942876066015E-11  -3.76672745071877E-18
      4.28058924687077E-07
      0.00000000000000E+00  -4.96880028292720E-14   0.00000000000000E+00   2.02502527165282E-16  -2.22995377616379E-23
      4.96606823584372E-11   4.96608848609420E-11  -1.31820075030377E-18  -6.24536818541412E-03  -6.24536818543388E-03
      0.00000000000000E+00   0.00000000000000E+00   1.97615470104190E-11   0.00000000000000E+00   1.97615470104190E-11
      5.12605654398445E-18  -2.31511673621894E-01  -2.31489802481159E-01   0.00000000000000E+00  -2.94658097798895E-13
     -1.15077932497135E-22  -6.91277737734457E-11  -6.94224318713597E-11  -3.80785579368068E-18
      4.30058924687077E-07
      0.00000000000000E+00  -5.38210160036107E-14   0.00000000000000E+00   1.76602737781710E-16  -1.13856990119363E-23
      5.38025430406309E-11   5.38027196433573E-11  -1.31653860647481E-18  -6.03714790565555E-03  -6.03714790567367E-03
      0.00000000000000E+00   0.00000000000000E+00   1.81209888654998E-11   0.00000000000000E+00   1.81209888654998E-11
      5.16229852171545E-18  -2.48222788723050E-01  -2.48200129693827E-01   0.00000000000000E+00  -2.98334538280466E-13
     -1.16608094062723E-22  -7.16253739704601E-11  -7.19237085088572E-11  -3.84575991524064E-18
      4.32058924687077E-07
      0.00000000000000E+00  -5.77703397035343E-14   0.00000000000000E+00   1.60165807856227E-16   1.62622220321039E-24
      5.77315882518091E-11   5.77317484176186E-11  -1.31489466019952E-18  -5.87053046867350E-03  -5.87053046869040E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68960281516732E-11   0.00000000000000E+00   1.68960281516732E-11
      5.19609057801879E-18  -2.64593009227201E-01  -2.64569498432889E-01   0.00000000000000E+00  -3.00918316850450E-13
     -1.18121571092782E-22  -7.43268582523237E-11  -7.46277765692922E-11  -3.88119591781927E-18
      4.34058924687077E-07
      0.00000000000000E+00  -6.15359739290429E-14   0.00000000000000E+00   1.49573278768248E-16   1.56447897669355E-23
      6.15268415357754E-11   6.15269911090698E-11  -1.31329920733583E-18  -5.73488821492619E-03  -5.73488821494215E-03
      0.00000000000000E+00   0.00000000000000E+00   1.59532069825227E-11   0.00000000000000E+00   1.59532069825227E-11
      5.22799699198384E-18  -2.80629271508492E-01  -2.80604862222671E-01   0.00000000000000E+00  -3.02904696634893E-13
     -1.19617999369884E-22  -7.71772933948382E-11  -7.74801980915927E-11  -3.91469778464801E-18
      4.36058924687077E-07
      0.00000000000000E+00  -6.52097634173440E-14   0.00000000000000E+00   1.42617075356727E-16   2.96521033439248E-23
      6.52376769418014E-11   6.52378195589064E-11  -1.31176099801750E-18  -5.62294741927189E-03  -5.62294741928709E-03
      0.00000000000000E+00   0.00000000000000E+00   1.52025354126564E-11   0.00000000000000E+00   1.52025354126564E-11
      5.25840206280915E-18  -2.96339035845377E-01  -2.96313694137460E-01   0.00000000000000E+00  -3.04719668247558E-13
     -1.21098468377251E-22  -8.01356353031937E-11  -8.04403549715624E-11  -3.94664106479165E-18
      4.38058924687077E-07
      0.00000000000000E+00  -6.88835529056451E-14   0.00000000000000E+00   1.37965475699589E-16   4.29933814695841E-23
      6.88966298936034E-11   6.88967678591221E-11  -1.31027899046395E-18  -5.52966193122342E-03  -5.52966193123800E-03
      0.00000000000000E+00   0.00000000000000E+00   1.45810693260535E-11   0.00000000000000E+00   1.45810693260535E-11
      5.28756420146126E-18  -3.11728696587281E-01  -3.11702398106769E-01   0.00000000000000E+00  -3.06660043349737E-13
     -1.22565183683003E-22  -8.31711771417035E-11  -8.34778371851758E-11  -3.97728521099731E-18
      4.40058924687077E-07
      0.00000000000000E+00  -7.25573423939461E-14   0.00000000000000E+00   1.34765963013095E-16   5.51625936917703E-23
      7.25246426640828E-11   7.25247774301010E-11  -1.30884842070867E-18  -5.45163727243357E-03  -5.45163727244762E-03
      0.00000000000000E+00   0.00000000000000E+00   1.40416069107376E-11   0.00000000000000E+00   1.40416069107376E-11
      5.31564741528273E-18  -3.26799255571756E-01  -3.26771984241192E-01   0.00000000000000E+00  -3.08826856173542E-13
     -1.24020376822303E-22  -8.62575574845407E-11  -8.65663843408382E-11  -4.00679899457407E-18
      4.42058924687077E-07
      0.00000000000000E+00  -7.61392871450397E-14   0.00000000000000E+00   1.32444305245457E-16   6.58630632802863E-23
      7.61340214117384E-11   7.61341538561095E-11  -1.30746388036026E-18  -5.38657315932251E-03  -5.38657315933607E-03
      0.00000000000000E+00   0.00000000000000E+00   1.35512743347688E-11   0.00000000000000E+00   1.35512743347688E-11
      5.34274996395227E-18  -3.41547308309899E-01  -3.41519054531767E-01   0.00000000000000E+00  -3.11267111543145E-13
     -1.25466134629356E-22  -8.93741610792096E-11  -8.96854281908782E-11  -4.03528608359201E-18
      4.44058924687077E-07
      0.00000000000000E+00  -7.97212318961332E-14   0.00000000000000E+00   1.30784320388523E-16   7.50106251906695E-23
      7.97350758537500E-11   7.97352066381454E-11  -1.30611936325973E-18  -5.33292961286247E-03  -5.33292961287557E-03
      0.00000000000000E+00   0.00000000000000E+00   1.31008731026184E-11   0.00000000000000E+00   1.31008731026184E-11
      5.36895171015751E-18  -3.55983268989218E-01  -3.55954022816131E-01   0.00000000000000E+00  -3.14459837189021E-13
     -1.26906479968379E-22  -9.25216199034485E-11  -9.28360797407645E-11  -4.06283234689778E-18
      4.46058924687077E-07
      0.00000000000000E+00  -8.33031766472268E-14   0.00000000000000E+00   1.29963522661360E-16   8.26919172079471E-23
      8.33447227777835E-11   8.33448527413889E-11  -1.30480622361594E-18  -5.28984463234863E-03  -5.28984463236134E-03
      0.00000000000000E+00   0.00000000000000E+00   1.27105769806766E-11   0.00000000000000E+00   1.27105769806766E-11
      5.39437286411886E-18  -3.70161014465045E-01  -3.70130754264787E-01   0.00000000000000E+00  -3.19725692756720E-13
     -1.28351004798555E-22  -9.57357040291794E-11  -9.60554297220645E-11  -4.08956664050292E-18
      4.48058924687077E-07
      0.00000000000000E+00  -8.69769661355278E-14   0.00000000000000E+00   1.29784088853590E-16   8.90871058711799E-23
      8.69762205042344E-11   8.69763502884123E-11  -1.30351660256610E-18  -5.25710729893243E-03  -5.25710729894479E-03
      0.00000000000000E+00   0.00000000000000E+00   1.23626078972074E-11   0.00000000000000E+00   1.23626078972074E-11
      5.41909807991327E-18  -3.84122586807517E-01  -3.84091292373486E-01   0.00000000000000E+00  -3.26828658212059E-13
     -1.29807538636139E-22  -9.90121295272776E-11  -9.93389581856195E-11  -4.11558147734718E-18
      4.50058924687077E-07
      0.00000000000000E+00  -9.06507556238289E-14   0.00000000000000E+00   1.29559223260524E-16   9.43993307186333E-23
      9.06243024847504E-11   9.06244320440680E-11  -1.30224737017342E-18  -5.23516461456607E-03  -5.23516461457807E-03
      0.00000000000000E+00   0.00000000000000E+00   1.19971601976539E-11   0.00000000000000E+00   1.19971601976539E-11
      5.44309240030858E-18  -3.97840209812715E-01  -3.97807881440769E-01   0.00000000000000E+00  -3.33708582266323E-13
     -1.31274208603378E-22  -1.02287883659325E-10  -1.02621592241723E-10  -4.14084503013516E-18
      4.52058924687077E-07
      0.00000000000000E+00  -9.43245451121300E-14   0.00000000000000E+00   1.29409239272579E-16   9.88323329183732E-23
      9.42867764949839E-11   9.42869059043220E-11  -1.30099465707821E-18  -5.22524198365529E-03  -5.22524198366690E-03
      0.00000000000000E+00   0.00000000000000E+00   1.16138820428562E-11   0.00000000000000E+00   1.16138820428562E-11
      5.46632016439430E-18  -4.11294343321770E-01  -4.11260982109366E-01   0.00000000000000E+00  -3.40613381506831E-13
     -1.32750133703367E-22  -1.05560174565538E-10  -1.05900787947178E-10  -4.16532550731609E-18
      4.54058924687077E-07
      0.00000000000000E+00  -9.79983346004310E-14   0.00000000000000E+00   1.29596785946608E-16   1.02571683495004E-22
      9.79674613476087E-11   9.79675909444973E-11  -1.29975214964162E-18  -5.22959526554222E-03  -5.22959526555344E-03
      0.00000000000000E+00   0.00000000000000E+00   1.12203970880074E-11   0.00000000000000E+00   1.12203970880074E-11
      5.48876095857031E-18  -4.24480865092990E-01  -4.24446468532949E-01   0.00000000000000E+00  -3.47938780147258E-13
     -1.34235873896714E-22  -1.08840049252224E-10  -1.09187988032505E-10  -4.18900880892869E-18
      4.56058924687077E-07
      0.00000000000000E+00  -1.01672124088732E-13   0.00000000000000E+00   1.30448606098962E-16   1.05776696150311E-22
      1.01677309553535E-10   1.01677440002247E-10  -1.29850976597902E-18  -5.25216921641576E-03  -5.25216921642658E-03
      0.00000000000000E+00   0.00000000000000E+00   1.08181946079990E-11   0.00000000000000E+00   1.08181946079990E-11
      5.51039734778631E-18  -4.37402017043411E-01  -4.37366578709593E-01   0.00000000000000E+00  -3.55730661245600E-13
     -1.35731869606411E-22  -1.12139903948865E-10  -1.12495634610246E-10  -4.21188758180729E-18
      4.58058924687077E-07
      0.00000000000000E+00  -1.05437758314241E-13   0.00000000000000E+00   1.32572225307947E-16   1.08583569506716E-22
      1.05440436024143E-10   1.05440568596477E-10  -1.29725026092979E-18  -5.30014879132688E-03  -5.30014879133729E-03
      0.00000000000000E+00   0.00000000000000E+00   1.04034990448177E-11   0.00000000000000E+00   1.04034990448177E-11
      5.53120434587594E-18  -4.50062097146313E-01  -4.50025604205980E-01   0.00000000000000E+00  -3.63816052060638E-13
     -1.37237459615418E-22  -1.15480251589096E-10  -1.15844067641294E-10  -4.23395408494616E-18
      4.60058924687077E-07
      0.00000000000000E+00  -1.09295237276957E-13   0.00000000000000E+00   1.37373196670673E-16   1.11118484647959E-22
      1.09309368220075E-10   1.09309505593382E-10  -1.29594111824586E-18  -5.38759627104557E-03  -5.38759627105553E-03
      0.00000000000000E+00   0.00000000000000E+00   9.96508193297556E-12   0.00000000000000E+00   9.96508193297556E-12
      5.55113450974190E-18  -4.62465936329987E-01  -4.62428362941221E-01   0.00000000000000E+00  -3.71810056336168E-13
     -1.38750094545017E-22  -1.18902777469883E-10  -1.19274587526358E-10  -4.25519339149604E-18
      4.62058924687077E-07
      0.00000000000000E+00  -1.13428250451296E-13   0.00000000000000E+00   1.47705597978330E-16   1.13527315335722E-22
      1.13404438802864E-10   1.13404586508575E-10  -1.29451419771396E-18  -5.54462137462506E-03  -5.54462137463453E-03
      0.00000000000000E+00   0.00000000000000E+00   9.47456847763314E-12   0.00000000000000E+00   9.47456847763314E-12
      5.57008364669716E-18  -4.74618329622873E-01  -4.74579620976287E-01   0.00000000000000E+00  -3.78914090429967E-13
     -1.40263869052061E-22  -1.22500240895639E-10  -1.22879154986209E-10  -4.27556944898320E-18
      4.64058924687076E-07
      0.00000000000000E+00  -1.18020487311672E-13   0.00000000000000E+00   1.72136848308727E-16   1.16053607822325E-22
      1.18029635378088E-10   1.18029807515053E-10  -1.29280794080461E-18  -5.84357253085809E-03  -5.84357253086695E-03
      0.00000000000000E+00   0.00000000000000E+00   8.85510858177429E-12   0.00000000000000E+00   8.85510858177429E-12
      5.58779386386071E-18  -4.86523625107035E-01  -4.86483654842302E-01   0.00000000000000E+00  -3.83206070568513E-13
     -1.41765526462822E-22  -1.26501710026116E-10  -1.26884916096826E-10  -4.29498592305611E-18
      4.66058924687076E-07
      0.00000000000000E+00  -1.24082239967369E-13   0.00000000000000E+00   2.38577356504113E-16   1.19296210903259E-22
      1.24075920225311E-10   1.24076158802786E-10  -1.29037536785541E-18  -6.48637823671555E-03  -6.48637823672342E-03
      0.00000000000000E+00   0.00000000000000E+00   7.86874086934973E-12   0.00000000000000E+00   7.86874086934973E-12
      5.60353134559941E-18  -4.98184851037066E-01  -4.98143287090128E-01   0.00000000000000E+00  -3.79026056159320E-13
     -1.43221105784217E-22  -1.31565873615834E-10  -1.31944899672136E-10  -4.31315597774400E-18
      4.68058924687076E-07
      0.00000000000000E+00  -1.34644384746234E-13   0.00000000000000E+00   4.38488046870648E-16   1.25221724146116E-22
      1.34680132285043E-10   1.34680570773215E-10  -1.28575058616725E-18  -8.13777247051387E-03  -8.13777247051953E-03
      0.00000000000000E+00   0.00000000000000E+00   5.66249232292340E-12   0.00000000000000E+00   5.66249232292340E-12
      5.61485633024526E-18  -5.09600550947293E-01  -5.09556341806208E-01   0.00000000000000E+00  -3.46308750604451E-13
     -1.44524661943322E-22  -1.39996754345389E-10  -1.40343063096138E-10  -4.32910574407800E-18
      4.70058924687076E-07
      0.00000000000000E+00  -1.62014116434077E-13   0.00000000000000E+00   1.13741707947072E-15   1.40749721998956E-22
      1.62022763985855E-10   1.62023901403075E-10  -1.27392378029947E-18  -1.30489243117778E-02  -1.30489243117771E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.34949425680767E-13   0.00000000000000E+00  -7.34949425680767E-13
      5.61338643139390E-18  -5.20751415559176E-01  -5.20700608698730E-01   0.00000000000000E+00  -2.16409128577705E-13
     -1.45325759660464E-22  -1.61072542848671E-10  -1.61288951977394E-10  -4.33946265109443E-18
      4.72058924687076E-07
      0.00000000000000E+00  -2.38428937790739E-13   0.00000000000000E+00   2.93471038691250E-15   1.77875981713051E-22
      2.38393934146931E-10   2.38396868857496E-10  -1.24553726047956E-18  -2.51748520256924E-02  -2.51748520256773E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.50471771832201E-11   0.00000000000000E+00  -1.50471771832201E-11
      5.58329207702745E-18  -5.31563061730693E-01  -5.31492705792538E-01   0.00000000000000E+00   8.08755378935024E-14
     -1.45024260093070E-22  -2.23430567212025E-10  -2.23349691674276E-10  -4.33775481654789E-18
      4.74058924687076E-07
      0.00000000000000E+00  -3.94105767357497E-13   0.00000000000000E+00   5.24256893223564E-15   2.25446236785938E-22
      3.94113504308741E-10   3.94118746877899E-10  -1.20197817998926E-18  -4.31840580831454E-02  -4.31840580831166E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.87965705735174E-11   0.00000000000000E+00  -2.87965705735174E-11
      5.52569893588042E-18  -5.41887288389949E-01  -5.41772210279120E-01   0.00000000000000E+00   3.06330611938644E-13
     -1.43872365803144E-22  -3.65628506916176E-10  -3.65322176304381E-10  -4.32372075589117E-18
      4.76058924687076E-07
      0.00000000000000E+00  -6.56598026296609E-13   0.00000000000000E+00   7.84999250847620E-15   2.62201770918653E-22
      6.56577737322420E-10   6.56585587315190E-10  -1.15249274451644E-18  -6.29745746327799E-02  -6.29745746327436E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.62640381680167E-11   0.00000000000000E+00  -3.62640381680167E-11
      5.45317085954439E-18  -5.51514578530993E-01  -5.51319173163125E-01   0.00000000000000E+00   3.48672087299772E-13
     -1.42531453704945E-22  -6.20670221234331E-10  -6.20321549147174E-10  -4.30067811502794E-18
      4.78058924687076E-07
      0.00000000000000E+00  -1.07045041215372E-12   0.00000000000000E+00   1.14340101122196E-14   2.86828190414712E-22
      1.07047551122662E-09   1.07048694523702E-09  -1.10271239232040E-18  -8.28696187032237E-02  -8.28696187031828E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.09031536325996E-11   0.00000000000000E+00  -4.09031536325996E-11
      5.37136455227919E-18  -5.60159547835892E-01  -5.59835220043000E-01   0.00000000000000E+00   3.26092118336331E-13
     -1.41246166573250E-22  -1.02990988372262E-09  -1.02958379160442E-09  -4.26865215995878E-18
      4.80058924687077E-07
      0.00000000000000E+00  -1.69527015937653E-12   0.00000000000000E+00   1.65122541730415E-14   3.05484401621465E-22
      1.69524254698398E-09   1.69525905923845E-09  -1.05517214637241E-18  -1.02509227286146E-01  -1.02509227286101E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.52775501401689E-11   0.00000000000000E+00  -4.52775501401689E-11
      5.28080945199885E-18  -5.67432086162185E-01  -5.66912324732404E-01   0.00000000000000E+00   2.96968168021698E-13
     -1.40044473739411E-22  -1.65027847726617E-09  -1.64998150909829E-09  -4.22563730562644E-18
      4.82058924687077E-07
      0.00000000000000E+00  -2.59507304979867E-12   0.00000000000000E+00   2.31894795248897E-14   3.21463551254826E-22
      2.59502572766362E-09   2.59504891714347E-09  -1.01096154365348E-18  -1.21814058215846E-01  -1.21814058215796E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.03034373757639E-11   0.00000000000000E+00  -5.03034373757639E-11
      5.18020257724732E-18  -5.72827044030649E-01  -5.72025418437129E-01   0.00000000000000E+00   2.73650324137561E-13
     -1.38904878225433E-22  -2.54501913009170E-09  -2.54474547976770E-09  -4.16924103359384E-18
      4.84058924687077E-07
      0.00000000000000E+00  -3.82652728627719E-12   0.00000000000000E+00   3.12612858036990E-14   3.35332568835351E-22
      3.82650825756755E-09   3.82653951885369E-09  -9.70321257379046E-19  -1.40751595690542E-01  -1.40751595690486E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.61549139242269E-11   0.00000000000000E+00  -5.61549139242269E-11
      5.06789274939887E-18  -5.75739445360715E-01  -5.74551722792209E-01   0.00000000000000E+00   2.61814767730260E-13
     -1.37781183915611E-22  -3.77064641969705E-09  -3.77038460492946E-09  -4.09757149201982E-18
      4.86058924687077E-07
      0.00000000000000E+00  -5.43123853476709E-12   0.00000000000000E+00   4.03951812051205E-14   3.46645181862226E-22
      5.43123140057806E-09   5.43127179575962E-09  -9.32950335674012E-19  -1.59311849017419E-01  -1.59311849017356E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.25856962811645E-11   0.00000000000000E+00  -6.25856962811645E-11
      4.94272135683654E-18  -5.75494846707252E-01  -5.73803628883856E-01   0.00000000000000E+00   2.69563875171254E-13
     -1.36590907765337E-22  -5.36895566335349E-09  -5.36868609947845E-09  -4.00977102116253E-18
      4.88058924687077E-07
      0.00000000000000E+00  -7.43611730327020E-12   0.00000000000000E+00   5.01908054349870E-14   3.54773020877885E-22
      7.43604407315358E-09   7.43609426395937E-09  -8.98296494849124E-19  -1.77495672502651E-01  -1.77495672502582E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.91146509722041E-11   0.00000000000000E+00  -6.91146509722041E-11
      4.80449205489213E-18  -5.71378497972400E-01  -5.69057774145022E-01   0.00000000000000E+00   3.06235270650085E-13
     -1.35207386043542E-22  -7.36728584825768E-09  -7.36697961298717E-09  -3.90619556004300E-18
      4.90058924687077E-07
      0.00000000000000E+00  -9.86035914186287E-12   0.00000000000000E+00   6.04803099116408E-14   3.59147371576905E-22
      9.86026006609932E-09   9.86032054640959E-09  -8.65765307244139E-19  -1.95308597038783E-01  -1.95308597038707E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.52684773730383E-11   0.00000000000000E+00  -7.52684773730383E-11
      4.65395510014606E-18  -5.62650394439288E-01  -5.59567915368626E-01   0.00000000000000E+00   3.78462366021539E-13
     -1.33465108478412E-22  -9.78543053140244E-09  -9.78505206903655E-09  -3.78818979290192E-18
      4.92058924687077E-07
      0.00000000000000E+00  -1.27225166874610E-11   0.00000000000000E+00   7.12455806079413E-14   3.59229875902146E-22
      1.27224381070874E-08   1.27225093526683E-08  -8.34829942726310E-19  -2.12757932336787E-01  -2.12757932336706E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.07644725448684E-11   0.00000000000000E+00  -8.07644725448684E-11
      4.49242615505632E-18  -5.48547027989613E-01  -5.44564601020163E-01   0.00000000000000E+00   4.85511169625286E-13
     -1.31184481686708E-22  -1.26422303912930E-08  -1.26417448801235E-08  -3.65759621233001E-18
      4.94058924687077E-07
      0.00000000000000E+00  -1.60401322848713E-11   0.00000000000000E+00   8.24620715576369E-14   3.54359626427733E-22
      1.60400681270728E-08   1.60401505891447E-08  -8.05070171017827E-19  -2.29851374789565E-01  -2.29851374789479E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.55788480938686E-11   0.00000000000000E+00  -8.55788480938686E-11
      4.32126845886858E-18  -5.28283473807251E-01  -5.23257378369440E-01   0.00000000000000E+00   6.15622811193918E-13
     -1.28216207114927E-22  -1.59551873638619E-08  -1.59545717410508E-08  -3.51619828785075E-18
      4.96058924687077E-07
      0.00000000000000E+00  -1.98197269104354E-11   0.00000000000000E+00   9.38603828019599E-14   3.43554158761595E-22
      1.98196663557069E-08   1.98197602160901E-08  -7.76175494657258E-19  -2.46596320654436E-01  -2.46596320654346E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.98991400354608E-11   0.00000000000000E+00  -8.98991400354608E-11
      4.14147017879766E-18  -5.01073966310516E-01  -4.94858476027059E-01   0.00000000000000E+00   7.47225002263596E-13
     -1.24489707955474E-22  -1.97306083010568E-08  -1.97298610760546E-08  -3.36529468414040E-18
      4.98058924687077E-07
      0.00000000000000E+00  -2.40408191877562E-11   0.00000000000000E+00   1.04774053329646E-13   3.25534920559487E-22
      2.40406964030602E-08   2.40408011771138E-08  -7.47929371253433E-19  -2.62999700579955E-01  -2.62999700579861E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.39610417167373E-11   0.00000000000000E+00  -9.39610417167373E-11
      3.95354809536418E-18  -4.66182345435930E-01  -4.58638266342060E-01   0.00000000000000E+00   8.57651095274793E-13
     -1.20027461015207E-22  -2.39476977864923E-08  -2.39468401353971E-08  -3.20561872411075E-18
      5.00058924687077E-07
      0.00000000000000E+00  -2.86460061560788E-11   0.00000000000000E+00   1.14297532946268E-13   2.99822710915492E-22
      2.86459370892120E-08   2.86460513867453E-08  -7.20173115654070E-19  -2.79068407712643E-01  -2.79068407712545E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.77701493399583E-11   0.00000000000000E+00  -9.77701493399583E-11
      3.75800779668427E-18  -4.22990593123204E-01  -4.13996749736728E-01   0.00000000000000E+00   9.37545932023292E-13
     -1.14869610580708E-22  -2.85492187833372E-08  -2.85482812374053E-08  -3.03783468103020E-18
      5.02058924687077E-07
      0.00000000000000E+00  -3.35420654071376E-11   0.00000000000000E+00   1.21532889281520E-13   2.69433102491513E-22
      3.35419087419194E-08   3.35420302748089E-08  -6.92767745056491E-19  -2.94809866829240E-01  -2.94809866829139E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01028252898383E-10   0.00000000000000E+00  -1.01028252898383E-10
      3.55595129088750E-18  -3.71073821441889E-01  -3.60538384342375E-01   0.00000000000000E+00   9.90206187429508E-13
     -1.08942863037782E-22  -3.34419922280979E-08  -3.34410020219105E-08  -2.86318354583101E-18
      5.04058924687077E-07
      0.00000000000000E+00  -3.85251016243320E-11   0.00000000000000E+00   1.23747228771393E-13   2.41333486142492E-22
      3.85249761648105E-08   3.85250999120395E-08  -6.65644016040088E-19  -3.10230764612736E-01  -3.10230764612632E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04068629851490E-10   0.00000000000000E+00  -1.04068629851490E-10
      3.34781403118452E-18  -3.10442202138280E-01  -2.98337598672591E-01   0.00000000000000E+00   9.91167161814444E-13
     -1.01987749261026E-22  -3.84220224493497E-08  -3.84210312821880E-08  -2.68217001514443E-18
      5.06058924687077E-07
      0.00000000000000E+00  -4.29858168210271E-11   0.00000000000000E+00   1.10869941471534E-13   2.16328347683066E-22
      4.29857433647106E-08   4.29858542346523E-08  -6.38977503405270E-19  -3.25332815778412E-01  -3.25332815778303E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09386597951338E-10   0.00000000000000E+00  -1.09386597951338E-10
      3.12904083528185E-18  -2.42315893593133E-01  -2.28807356453173E-01   0.00000000000000E+00   8.74969649711844E-13
     -9.37363160333391E-23  -4.28773426063506E-08  -4.28764676367010E-08  -2.49006333187658E-18
      5.08058924687077E-07
      0.00000000000000E+00  -4.58983052826150E-11   0.00000000000000E+00   7.25308084408739E-14   1.75350562463262E-22
      4.58981937448142E-08   4.58982662756228E-08  -6.13154770532308E-19  -3.40112443022003E-01  -3.40112443021883E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19685721031292E-10   0.00000000000000E+00  -1.19685721031292E-10
      2.88966939321926E-18  -1.69850435186701E-01  -1.55427367867599E-01   0.00000000000000E+00   6.54275648741689E-13
     -8.55410520817296E-23  -4.57792348302401E-08  -4.57785805545914E-08  -2.27651462268696E-18
      5.10058924687077E-07
      0.00000000000000E+00  -4.59895989513993E-11   0.00000000000000E+00   2.13996783324412E-15   1.10182895665255E-22
      4.59895539862825E-08   4.59895561262504E-08  -5.88119658914901E-19  -3.54577776506447E-01  -3.54577776506318E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.29032403499445E-10   0.00000000000000E+00  -1.29032403499445E-10
      2.63160458622037E-18  -9.86094189609110E-02  -8.41603994086273E-02   0.00000000000000E+00   4.77847080001781E-13
     -7.50640541192911E-23  -4.58610015698310E-08  -4.58605237227510E-08  -2.04348492730547E-18
      5.12058924687077E-07
      0.00000000000000E+00  -3.68428734176389E-11   0.00000000000000E+00  -2.26226750713348E-13   4.64570933738732E-23
      3.68431203468202E-08   3.68428941200695E-08  -5.60815726577748E-19  -3.68777241276226E-01  -3.68777241276109E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16761798385597E-10   0.00000000000000E+00  -1.16761798385597E-10
      2.39808098944918E-18  -4.65656043023941E-02  -3.49944448943763E-02   0.00000000000000E+00   4.81123800460103E-13
     -4.11916416497130E-23  -3.67266134454843E-08  -3.67261323216839E-08  -1.83726526287143E-18
      5.14058924687077E-07
      0.00000000000000E+00  -2.32131144160419E-11   0.00000000000000E+00  -3.36651738193247E-13   1.82957597132640E-23
      2.32134044081516E-08   2.32130677564135E-08  -5.28373183425211E-19  -3.82760889935848E-01  -3.82760889935766E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.15523025608192E-11   0.00000000000000E+00  -8.15523025608192E-11
      2.23497638432754E-18  -2.20697209333030E-02  -1.47817469880217E-02   0.00000000000000E+00   4.44191379951728E-13
     -1.76101054677452E-23  -2.31319596452326E-08  -2.31315154538527E-08  -1.70660320090233E-18
      5.16058924687077E-07
      0.00000000000000E+00  -1.56669671175971E-11   0.00000000000000E+00  -1.77270799993709E-13   9.04158285624343E-24
      1.56671464354671E-08   1.56669691646671E-08  -4.94448397107201E-19  -3.96503661899165E-01  -3.96503661899104E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.12794380495409E-11   0.00000000000000E+00  -6.12794380495409E-11
      2.11241750822846E-18  -1.27337781533461E-02  -7.81693921158533E-03   0.00000000000000E+00   2.32428153336516E-13
     -9.49517837814766E-24  -1.56059221547709E-08  -1.56056897266176E-08  -1.61796911112126E-18
      5.18058924687077E-07
      0.00000000000000E+00  -1.27258230980005E-11   0.00000000000000E+00  -7.22477606739763E-14   5.89065155625503E-24
      1.27258535020931E-08   1.27257812543324E-08  -4.60826078289697E-19  -4.09984029912698E-01  -4.09984029912644E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.43987648995983E-11   0.00000000000000E+00  -5.43987648995983E-11
      2.00361997842926E-18  -9.29523090549635E-03  -5.30288960462404E-03   0.00000000000000E+00   1.10549349812947E-13
     -6.54422527488982E-24  -1.26714930387826E-08  -1.26713824894328E-08  -1.54279390013957E-18
      5.20058924687077E-07
      0.00000000000000E+00  -1.17129593360759E-11   0.00000000000000E+00  -2.46914394697173E-14   4.65780276130245E-24
      1.17129776966627E-08   1.17129530052233E-08  -4.27910474004603E-19  -4.23196808075876E-01  -4.23196808075823E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.27801265098997E-11   0.00000000000000E+00  -5.27801265098997E-11
      1.89805972540946E-18  -7.88593930270140E-03  -4.21219473663514E-03   0.00000000000000E+00   5.60728747568174E-14
     -4.98781142235620E-24  -1.16602289515881E-08  -1.16601728787133E-08  -1.47014925140486E-18
      5.22058924687077E-07
      0.00000000000000E+00  -1.13661536083803E-11   0.00000000000000E+00  -8.28570934805033E-15   3.83301395687826E-24
      1.13662357380304E-08   1.13662274523210E-08  -3.95826493923119E-19  -4.36143867510320E-01  -4.36143867510267E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.28641971374972E-11   0.00000000000000E+00  -5.28641971374972E-11
      1.79233133113447E-18  -7.17189204831605E-03  -3.60741384817527E-03   0.00000000000000E+00   3.58146567840719E-14
     -4.41959791106559E-24  -1.13133990698403E-08  -1.13133632551835E-08  -1.39650483721135E-18
      5.24058924687078E-07
      0.00000000000000E+00  -1.12333461183782E-11   0.00000000000000E+00  -3.03386140560416E-15   3.35593356714401E-24
      1.12333310440689E-08   1.12333280102075E-08  -3.64649333564595E-19  -4.48829396707486E-01  -4.48829396707433E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.34313526703479E-11   0.00000000000000E+00  -5.34313526703479E-11
      1.68546862579377E-18  -6.72549720510133E-03  -3.20306815458704E-03   0.00000000000000E+00   2.77868919455040E-14
     -3.87509761253401E-24  -1.11799244444291E-08  -1.11798966575372E-08  -1.32081929222918E-18
      5.26058924687078E-07
      0.00000000000000E+00  -1.11704324733910E-11   0.00000000000000E+00  -1.32749710591017E-15   3.00954888231847E-24
      1.11704146869738E-08   1.11704133594767E-08  -3.34430144178475E-19  -4.61258206979985E-01  -4.61258206979931E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.40838617276187E-11   0.00000000000000E+00  -5.40838617276187E-11
      1.57730090233854E-18  -6.40696568852266E-03  -2.90456293902173E-03   0.00000000000000E+00   2.38219566440942E-14
     -3.45791790781773E-24  -1.11163533197057E-08  -1.11163294977491E-08  -1.24287075816006E-18
      5.28058924687078E-07
      0.00000000000000E+00  -1.11336027337708E-11   0.00000000000000E+00  -7.00908929938107E-16   2.74437534862837E-24
      1.11336083760641E-08   1.11336076751551E-08  -3.05196981410187E-19  -4.73435114790308E-01  -4.73435114790254E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.46866600041072E-11   0.00000000000000E+00  -5.46866600041072E-11
      1.46792758233032E-18  -6.16408748070302E-03  -2.67346944046109E-03   0.00000000000000E+00   2.12761610059126E-14
     -3.12558417722280E-24  -1.10789422913120E-08  -1.10789210151510E-08  -1.16273060092013E-18
      5.30058924687078E-07
      0.00000000000000E+00  -1.11088964994620E-11   0.00000000000000E+00  -4.17724388080323E-16   2.53479369614819E-24
      1.11089096773787E-08   1.11089092596543E-08  -2.76957716002167E-19  -4.85364539653079E-01  -4.85364539653024E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.51883292300534E-11   0.00000000000000E+00  -5.51883292300534E-11
      1.35755092387021E-18  -5.97249253569230E-03  -2.48981287298565E-03   0.00000000000000E+00   1.93353165796978E-14
     -2.85544612671392E-24  -1.10537402657408E-08  -1.10537209304243E-08  -1.08059320786805E-18
      5.32058924687078E-07
      0.00000000000000E+00  -1.10910786204437E-11   0.00000000000000E+00  -2.61564430798252E-16   2.36527530732801E-24
      1.10910975093820E-08   1.10910972478176E-08  -2.49705890985204E-19  -4.97049723498185E-01  -4.97049723498130E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.55643747900895E-11   0.00000000000000E+00  -5.55643747900895E-11
      1.24642217429004E-18  -5.81813605065050E-03  -2.34118562273783E-03   0.00000000000000E+00   1.77343640159235E-14
     -2.63281416335815E-24  -1.10355506073915E-08  -1.10355328730275E-08  -9.96716283304831E-19
      5.34058924687078E-07
      0.00000000000000E+00  -1.10776692888114E-11   0.00000000000000E+00  -1.64429064088184E-16   2.22561213045368E-24
      1.10777066802258E-08   1.10777065157968E-08  -2.23431185137800E-19  -5.08489991665821E-01  -5.08489991665765E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.57897882581012E-11   0.00000000000000E+00  -5.57897882581012E-11
      1.13484259777383E-18  -5.69180615112526E-03  -2.21914460474066E-03   0.00000000000000E+00   1.63649688005350E-14
     -2.44724087422630E-24  -1.10219330925075E-08  -1.10219167275387E-08  -9.11411412636033E-19
      5.36058924687078E-07
      0.00000000000000E+00  -1.10671989887698E-11   0.00000000000000E+00  -1.03166327330115E-16   2.10885764970155E-24
      1.10672303997252E-08   1.10672302965589E-08  -1.98148665061444E-19  -5.19669161816402E-01  -5.19669161816346E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.57863294497475E-11   0.00000000000000E+00  -5.57863294497475E-11
      1.02326993887434E-18  -5.58711820852538E-03  -2.11775525182098E-03   0.00000000000000E+00   1.51555319092818E-14
     -2.29115159371358E-24  -1.10114591226411E-08  -1.10114439671092E-08  -8.25121273812894E-19
      5.38058924687078E-07
      0.00000000000000E+00  -1.10583818939978E-11   0.00000000000000E+00  -7.42995684506702E-17   2.01037317828009E-24
      1.10583958477533E-08   1.10583957734538E-08  -1.73977207071336E-19  -5.30520351890166E-01  -5.30520351890111E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.52914951698164E-11   0.00000000000000E+00  -5.52914951698164E-11
      9.12686948534705E-19  -5.49968317867016E-03  -2.03294687933550E-03   0.00000000000000E+00   1.40145353923996E-14
     -2.15934496541933E-24  -1.10031182928194E-08  -1.10031042782840E-08  -7.38709741463369E-19
      5.40058924687078E-07
      0.00000000000000E+00  -1.10500240229120E-11   0.00000000000000E+00  -7.35352238055598E-17   1.92719810697977E-24
      1.10500583542035E-08   1.10500582806683E-08  -1.51186139142565E-19  -5.40902191251887E-01  -5.40902191251833E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.38986555023461E-11   0.00000000000000E+00  -5.38986555023461E-11
      8.04889637530013E-19  -5.42656141064761E-03  -1.96201249360743E-03   0.00000000000000E+00   1.28365943488331E-14
     -2.04839682970911E-24  -1.09961724617603E-08  -1.09961596251659E-08  -6.53703498387447E-19
      5.42058924687078E-07
      0.00000000000000E+00  -1.10413906176145E-11   0.00000000000000E+00  -9.47146673667277E-17   1.85743287644940E-24
      1.10413828834622E-08   1.10413827887475E-08  -1.30160407363429E-19  -5.50611550792119E-01  -5.50611550792068E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.12449800719845E-11   0.00000000000000E+00  -5.12449800719845E-11
      7.02399677386043E-19  -5.36574717080147E-03  -1.90309495291320E-03   0.00000000000000E+00   1.15559876869118E-14
     -1.95594153580698E-24  -1.09901493646632E-08  -1.09901378086755E-08  -5.72239270022614E-19
      5.44058924687078E-07
      0.00000000000000E+00  -1.10315632307332E-11   0.00000000000000E+00  -1.36923505662313E-16   1.79994465481599E-24
      1.10315932545466E-08   1.10315931176231E-08  -1.11421825431873E-19  -5.59372193239187E-01  -5.59372193239140E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.68973365726984E-11   0.00000000000000E+00  -4.68973365726984E-11
      6.08605004240647E-19  -5.31594607278800E-03  -1.85500791039472E-03   0.00000000000000E+00   1.00923899910580E-14
     -1.88055421987455E-24  -1.09847058734404E-08  -1.09846957810504E-08  -4.97183178808773E-19
      5.46058924687078E-07
      0.00000000000000E+00  -1.10198071043707E-11   0.00000000000000E+00  -2.04841831918342E-16   1.75432946272031E-24
      1.10197899980671E-08   1.10197897932253E-08  -9.56896021579177E-20  -5.66805682150970E-01  -5.66805682150930E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.02610967014468E-11   0.00000000000000E+00  -4.02610967014468E-11
      5.28082810837753E-19  -5.27653388809658E-03  -1.81722324329894E-03   0.00000000000000E+00   8.34845664004673E-15
     -1.82181095096213E-24  -1.09795370449805E-08  -1.09795286965238E-08  -4.32393208679835E-19
      5.48058924687078E-07
      0.00000000000000E+00  -1.10049282569431E-11   0.00000000000000E+00  -3.00619694301095E-16   1.72090336269840E-24
      1.10049416900284E-08   1.10049413894087E-08  -8.39097053068631E-20  -5.72418311388573E-01  -5.72418311388542E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.06739652368925E-11   0.00000000000000E+00  -3.06739652368925E-11
      4.66734880363968E-19  -5.24752248644718E-03  -1.78986916818913E-03   0.00000000000000E+00   6.20539915067029E-15
     -1.78029694597558E-24  -1.09742736295709E-08  -1.09742674241718E-08  -3.82825175057105E-19
      5.50058924687078E-07
      0.00000000000000E+00  -1.09861000858155E-11   0.00000000000000E+00  -4.28940108555035E-16   1.70073228484032E-24
      1.09860937257104E-08   1.09860932967703E-08  -7.72385517078570E-20  -5.75614060451220E-01  -5.75614060451203E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.75716784126607E-11   0.00000000000000E+00  -1.75716784126607E-11
      4.31591523538647E-19  -5.22961531249356E-03  -1.77377212797317E-03   0.00000000000000E+00   3.55537023366399E-15
     -1.75768265975538E-24  -1.09685251737279E-08  -1.09685216183577E-08  -3.54352971830789E-19
      5.52058924687078E-07
      0.00000000000000E+00  -1.09624959883532E-11   0.00000000000000E+00  -5.80958359762205E-16   1.69577589760038E-24
      1.09624820930956E-08   1.09624815121372E-08  -7.70067028265497E-20  -5.75724093306355E-01  -5.75724093306354E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.17465534054448E-13   0.00000000000000E+00  -6.17465534054448E-13
      4.30356592470538E-19  -5.22435389569777E-03  -1.77060829674917E-03   0.00000000000000E+00   2.83875141377158E-16
     -1.75703793910690E-24  -1.09618643304783E-08  -1.09618640466032E-08  -3.53349889643989E-19
      5.54058924687078E-07
      0.00000000000000E+00  -1.09334730513956E-11   0.00000000000000E+00  -7.57747330410571E-16   1.70928945673097E-24
      1.09334309989712E-08   1.09334302412239E-08  -8.46994319705343E-20  -5.72036804054693E-01  -5.72036804054713E-01
      0.00000000000000E+00   0.00000000000000E+00   2.02460341046733E-11   0.00000000000000E+00   2.02460341046733E-11
      4.70848660679884E-19  -5.23447294494757E-03  -1.78330727331654E-03   0.00000000000000E+00  -3.73202271831209E-15
     -1.78364989272534E-24  -1.09536725433059E-08  -1.09536762753286E-08  -3.86149228709351E-19
      5.56058924687078E-07
      0.00000000000000E+00  -1.08980209828335E-11   0.00000000000000E+00  -1.24157687078186E-15   1.74674076840952E-24
      1.08980624789619E-08   1.08980612373850E-08  -1.01987222953359E-19  -5.63814536277043E-01  -5.63814536277088E-01
      0.00000000000000E+00   0.00000000000000E+00   4.48059002543411E-11   0.00000000000000E+00   4.48059002543411E-11
      5.60460461188566E-19  -5.26479182348726E-03  -1.81703218307547E-03   0.00000000000000E+00  -8.40168349721156E-15
     -1.84690562618223E-24  -1.09428587359559E-08  -1.09428671376394E-08  -4.58473238235207E-19
      5.58058924687078E-07
      0.00000000000000E+00  -1.08547621116088E-11   0.00000000000000E+00  -1.23034303361902E-15   1.81773097423535E-24
      1.08547103443301E-08   1.08547091139871E-08  -1.30817186206050E-19  -5.50296233928047E-01  -5.50296233928119E-01
      0.00000000000000E+00   0.00000000000000E+00   7.25535734960630E-11   0.00000000000000E+00   7.25535734960630E-11
      7.05567608180693E-19  -5.32428820710618E-03  -1.88144598125434E-03   0.00000000000000E+00  -1.48623715628877E-14
     -1.96459626789498E-24  -1.09272478251116E-08  -1.09272626874831E-08  -5.74750421974644E-19
      5.60058924687078E-07
      0.00000000000000E+00  -1.07995634245470E-11   0.00000000000000E+00  -2.00990346866003E-14   1.94005189317213E-24
      1.07996017361293E-08   1.07995816370946E-08  -1.73552753840918E-19  -5.30698652931410E-01  -5.30698652931513E-01
      0.00000000000000E+00   0.00000000000000E+00   1.02511504499747E-10   0.00000000000000E+00   1.02511504499747E-10
      9.10590617180186E-19  -5.43104809093577E-03  -1.99613137718947E-03   0.00000000000000E+00  -4.35307398558873E-15
     -2.17369324461994E-24  -1.09020887885203E-08  -1.09020931415943E-08  -7.37037863339267E-19
      5.62058924687078E-07
      0.00000000000000E+00  -1.07230567584532E-11   0.00000000000000E+00  -2.41474923845464E-15   2.14850865349923E-24
      1.07230885826589E-08   1.07230861679097E-08  -2.33115928911994E-19  -5.04234288917344E-01  -5.04234288917477E-01
      0.00000000000000E+00   0.00000000000000E+00   1.32846879903714E-10   0.00000000000000E+00   1.32846879903714E-10
      1.17628437698761E-18  -5.62523712865228E-03  -2.20487214431389E-03   0.00000000000000E+00  -3.34491372095744E-14
     -2.56173985930485E-24  -1.08558995986762E-08  -1.08559330478134E-08  -9.43168448075621E-19
      5.64058924687078E-07
      0.00000000000000E+00  -1.05966784000556E-11   0.00000000000000E+00  -3.64672599279931E-15   2.51282874675485E-24
      1.05966860617226E-08   1.05966824149966E-08  -3.12963595549145E-19  -4.70158810595547E-01  -4.70158810595708E-01
      0.00000000000000E+00   0.00000000000000E+00   1.60381032774576E-10   0.00000000000000E+00   1.60381032774576E-10
      1.49704644253677E-18  -6.00810072922258E-03  -2.61889012376815E-03   0.00000000000000E+00  -4.89532278779761E-14
     -3.37847368633713E-24  -1.07570144945433E-08  -1.07570634477712E-08  -1.18408284698762E-18
      5.66058924687078E-07
      0.00000000000000E+00  -1.03221544805423E-11   0.00000000000000E+00  -4.75807719865724E-14   3.14834109542627E-24
      1.03221813837373E-08   1.03221338029653E-08  -4.16286633741036E-19  -4.27839045722247E-01  -4.27839045722428E-01
      0.00000000000000E+00   0.00000000000000E+00   1.80786072502291E-10   0.00000000000000E+00   1.80786072502291E-10
      1.85861858754135E-18  -6.87924756948881E-03  -3.57010255038869E-03   0.00000000000000E+00  -3.19603330683609E-14
     -5.52577968243658E-24  -1.05028879151345E-08  -1.05029198754676E-08  -1.44233195380031E-18
      5.68058924687078E-07
      0.00000000000000E+00  -9.52503400631818E-12   0.00000000000000E+00  -2.08570365321553E-14   3.91892720912221E-24
      9.52501751876356E-09   9.52499666172703E-09  -5.42833460616978E-19  -3.76824959354670E-01  -3.76824959354863E-01
      0.00000000000000E+00   0.00000000000000E+00   1.92385283905498E-10   0.00000000000000E+00   1.92385283905498E-10
      2.24338915535235E-18  -9.26749627442844E-03  -6.20587018717862E-03   0.00000000000000E+00  -1.06416568794789E-13
     -1.29903394617335E-23  -9.71727552906372E-09  -9.71738194563253E-09  -1.70055569473537E-18
      5.70058924687079E-07
      0.00000000000000E+00  -7.10446595721382E-12   0.00000000000000E+00  -6.15139256412343E-14   1.50351081881822E-24
      7.10447019329297E-09   7.10440867936733E-09  -6.83278601240834E-19  -3.17057384413579E-01  -3.17057384413786E-01
      0.00000000000000E+00   0.00000000000000E+00   2.07153738197343E-10   0.00000000000000E+00   2.07153738197343E-10
      2.65769663174703E-18  -1.63084545490472E-02  -1.40048333774445E-02   0.00000000000000E+00  -1.53701924220558E-13
     -3.71972710264415E-23  -7.31140871564041E-09  -7.31156241756467E-09  -1.97441803050620E-18
      5.72058924687079E-07
      0.00000000000000E+00  -3.09333074914950E-12   0.00000000000000E+00  -1.01464762285770E-13  -1.38857335055849E-23
      3.09342670461803E-09   3.09332523985573E-09  -8.26023152837264E-19  -2.49581783393018E-01  -2.49581783393253E-01
      0.00000000000000E+00   0.00000000000000E+00   2.34224614591571E-10   0.00000000000000E+00   2.34224614591571E-10
      3.12614586093017E-18  -3.09924468006819E-02  -2.99440578778868E-02   0.00000000000000E+00  -2.52552359459521E-13
     -7.17981186388660E-23  -3.32729730208777E-09  -3.32754985444730E-09  -2.30012270809291E-18
      5.74058924687079E-07
      0.00000000000000E+00  -7.38799066097345E-13   0.00000000000000E+00  -6.15128884648394E-14  -3.33574618829199E-23
      7.38875325422796E-10   7.38813812534298E-10  -9.71611887844175E-19  -1.77376056280455E-01  -1.77376056280699E-01
      0.00000000000000E+00   0.00000000000000E+00   2.44733704299202E-10   0.00000000000000E+00   2.44733704299202E-10
      3.61561326952857E-18  -4.99622056595360E-02  -4.96523284558406E-02   0.00000000000000E+00  -4.63102043912642E-13
     -8.63627659441129E-23  -9.83084414789501E-10  -9.83547516833500E-10  -2.64400138168440E-18
      5.76058924687079E-07
      0.00000000000000E+00  -7.51289950357569E-14   0.00000000000000E+00  -2.07293991761876E-14  -4.29551358351404E-23
      7.51742872683314E-11   7.51535578691123E-11  -1.11749568840146E-18  -1.05486894376504E-01  -1.05486894376734E-01
      0.00000000000000E+00   0.00000000000000E+00   2.29433459665219E-10   0.00000000000000E+00   2.29433459665219E-10
      4.07448018885902E-18  -6.98794075928005E-02  -6.97834446384031E-02   0.00000000000000E+00  -7.06682995407846E-13
     -9.34919610667383E-23  -3.03880334538831E-10  -3.04587017534332E-10  -2.95698450045756E-18
      5.78058924687079E-07
      0.00000000000000E+00   2.73697316878430E-14   0.00000000000000E+00  -6.41276489259073E-15  -4.54874619608017E-23
     -2.74028649759347E-11  -2.74092777408728E-11  -1.22975027849749E-18  -5.04920269518976E-02  -5.04920269520748E-02
      0.00000000000000E+00   0.00000000000000E+00   1.77228301051397E-10   0.00000000000000E+00   1.77228301051397E-10
      4.42893679096181E-18  -8.97009955192488E-02  -8.96537937047385E-02   0.00000000000000E+00  -7.60916623037322E-13
     -9.99294752033481E-23  -1.49058106687387E-10  -1.49819023310525E-10  -3.19918651246432E-18
      5.80058924687079E-07
      0.00000000000000E+00   1.38685553183365E-14   0.00000000000000E+00  -1.40393098909016E-15  -4.60069363007257E-23
     -1.38416710420332E-11  -1.38430749730683E-11  -1.28665363335311E-18  -2.36661169071754E-02  -2.36661169072852E-02
      0.00000000000000E+00   0.00000000000000E+00   1.09866330381461E-10   0.00000000000000E+00   1.09866330381461E-10
      4.64866945172473E-18  -1.09230488572601E-01  -1.09200235770661E-01   0.00000000000000E+00  -5.25658400800179E-13
     -1.03707327730227E-22  -9.54975970074885E-11  -9.60232554083924E-11  -3.36201581837162E-18
      5.82058924687079E-07
      0.00000000000000E+00  -5.69437370686666E-15   0.00000000000000E+00   1.76789523838360E-16  -4.58229868806352E-23
      5.70797360333406E-12   5.70815039281208E-12  -1.31026687144131E-18  -1.33171748588093E-02  -1.33171748588773E-02
      0.00000000000000E+00   0.00000000000000E+00   6.79738146938897E-11   0.00000000000000E+00   6.79738146938897E-11
      4.78461708111251E-18  -1.28410433061312E-01  -1.28387219236241E-01   0.00000000000000E+00  -3.46130522217246E-13
     -1.05945514780311E-22  -7.33358345643789E-11  -7.36819650867021E-11  -3.47435020967120E-18
      5.84058924687079E-07
      0.00000000000000E+00  -1.91955500763731E-14   0.00000000000000E+00   4.97392067811789E-16  -4.50215682567179E-23
      1.92385142458997E-11   1.92390116379225E-11  -1.31910367916289E-18  -9.51746737344084E-03  -9.51746737348740E-03
      0.00000000000000E+00   0.00000000000000E+00   4.65612561558584E-11   0.00000000000000E+00   4.65612561558584E-11
      4.87773959342423E-18  -1.47217799745778E-01  -1.47197069227398E-01   0.00000000000000E+00  -2.81608662920991E-13
     -1.07662204996943E-22  -6.55186591307520E-11  -6.58002677937806E-11  -3.55863591426134E-18
      5.86058924687079E-07
      0.00000000000000E+00  -2.86555580087483E-14   0.00000000000000E+00   4.63770738690058E-16  -4.33356477508748E-23
      2.86573137652817E-11   2.86577775359770E-11  -1.32179411286888E-18  -7.98647276510125E-03  -7.98647276513648E-03
      0.00000000000000E+00   0.00000000000000E+00   3.52290263881884E-11   0.00000000000000E+00   3.52290263881884E-11
      4.94819764620061E-18  -1.65647354462546E-01  -1.65627226896944E-01   0.00000000000000E+00  -2.70827745449819E-13
     -1.09246248254186E-22  -6.36159761786062E-11  -6.38868039241653E-11  -3.62640353333173E-18
      5.88058924687079E-07
      0.00000000000000E+00  -3.57276027737279E-14   0.00000000000000E+00   3.68574342711686E-16  -4.03714983364378E-23
      3.57361714150480E-11   3.57365399893504E-11  -1.32189952604816E-18  -7.22897524013280E-03  -7.22897524016139E-03
      0.00000000000000E+00   0.00000000000000E+00   2.85832704172515E-11   0.00000000000000E+00   2.85832704172515E-11
      5.00536418703511E-18  -1.83702057602194E-01  -1.83681793721317E-01   0.00000000000000E+00  -2.76278315921656E-13
     -1.10807222468652E-22  -6.40435320905696E-11  -6.43198104066021E-11  -3.68346466098695E-18
      5.90058924687079E-07
      0.00000000000000E+00  -4.14219764805946E-14   0.00000000000000E+00   2.87510554531010E-16  -3.57010866411850E-23
      4.14462811867892E-11   4.14465686973080E-11  -1.32089682496923E-18  -6.76405687524375E-03  -6.76405687526805E-03
      0.00000000000000E+00   0.00000000000000E+00   2.43058887482187E-11   0.00000000000000E+00   2.43058887482187E-11
      5.05397596453155E-18  -2.01388280363873E-01  -2.01367565235218E-01   0.00000000000000E+00  -2.84219851523736E-13
     -1.12365094567707E-22  -6.54682375938905E-11  -6.57524574455266E-11  -3.73307913956231E-18
      5.92058924687079E-07
      0.00000000000000E+00  -4.62897475525935E-14   0.00000000000000E+00   2.31287797382455E-16  -2.89299385511405E-23
      4.63311419007221E-11   4.63313731884905E-11  -1.31943104664525E-18  -6.43558163288561E-03  -6.43558163290699E-03
      0.00000000000000E+00   0.00000000000000E+00   2.13799180620046E-11   0.00000000000000E+00   2.13799180620046E-11
      5.09673580065555E-18  -2.18713580101986E-01  -2.18692247960094E-01   0.00000000000000E+00  -2.90872339274371E-13
     -1.13917415600241E-22  -6.74204189111066E-11  -6.77112912504949E-11  -3.77730475401031E-18
      5.94058924687079E-07
      0.00000000000000E+00  -5.06982949385548E-14   0.00000000000000E+00   1.94854979874039E-16  -1.98006566164859E-23
      5.07147249466484E-11   5.07149198016085E-11  -1.31779764868333E-18  -6.18633015117555E-03  -6.18633015119485E-03
      0.00000000000000E+00   0.00000000000000E+00   1.93009746368513E-11   0.00000000000000E+00   1.93009746368513E-11
      5.13533774992925E-18  -2.35685600570728E-01  -2.35663542492768E-01   0.00000000000000E+00  -2.95703270702802E-13
     -1.15458684349999E-22  -6.97201911676420E-11  -7.00158944384603E-11  -3.81754010124593E-18
      5.96058924687079E-07
      0.00000000000000E+00  -5.48313081128935E-14   0.00000000000000E+00   1.71768699713980E-16  -8.32098592842230E-24
      5.47930096451470E-11   5.47931814138384E-11  -1.31613331140979E-18  -5.99023462718784E-03  -5.99023462720562E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77807680166993E-11   0.00000000000000E+00   1.77807680166993E-11
      5.17089928596265E-18  -2.52311567019341E-01  -2.52288703168060E-01   0.00000000000000E+00  -2.99059480925344E-13
     -1.16984858051085E-22  -7.22748899494952E-11  -7.25739494305375E-11  -3.85476597455286E-18
      5.98058924687079E-07
      0.00000000000000E+00  -5.86887870756096E-14   0.00000000000000E+00   1.57075703081671E-16   5.07943993735315E-24
      5.86823301849027E-11   5.86824872606109E-11  -1.31449838732527E-18  -5.83254355017369E-03  -5.83254355019033E-03
      0.00000000000000E+00   0.00000000000000E+00   1.66373043243945E-11   0.00000000000000E+00   1.66373043243945E-11
      5.20417389461144E-18  -2.68598318593825E-01  -2.68574589819664E-01   0.00000000000000E+00  -3.01449791604129E-13
     -1.18494087168215E-22  -7.50183417932824E-11  -7.53197915850050E-11  -3.88967550728617E-18
      6.00058924687079E-07
      0.00000000000000E+00  -6.24544213011182E-14   0.00000000000000E+00   1.47561876107377E-16   1.91614591951916E-23
      6.24524407049268E-11   6.24525882668221E-11  -1.31291596624270E-18  -5.70367265413738E-03  -5.70367265415313E-03
      0.00000000000000E+00   0.00000000000000E+00   1.57499820083060E-11   0.00000000000000E+00   1.57499820083060E-11
      5.23567385862806E-18  -2.84552904258179E-01  -2.84528267431391E-01   0.00000000000000E+00  -3.03356465143669E-13
     -1.19986392650073E-22  -7.78992138098651E-11  -7.82025702751287E-11  -3.92275789238535E-18
      6.02058924687079E-07
      0.00000000000000E+00  -6.61282107894193E-14   0.00000000000000E+00   1.41285417080413E-16   3.30599104810811E-23
      6.61476245548918E-11   6.61477658403420E-11  -1.31139140827266E-18  -5.59699720877493E-03  -5.59699720878996E-03
      0.00000000000000E+00   0.00000000000000E+00   1.50369934306881E-11   0.00000000000000E+00   1.50369934306881E-11
      5.26574784548943E-18  -3.00182811066706E-01  -3.00157234879327E-01   0.00000000000000E+00  -3.05181043062776E-13
     -1.21463217395920E-22  -8.08795782278463E-11  -8.11847592710305E-11  -3.95435643721677E-18
      6.04058924687079E-07
      0.00000000000000E+00  -6.98020002777203E-14   0.00000000000000E+00   1.37064534451044E-16   4.61490219583975E-23
      6.97971941999196E-11   6.97973312645003E-11  -1.30992222303221E-18  -5.50794804184913E-03  -5.50794804186357E-03
      0.00000000000000E+00   0.00000000000000E+00   1.44401768607219E-11   0.00000000000000E+00   1.44401768607219E-11
      5.29462819921088E-18  -3.15493541057507E-01  -3.15467003290416E-01   0.00000000000000E+00  -3.07175480055480E-13
     -1.22926883763272E-22  -8.39303326450431E-11  -8.42375081252215E-11  -3.98470597617866E-18
      6.06058924687079E-07
      0.00000000000000E+00  -7.33839450288139E-14   0.00000000000000E+00   1.34124038162306E-16   5.79713947127416E-23
      7.34195611399375E-11   7.34196952640336E-11  -1.30850325745017E-18  -5.43346347681249E-03  -5.43346347682640E-03
      0.00000000000000E+00   0.00000000000000E+00   1.39154981411013E-11   0.00000000000000E+00   1.39154981411013E-11
      5.32245919549308E-18  -3.30484339536010E-01  -3.30456826042496E-01   0.00000000000000E+00  -3.09397933738550E-13
     -1.24379512650338E-22  -8.70257954712724E-11  -8.73351934051353E-11  -4.01395593804290E-18
      6.07058924687079E-07
      0.00000000000000E+00  -7.52208397729644E-14   0.00000000000000E+00   1.33632318963021E-16   6.36236166083155E-23
      7.52398659713683E-11   7.52399996037509E-11  -1.30780503068519E-18  -5.40017244467071E-03  -5.40017244468436E-03
      0.00000000000000E+00   0.00000000000000E+00   1.36484835017220E-11   0.00000000000000E+00   1.36484835017220E-11
      5.33610767899480E-18  -3.37896157090890E-01  -3.37868154336011E-01   0.00000000000000E+00  -3.13016830188671E-13
     -1.25106615685598E-22  -8.85754662751579E-11  -8.88884831054717E-11  -4.02830264830961E-18
      6.08408924687079E-07
      0.00000000000000E+00  -7.77006476775676E-14   0.00000000000000E+00   1.31890599276389E-16   7.04309860673549E-23
      7.76827096411828E-11   7.76828415318525E-11  -1.30688243161073E-18  -5.36052851592860E-03  -5.36052851594193E-03
      0.00000000000000E+00   0.00000000000000E+00   1.33347022066678E-11   0.00000000000000E+00   1.33347022066678E-11
      5.35410952697380E-18  -3.47756524856467E-01  -3.47727851486177E-01   0.00000000000000E+00  -3.13953003318418E-13
     -1.26082908714212E-22  -9.07035907350766E-11  -9.10175437385211E-11  -4.04722709536307E-18
      6.10231424687079E-07
      0.00000000000000E+00  -8.10070582170386E-14   0.00000000000000E+00   1.29872829046166E-16   7.82217428283125E-23
      8.09656008272914E-11   8.09657307001987E-11  -1.30566879790225E-18  -5.31543455523925E-03  -5.31543455525220E-03
      0.00000000000000E+00   0.00000000000000E+00   1.29491021557726E-11   0.00000000000000E+00   1.29491021557726E-11
      5.37770926565270E-18  -3.60821673309444E-01  -3.60792087351273E-01   0.00000000000000E+00  -3.16283137530574E-13
     -1.27396045910545E-22  -9.35985497183134E-11  -9.39148328559714E-11  -4.07204046775045E-18
      6.12231424687079E-07
      0.00000000000000E+00  -8.45890029681321E-14   0.00000000000000E+00   1.29752001245985E-16   8.53445622136404E-23
      8.45794801988977E-11   8.45796099509843E-11  -1.30436529726612E-18  -5.27596735435453E-03  -5.27596735436711E-03
      0.00000000000000E+00   0.00000000000000E+00   1.25865695679493E-11   0.00000000000000E+00   1.25865695679493E-11
      5.40288240478860E-18  -3.74926563580611E-01  -3.74895953519220E-01   0.00000000000000E+00  -3.22074899721601E-13
     -1.28844387107627E-22  -9.68441046190830E-11  -9.71661795189334E-11  -4.09851710752247E-18
      6.14231424687079E-07
      0.00000000000000E+00  -8.81709477192257E-14   0.00000000000000E+00   1.29610718145684E-16   9.12645515957648E-23
      8.82149088523648E-11   8.82150384631742E-11  -1.30308407711912E-18  -5.24677590139281E-03  -5.24677590140505E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22372932514296E-11   0.00000000000000E+00   1.22372932514296E-11
      5.42735699129146E-18  -3.88808774530253E-01  -3.88777129413173E-01   0.00000000000000E+00  -3.29204337066338E-13
     -1.30304589829731E-22  -1.00123127377408E-10  -1.00452331714605E-10  -4.12427291417234E-18
      6.16231424687079E-07
      0.00000000000000E+00  -9.18447372075268E-14   0.00000000000000E+00   1.29392667571167E-16   9.61886809217537E-23
      9.18657048688829E-11   9.18658342616466E-11  -1.30182215448504E-18  -5.22859428559472E-03  -5.22859428560658E-03
      0.00000000000000E+00   0.00000000000000E+00   1.18659035889154E-11   0.00000000000000E+00   1.18659035889154E-11
      5.45108879846929E-18  -4.02438117526698E-01  -4.02405439493433E-01   0.00000000000000E+00  -3.36032382965018E-13
     -1.31774398770054E-22  -1.03395705467465E-10  -1.03731737850562E-10  -4.14926664398425E-18
      6.18231424687079E-07
      0.00000000000000E+00  -9.55185266958278E-14   0.00000000000000E+00   1.29327991619777E-16   1.00314393716847E-22
      9.55315783424603E-11   9.55317076705522E-11  -1.30057499105033E-18  -5.22294463479203E-03  -5.22294463480351E-03
      0.00000000000000E+00   0.00000000000000E+00   1.14796406194565E-11   0.00000000000000E+00   1.14796406194565E-11
      5.47404807970820E-18  -4.15801399235177E-01  -4.15767688235638E-01   0.00000000000000E+00  -3.43060494669933E-13
     -1.33253611431550E-22  -1.06668287795207E-10  -1.07011348290010E-10  -4.17347308865787E-18
      6.20231424687080E-07
      0.00000000000000E+00  -9.91923161841289E-14   0.00000000000000E+00   1.29683407319034E-16   1.03815907440869E-22
      9.92181540978252E-11   9.92182837813363E-11  -1.29933534381385E-18  -5.23251147402661E-03  -5.23251147403769E-03
      0.00000000000000E+00   0.00000000000000E+00   1.10841822389111E-11   0.00000000000000E+00   1.10841822389111E-11
      5.49621644418602E-18  -4.28897426813690E-01  -4.28862679237342E-01   0.00000000000000E+00  -3.50556931649893E-13
     -1.34742893622883E-22  -1.09951909088462E-10  -1.10302466020247E-10  -4.19688110037217E-18
      6.22231424687080E-07
      0.00000000000000E+00  -1.02957950409637E-13   0.00000000000000E+00   1.30840471480053E-16   1.06841005710168E-22
      1.02939439442490E-10   1.02939570283068E-10  -1.29809146654913E-18  -5.26201135747010E-03  -5.26201135748078E-03
      0.00000000000000E+00   0.00000000000000E+00   1.06793344743985E-11   0.00000000000000E+00   1.06793344743985E-11
      5.51757511313482E-18  -4.41729427838983E-01  -4.41693635724387E-01   0.00000000000000E+00  -3.58485038194644E-13
     -1.36242399296228E-22  -1.13260419719135E-10  -1.13618904757466E-10  -4.21948364658569E-18
      6.24231424687080E-07
      0.00000000000000E+00  -1.06723584635146E-13   0.00000000000000E+00   1.32389851036051E-16   1.09517674200205E-22
      1.06725966837333E-10   1.06726099227294E-10  -1.29682265350084E-18  -5.32020408921425E-03  -5.32020408922451E-03
      0.00000000000000E+00   0.00000000000000E+00   1.02595218261810E-11   0.00000000000000E+00   1.02595218261810E-11
      5.53809415678718E-18  -4.54301981718723E-01  -4.54265129243236E-01   0.00000000000000E+00  -3.66609175896010E-13
     -1.37750954345757E-22  -1.16619011877441E-10  -1.16985621053475E-10  -4.24127150328634E-18
      6.26231424687080E-07
      0.00000000000000E+00  -1.10672908335070E-13   0.00000000000000E+00   1.39560354823010E-16   1.11971116305258E-22
      1.10645042846684E-10   1.10645182407151E-10  -1.29548856941544E-18  -5.42468196777260E-03  -5.42468196778241E-03
      0.00000000000000E+00   0.00000000000000E+00   9.80984500346554E-12   0.00000000000000E+00   9.80984500346554E-12
      5.55771384679411E-18  -4.66619956459453E-01  -4.66582011291982E-01   0.00000000000000E+00  -3.74457862614636E-13
     -1.39265173970302E-22  -1.20080569547863E-10  -1.20455027410616E-10  -4.26222527737868E-18
      6.28231424687080E-07
      0.00000000000000E+00  -1.14897766246616E-13   0.00000000000000E+00   1.53011649220635E-16   1.14362931847011E-22
      1.14854869148679E-10   1.14855022160443E-10  -1.29400157964391E-18  -5.61436067753624E-03  -5.61436067754553E-03
      0.00000000000000E+00   0.00000000000000E+00   9.29217587258320E-12   0.00000000000000E+00   9.29217587258320E-12
      5.57629819853928E-18  -4.78688059522961E-01  -4.78648951508106E-01   0.00000000000000E+00  -3.80996379409152E-13
     -1.40777489195525E-22  -1.23766201653476E-10  -1.24147198033025E-10  -4.28229661889537E-18
      6.30231424687080E-07
      0.00000000000000E+00  -1.19765537318615E-13   0.00000000000000E+00   1.85488512552033E-16   1.17001224124179E-22
      1.19771851597357E-10   1.19772037085986E-10  -1.29214439533626E-18  -5.98685663623430E-03  -5.98685663624290E-03
      0.00000000000000E+00   0.00000000000000E+00   8.59929134272214E-12   0.00000000000000E+00   8.59929134272214E-12
      5.59349678122472E-18  -4.90510369510876E-01  -4.90469931096930E-01   0.00000000000000E+00  -3.83597002791599E-13
     -1.42270484191980E-22  -1.27987731425774E-10  -1.28371328428708E-10  -4.30135238588846E-18
      6.32231424687080E-07
      0.00000000000000E+00  -1.26653892609179E-13   0.00000000000000E+00   2.79555821796092E-16   1.20729256251355E-22
      1.26686408982192E-10   1.26686688538135E-10  -1.28928244923726E-18  -6.82938063541805E-03  -6.82938063542544E-03
      0.00000000000000E+00   0.00000000000000E+00   7.38267920351970E-12   0.00000000000000E+00   7.38267920351970E-12
      5.60826213963176E-18  -5.02089079248879E-01  -5.02046846171289E-01   0.00000000000000E+00  -3.74018626468098E-13
     -1.43696820557571E-22  -1.33695349115043E-10  -1.34069367741655E-10  -4.31897969039451E-18
      6.34231424687080E-07
      0.00000000000000E+00  -1.40430603190308E-13   0.00000000000000E+00   5.82228161875066E-16   1.28486061451649E-22
      1.40385904239591E-10   1.40386486467881E-10  -1.28324543440893E-18  -9.12543370242988E-03  -9.12543370243424E-03
      0.00000000000000E+00   0.00000000000000E+00   4.35628950179359E-12   0.00000000000000E+00   4.35628950179359E-12
      5.61697471863535E-18  -5.13419544536135E-01  -5.13373949570757E-01   0.00000000000000E+00  -3.22071625883311E-13
     -1.44901207951297E-22  -1.44420704343645E-10  -1.44742775969673E-10  -4.33372928422642E-18
      6.36231424687080E-07
      0.00000000000000E+00  -1.78729858605847E-13   0.00000000000000E+00   1.56894815704468E-15   1.49742920464598E-22
      1.78705687418034E-10   1.78707256366341E-10  -1.26719034376835E-18  -1.59216119980432E-02  -1.59216119980388E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.40293527653774E-12   0.00000000000000E+00  -4.40293527653774E-12
      5.60816884808227E-18  -5.24470199807027E-01  -5.24415293174656E-01   0.00000000000000E+00  -1.38605818345984E-13
     -1.45411808503982E-22  -1.74165715271313E-10  -1.74304321089804E-10  -4.34097850431392E-18
      6.38231424687080E-07
      0.00000000000000E+00  -2.77462951103938E-13   0.00000000000000E+00   3.65083769625285E-15   1.92919912500369E-22
      2.77455606676779E-10   2.77459257514668E-10  -1.23315295985607E-18  -3.03673296423378E-02  -3.03673296423178E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.00042075446078E-11   0.00000000000000E+00  -2.00042075446078E-11
      5.56816043299306E-18  -5.35142747409105E-01  -5.35061648173577E-01   0.00000000000000E+00   1.74206359554158E-13
     -1.44763636347181E-22  -2.57629256329470E-10  -2.57455049970061E-10  -4.33500747313699E-18
      6.40231424687080E-07
      0.00000000000000E+00  -4.62713786051520E-13   0.00000000000000E+00   5.98546705214262E-15   2.38512438431317E-22
      4.62747387082024E-10   4.62753372549314E-10  -1.18687252161312E-18  -4.92615967974838E-02  -4.92615967974521E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.16700983830577E-11   0.00000000000000E+00  -3.16700983830577E-11
      5.50482023622695E-18  -5.45269256363209E-01  -5.45133462966021E-01   0.00000000000000E+00   3.34003425573886E-13
     -1.43500447313472E-22  -4.31417277591687E-10  -4.31083274166256E-10  -4.31794771461382E-18
      6.42231424687080E-07
      0.00000000000000E+00  -7.66903555682848E-13   0.00000000000000E+00   8.82155705114746E-15   2.70932090074988E-22
      7.66864140290923E-10   7.66872961848245E-10  -1.13687662016917E-18  -6.91725470492293E-02  -6.91725470491914E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.78546996059840E-11   0.00000000000000E+00  -3.78546996059840E-11
      5.42911083701498E-18  -5.54619484011592E-01  -5.54389838010931E-01   0.00000000000000E+00   3.44989428925075E-13
     -1.42164612753894E-22  -7.29363251671044E-10  -7.29018262242261E-10  -4.29223421684581E-18
      6.44231424687080E-07
      0.00000000000000E+00  -1.23962841808999E-12   0.00000000000000E+00   1.28460381580843E-14   2.93112058715840E-22
      1.23965775849512E-09   1.23967060453357E-09  -1.08761073149721E-18  -8.90028056006419E-02  -8.90028056005997E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.22304437367139E-11   0.00000000000000E+00  -4.22304437367139E-11
      5.34464994954154E-18  -5.62878132700532E-01  -5.62500928055357E-01   0.00000000000000E+00   3.17288455244788E-13
     -1.40904800309946E-22  -1.19775744925196E-09  -1.19744016079685E-09  -4.25703921804434E-18
      6.46231424687080E-07
      0.00000000000000E+00  -1.94343463931127E-12   0.00000000000000E+00   1.84272852560461E-14   3.10758350526030E-22
      1.94345820198055E-09   1.94347662926612E-09  -1.04103528392623E-18  -1.08543979891951E-01  -1.08543979891905E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.67582398401112E-11   0.00000000000000E+00  -4.67582398401112E-11
      5.25113346986132E-18  -5.69618975417899E-01  -5.69021488386850E-01   0.00000000000000E+00   2.89390785626798E-13
     -1.39724252890303E-22  -1.89700778021149E-09  -1.89671838942601E-09  -4.21009818593509E-18
      6.48231424687080E-07
      0.00000000000000E+00  -2.94123586433384E-12   0.00000000000000E+00   2.55760039581345E-14   3.26098857208521E-22
      2.94124951024492E-09   2.94127508624921E-09  -9.97941300426451E-19  -1.27736875210503E-01  -1.27736875210451E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.20454840683400E-11   0.00000000000000E+00  -5.20454840683400E-11
      5.14704250172465E-18  -5.74303092160025E-01  -5.73392948632788E-01   0.00000000000000E+00   2.68869062326272E-13
     -1.38594676709133E-22  -2.88949847124305E-09  -2.88922960218087E-09  -4.14910120129819E-18
      6.50231424687080E-07
      0.00000000000000E+00  -4.28556728284041E-12   0.00000000000000E+00   3.40286521433330E-14   3.39243026989927E-22
      4.28549679927034E-09   4.28553082792282E-09  -9.58367640022987E-19  -1.46557605087847E-01  -1.46557605087789E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.81203545109753E-11   0.00000000000000E+00  -5.81203545109753E-11
      5.03080179270269E-18  -5.76300258353169E-01  -5.74968564556410E-01   0.00000000000000E+00   2.62084416333988E-13
     -1.37459929606194E-22  -4.22767255782805E-09  -4.22741047341185E-09  -4.07243415267971E-18
      6.52231424687080E-07
      0.00000000000000E+00  -6.01270756602795E-12   0.00000000000000E+00   4.33919990832710E-14   3.49634119013034E-22
      6.01269650112820E-09   6.01273989312763E-09  -9.21906707492256E-19  -1.65000519981587E-01  -1.65000519981522E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.46384504864031E-11   0.00000000000000E+00  -6.46384504864031E-11
      4.90152489172989E-18  -5.74920807124653E-01  -5.73047061779761E-01   0.00000000000000E+00   2.77857420894036E-13
     -1.36224135404372E-22  -5.94837930006198E-09  -5.94810144264123E-09  -3.97961818423763E-18
      6.54231424687080E-07
      0.00000000000000E+00  -8.14644450083321E-12   0.00000000000000E+00   5.33518034958848E-14   3.56654299288146E-22
      8.14643865198341E-09   8.14649200378726E-09  -8.87975502962416E-19  -1.83068398384762E-01  -1.83068398384691E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.10954596318442E-11   0.00000000000000E+00  -7.10954596318442E-11
      4.75933397246620E-18  -5.69441241198531E-01  -5.66897349261682E-01   0.00000000000000E+00   3.25155304545504E-13
     -1.34746951171603E-22  -8.07572169945983E-09  -8.07539654415541E-09  -3.87135846950378E-18
      6.56231424687080E-07
      0.00000000000000E+00  -1.07053307241721E-11   0.00000000000000E+00   6.36255676814429E-14   3.59755326095075E-22
      1.07053093312091E-08   1.07053729567772E-08  -8.55992935101086E-19  -2.00767541574936E-01  -2.00767541574859E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.70629242290139E-11   0.00000000000000E+00  -7.70629242290139E-11
      4.60520812400817E-18  -5.59114327807393E-01  -5.55766198276708E-01   0.00000000000000E+00   4.09022634199743E-13
     -1.32854597853291E-22  -1.06287190551822E-08  -1.06283100325481E-08  -3.74921518890709E-18
      6.58231424687080E-07
      0.00000000000000E+00  -1.37081025624350E-11   0.00000000000000E+00   6.60023580452215E-14   3.58382734834553E-22
      1.37080457415009E-08   1.37081117438593E-08  -8.25463362110800E-19  -2.18105489519016E-01  -2.18105489518934E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.23366907659479E-11   0.00000000000000E+00  -8.23366907659479E-11
      4.44053474247627E-18  -5.43169034023557E-01  -5.38876600072951E-01   0.00000000000000E+00   5.34393647326137E-13
     -1.30371074914608E-22  -1.36263094467405E-08  -1.36257750530933E-08  -3.61507138036547E-18
      6.60231424687080E-07
      0.00000000000000E+00  -1.71702817762099E-11   0.00000000000000E+00   8.60258690378108E-14   3.51796873853233E-22
      1.71702080063660E-08   1.71702940322354E-08  -7.96001372040064E-19  -2.35089894765820E-01  -2.35089894765733E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.69696341933022E-11   0.00000000000000E+00  -8.69696341933022E-11
      4.26659547408967E-18  -5.20816544793630E-01  -5.15434843093131E-01   0.00000000000000E+00   6.58393412715253E-13
     -1.27167041415273E-22  -1.70839827914547E-08  -1.70833243980421E-08  -3.47059410204961E-18
      6.62231424687080E-07
      0.00000000000000E+00  -2.10917765207597E-11   0.00000000000000E+00   9.73653023112759E-14   3.38891744750746E-22
      2.10916769726546E-08   2.10917743379573E-08  -7.67328322920049E-19  -2.51727999011786E-01  -2.51727999011695E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.11887047485595E-11   0.00000000000000E+00  -9.11887047485595E-11
      4.08421806459255E-18  -4.91279608503662E-01  -4.84663772646186E-01   0.00000000000000E+00   7.85598193128044E-13
     -1.23202513832142E-22  -2.10013712314017E-08  -2.10005856332087E-08  -3.31688974167251E-18
      6.64231424687081E-07
      0.00000000000000E+00  -2.54408085170105E-11   0.00000000000000E+00   1.07942938077217E-13   3.18432448102450E-22
      2.54406763175308E-08   2.54407842604692E-08  -7.39250723096024E-19  -2.68026644512461E-01  -2.68026644512366E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.51914140920519E-11   0.00000000000000E+00  -9.51914140920519E-11
      3.89383523640845E-18  -4.53851490347189E-01  -4.45866715789191E-01   0.00000000000000E+00   8.86575149473460E-13
     -1.18519131501308E-22  -2.53464794215265E-08  -2.53455928463771E-08  -3.15458451331242E-18
      6.66231424687081E-07
      0.00000000000000E+00  -3.01491371252171E-11   0.00000000000000E+00   1.16858351064416E-13   2.90690513356789E-22
      3.01489870001760E-08   3.01491038585273E-08  -7.11618585061842E-19  -2.83992858559548E-01  -2.83992858559449E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.88663140304517E-11   0.00000000000000E+00  -9.88663140304517E-11
      3.69610260834755E-18  -4.07964822888498E-01  -3.98497751651013E-01   0.00000000000000E+00   9.57680815248270E-13
     -1.13135045760116E-22  -3.00511952253120E-08  -3.00502375444969E-08  -2.98448402328570E-18
      6.68231424687081E-07
      0.00000000000000E+00  -3.51053546791469E-11   0.00000000000000E+00   1.23042643007842E-13   2.60203380170390E-22
      3.51052739333291E-08   3.51053969759724E-08  -6.84301717918626E-19  -2.99634133880117E-01  -2.99634133880015E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01943697163567E-10   0.00000000000000E+00  -1.01943697163567E-10
      3.49221521402041E-18  -3.53285966911860E-01  -3.42258222061722E-01   0.00000000000000E+00   9.99517663173118E-13
     -1.06924878892967E-22  -3.50044527964719E-08  -3.50034532788088E-08  -2.80791349610179E-18
      6.70231424687081E-07
      0.00000000000000E+00  -4.00211605487054E-11   0.00000000000000E+00   1.22101304223242E-13   2.33724511958322E-22
      4.00210719672862E-08   4.00211940685907E-08  -6.57287026223036E-19  -3.14956129889969E-01  -3.14956129889863E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05312658357445E-10   0.00000000000000E+00  -1.05312658357445E-10
      3.28158989730552E-18  -2.90088878803320E-01  -2.77513247741844E-01   0.00000000000000E+00   9.70714161440774E-13
     -9.95693053666266E-23  -3.99168521243946E-08  -3.99158814102332E-08  -2.62430287108249E-18
      6.72231424687081E-07
      0.00000000000000E+00  -4.41048530991636E-11   0.00000000000000E+00   1.01540725002220E-13   2.06529346411078E-22
      4.41047420680828E-08   4.41048436088080E-08  -6.30845123504976E-19  -3.29958348784786E-01  -3.29958348784674E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12082504268896E-10   0.00000000000000E+00  -1.12082504268896E-10
      3.05742488876773E-18  -2.20183244353442E-01  -2.06322944287202E-01   0.00000000000000E+00   8.13017355972443E-13
     -9.10445035601589E-23  -4.39935741218950E-08  -4.39927611045391E-08  -2.42657976526275E-18
      6.74231424687081E-07
      0.00000000000000E+00  -4.63816841345382E-11   0.00000000000000E+00   5.71324099384839E-14   1.56799672388707E-22
      4.63815822071670E-08   4.63816393395771E-08  -6.05312254421548E-19  -3.44638470796488E-01  -3.44638470796365E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.23204705832149E-10   0.00000000000000E+00  -1.23204705832149E-10
      2.81101547710343E-18  -1.47205717093465E-01  -1.32631418215230E-01   0.00000000000000E+00   5.87224556619890E-13
     -7.86958113557135E-23  -4.62590218583014E-08  -4.62584346337449E-08  -2.20570322268189E-18
      6.76231424687081E-07
      0.00000000000000E+00  -4.45150316955324E-11   0.00000000000000E+00  -4.39710105098983E-14   8.72283416255534E-23
      4.45150617385482E-08   4.45150177675378E-08  -5.80206224399714E-19  -3.59012657484410E-01  -3.59012657484281E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.29270090537899E-10   0.00000000000000E+00  -1.29270090537899E-10
      2.55247529602763E-18  -7.92753688802807E-02  -6.52909702197504E-02   0.00000000000000E+00   4.53874045603272E-13
     -6.67289474172884E-23  -4.43862015510454E-08  -4.43857476769999E-08  -1.97226907162792E-18
      6.78231424687081E-07
      0.00000000000000E+00  -3.22713016231343E-11   0.00000000000000E+00  -3.02782302533528E-13   3.43797552368647E-23
      3.22715665726411E-08   3.22712637903386E-08  -5.51126324415948E-19  -3.73144464834445E-01  -3.73144464834339E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05903121033273E-10   0.00000000000000E+00  -1.05903121033273E-10
      2.34066905396109E-18  -3.65095507961822E-02  -2.63753262941018E-02   0.00000000000000E+00   4.98430862241538E-13
     -3.13589322593326E-23  -3.21658591001676E-08  -3.21653606693054E-08  -1.78954272954514E-18
      6.80231424687081E-07
      0.00000000000000E+00  -2.01764518697495E-11   0.00000000000000E+00  -2.98532471469759E-13   1.42532157782738E-23
      2.01766996759964E-08   2.01764011435250E-08  -5.17861432070171E-19  -3.87056839068917E-01  -3.87056839068844E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.32094723810853E-11   0.00000000000000E+00  -7.32094723810853E-11
      2.19425010919892E-18  -1.81193509034473E-02  -1.17854984697040E-02   0.00000000000000E+00   3.83152466473747E-13
     -1.41123533513067E-23  -2.01035748236104E-08  -2.01031916711439E-08  -1.67638867712875E-18
      6.82231424687081E-07
      0.00000000000000E+00  -1.44157662626190E-11   0.00000000000000E+00  -1.41845364831377E-13   7.71928366949550E-24
      1.44158887939578E-08   1.44157469485930E-08  -4.83942240911643E-19  -4.00719435054969E-01  -4.00719435054911E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.81916392631177E-11   0.00000000000000E+00  -5.81916392631177E-11
      2.07786683067268E-18  -1.12931085819836E-02  -6.76951157729253E-03   0.00000000000000E+00   1.89962705206115E-13
     -8.28935066145641E-24  -1.43577452720351E-08  -1.43575553093299E-08  -1.59392458976104E-18
      6.84231424687081E-07
      0.00000000000000E+00  -1.22878155462578E-11   0.00000000000000E+00  -4.65301113046394E-14   5.36716907007301E-24
      1.22878508295050E-08   1.22878042993937E-08  -4.50518699756029E-19  -4.14116764913152E-01  -4.14116764913098E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.35715679977837E-11   0.00000000000000E+00  -5.35715679977837E-11
      1.97072369467711E-18  -8.73215553765759E-03  -4.87754692949075E-03   0.00000000000000E+00   8.18827445831460E-14
     -6.02354099716421E-24  -1.22343146141405E-08  -1.22342327313959E-08  -1.52020499492108E-18
      6.86231424687081E-07
      0.00000000000000E+00  -1.15649974644346E-11   0.00000000000000E+00  -1.75444408432420E-14   4.29328772794465E-24
      1.15650400014014E-08   1.15650224569605E-08  -4.17851628843099E-19  -4.27246644326760E-01  -4.27246644326707E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.27078637680726E-11   0.00000000000000E+00  -5.27078637680726E-11
      1.86530796714097E-18  -7.61933394014673E-03  -3.99217403758919E-03   0.00000000000000E+00   4.75437079713135E-14
     -4.92031362702714E-24  -1.15123621369004E-08  -1.15123145931924E-08  -1.44745633829787E-18
      6.88231424687081E-07
      0.00000000000000E+00  -1.13121489029022E-11   0.00000000000000E+00  -5.97846536544482E-15   3.66584954764147E-24
      1.13121330874888E-08   1.13121271090235E-08  -3.86042431988300E-19  -4.40111973495993E-01  -4.40111973495940E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.30159491807105E-11   0.00000000000000E+00  -5.30159491807105E-11
      1.75927606877955E-18  -7.01404701985996E-03  -3.46666129917642E-03   0.00000000000000E+00   3.25694778254420E-14
     -4.23275699882046E-24  -1.12591437293206E-08  -1.12591111598427E-08  -1.37323363679125E-18
      6.90231424687081E-07
      0.00000000000000E+00  -1.12093746419670E-11   0.00000000000000E+00  -2.29709605307224E-15   3.23740291693556E-24
      1.12093652079950E-08   1.12093629108989E-08  -3.55158450871245E-19  -4.52717240056789E-01  -4.52717240056735E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.36339514134642E-11   0.00000000000000E+00  -5.36339514134642E-11
      1.65200816595262E-18  -6.61620840946122E-03  -3.10139328630776E-03   0.00000000000000E+00   2.63050121868438E-14
     -3.73448304766952E-24  -1.11557552644976E-08  -1.11557289594855E-08  -1.29684971508138E-18
      6.92231424687081E-07
      0.00000000000000E+00  -1.11571149864959E-11   0.00000000000000E+00  -1.06940518481717E-15   2.91996794931932E-24
      1.11571397663529E-08   1.11571386969477E-08  -3.25243559143476E-19  -4.65067302067948E-01  -4.65067302067894E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.42797340762039E-11   0.00000000000000E+00  -5.42797340762039E-11
      1.54344869780021E-18  -6.32487310642724E-03  -2.82671400666680E-03   0.00000000000000E+00   2.29360048711062E-14
     -3.34689084036028E-24  -1.11028818988764E-08  -1.11028589628715E-08  -1.21820513865674E-18
      6.94231424687081E-07
      0.00000000000000E+00  -1.11249693284733E-11   0.00000000000000E+00  -5.91517378639462E-16   2.67418922812089E-24
      1.11249756084537E-08   1.11249750169364E-08  -2.96319075165739E-19  -4.77166900594687E-01  -4.77166900594632E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.48547400224550E-11   0.00000000000000E+00  -5.48547400224550E-11
      1.43373921775530E-18  -6.09987283163180E-03  -2.61202718386755E-03   0.00000000000000E+00   2.06264798939514E-14
     -3.03581127287958E-24  -1.10701409033938E-08  -1.10701202769139E-08  -1.13742014258956E-18
      6.96231424687081E-07
      0.00000000000000E+00  -1.11027429020691E-11   0.00000000000000E+00  -3.60246508385949E-16   2.47840680495687E-24
      1.11027868312274E-08   1.11027864709809E-08  -2.68387658602780E-19  -4.89020215378554E-01  -4.89020215378499E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.53195227360803E-11   0.00000000000000E+00  -5.53195227360803E-11
      1.32310017228314E-18  -5.92106143545021E-03  -2.44035180509694E-03   0.00000000000000E+00   1.88081975861225E-14
     -2.78176177172797E-24  -1.10474857564424E-08  -1.10474669482448E-08  -1.05471251368036E-18
      6.98231424687081E-07
      0.00000000000000E+00  -1.10865782283206E-11   0.00000000000000E+00  -2.26700530579695E-16   2.31907475844913E-24
      1.10865470644930E-08   1.10865468377924E-08  -2.41440124166569E-19  -5.00629757575895E-01  -5.00629757575839E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.56523753972551E-11   0.00000000000000E+00  -5.56523753972551E-11
      1.21179542148863E-18  -5.77623971690635E-03  -2.30075034474296E-03   0.00000000000000E+00   1.72877226009150E-14
     -2.57160841567331E-24  -1.10309117501178E-08  -1.10308944623952E-08  -9.70355297322063E-19
      7.00231424687081E-07
      0.00000000000000E+00  -1.10741791887975E-11   0.00000000000000E+00  -1.42488902511480E-16   2.18715016560972E-24
      1.10742017307252E-08   1.10742015882363E-08  -2.15469113597703E-19  -5.11992116794278E-01  -5.11992116794222E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58205929518260E-11   0.00000000000000E+00  -5.58205929518260E-11
      1.10015423558498E-18  -5.65721111863363E-03  -2.18566322633136E-03   0.00000000000000E+00   1.59763263733018E-14
     -2.39588704972748E-24  -1.10183969716109E-08  -1.10183809952845E-08  -8.84685121987276E-19
      7.02231424687081E-07
      0.00000000000000E+00  -1.10643518019163E-11   0.00000000000000E+00  -9.09629437614317E-17   2.07647432725532E-24
      1.10643721258172E-08   1.10643720348542E-08  -1.90511102817563E-19  -5.23080357116197E-01  -5.23080357116142E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.57052181349932E-11   0.00000000000000E+00  -5.57052181349932E-11
      9.88743799314993E-19  -5.55827171328498E-03  -2.08978344126592E-03   0.00000000000000E+00   1.47996163208365E-14
     -2.24779341559915E-24  -1.10086816163356E-08  -1.10086668167192E-08  -7.98232696497430E-19
      7.04231424687081E-07
      0.00000000000000E+00  -1.10558102413560E-11   0.00000000000000E+00  -7.12675323846085E-17   1.98299981319268E-24
      1.10558007297180E-08   1.10558006584505E-08  -1.66732843338459E-19  -5.33804350058327E-01  -5.33804350058273E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.49746436651897E-11   0.00000000000000E+00  -5.49746436651897E-11
      8.78794511984613E-19  -5.47554360908118E-03  -2.00952489772508E-03   0.00000000000000E+00   1.36563798526833E-14
     -2.12277083564209E-24  -1.10008396711652E-08  -1.10008260147853E-08  -7.12061668646154E-19
      7.06231424687081E-07
      0.00000000000000E+00  -1.10474523702701E-11   0.00000000000000E+00  -7.78881339600321E-17   1.90415094620570E-24
      1.10474410702681E-08   1.10474409923800E-08  -1.44442016357330E-19  -5.44002682663912E-01  -5.44002682663859E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.32306246803274E-11   0.00000000000000E+00  -5.32306246803274E-11
      7.72333262623958E-19  -5.40642039219155E-03  -1.94248545038677E-03   0.00000000000000E+00   1.24545945773993E-14
     -2.01777029702115E-24  -1.09942228222942E-08  -1.09942103676996E-08  -6.27891246266627E-19
      7.08231424687081E-07
      0.00000000000000E+00  -1.10385434307610E-11   0.00000000000000E+00  -1.05363860019983E-16   1.83828062868416E-24
      1.10385102408581E-08   1.10385101354942E-08  -1.24060207733359E-19  -5.53452368298405E-01  -5.53452368298355E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.01072141169751E-11   0.00000000000000E+00  -5.01072141169751E-11
      6.72118834390008E-19  -5.34912973980300E-03  -1.88702394399539E-03   0.00000000000000E+00   1.11254461717602E-14
     -1.93071477442815E-24  -1.09884140468234E-08  -1.09884029213772E-08  -5.48058626656649E-19
      7.10231424687082E-07
      0.00000000000000E+00  -1.10281649754566E-11   0.00000000000000E+00  -1.54899658697830E-16   1.78448079215875E-24
      1.10282037571138E-08   1.10282036022141E-08  -1.06164020792757E-19  -5.61848558075479E-01  -5.61848558075434E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.51225269077582E-11   0.00000000000000E+00  -4.51225269077582E-11
      5.81873780574491E-19  -5.30258450977694E-03  -1.84215493131198E-03   0.00000000000000E+00   9.58841812808313E-15
     -1.86048186104791E-24  -1.09830906637245E-08  -1.09830810753064E-08  -4.75709759781734E-19
      7.12231424687082E-07
      0.00000000000000E+00  -1.10155822464591E-11   0.00000000000000E+00  -2.31648535350356E-16   1.74257213989923E-24
      1.10155731785371E-08   1.10155729468886E-08  -9.15420464600915E-20  -5.68777293068396E-01  -5.68777293068358E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.76439978459830E-11   0.00000000000000E+00  -3.76439978459830E-11
      5.06585784882525E-19  -5.26636192254184E-03  -1.80755518947139E-03   0.00000000000000E+00   7.73410238960699E-15
     -1.80696200792123E-24  -1.09779366831450E-08  -1.09779289490426E-08  -4.15043738422434E-19
      7.14231424687082E-07
      0.00000000000000E+00  -1.09996012621850E-11   0.00000000000000E+00  -3.37433267287001E-16   1.71309523668099E-24
      1.09995833992084E-08   1.09995830617752E-08  -8.12085214402700E-20  -5.73710862892604E-01  -5.73710862892577E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.70226518598098E-11   0.00000000000000E+00  -2.70226518598098E-11
      4.52540481162906E-19  -5.24067539315485E-03  -1.78355982500516E-03   0.00000000000000E+00   5.44603166784713E-15
     -1.77105902024898E-24  -1.09725658559470E-08  -1.09725604099154E-08  -3.71331959722635E-19
      7.16231424687082E-07
      0.00000000000000E+00  -1.09793035752622E-11   0.00000000000000E+00  -4.67014190444092E-16   1.69736887252783E-24
      1.09793390807604E-08   1.09793386137462E-08  -7.63775123328814E-20  -5.76027230868918E-01  -5.76027230868905E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.27536459290023E-11   0.00000000000000E+00  -1.27536459290023E-11
      4.27033189304901E-19  -5.22646745346013E-03  -1.77123442511315E-03   0.00000000000000E+00   2.60961595531698E-15
     -1.75482609703087E-24  -1.09665875774332E-08  -1.09665849678172E-08  -3.50655676972021E-19
      7.18231424687082E-07
      0.00000000000000E+00  -1.09541381172673E-11   0.00000000000000E+00  -6.32776082050288E-16   1.69769196260193E-24
      1.09541223032117E-08   1.09541216704356E-08  -7.84275839188053E-20  -5.75041582568037E-01  -5.75041582568042E-01
      0.00000000000000E+00   0.00000000000000E+00   5.41502785348186E-12   0.00000000000000E+00   5.41502785348186E-12
      4.37863245011865E-19  -5.22559279887444E-03  -1.77258051388994E-03   0.00000000000000E+00  -8.70263428834482E-16
     -1.76189529602353E-24  -1.09595358280257E-08  -1.09595366982891E-08  -3.59435661093060E-19
      7.20231424687082E-07
      0.00000000000000E+00  -1.09232782855656E-11   0.00000000000000E+00  -8.18060102367869E-16   1.71787124345219E-24
      1.09232363583761E-08   1.09232355403160E-08  -8.88950783788613E-20  -5.70033263783319E-01  -5.70033263783347E-01
      0.00000000000000E+00   0.00000000000000E+00   2.74555685818024E-11   0.00000000000000E+00   2.74555685818024E-11
      4.92774382175470E-19  -5.24129728830430E-03  -1.79107226789193E-03   0.00000000000000E+00  -5.14881183178389E-15
     -1.79854442644315E-24  -1.09506859600860E-08  -1.09506911088978E-08  -4.03879303796609E-19
      7.22231424687082E-07
      0.00000000000000E+00  -1.08856219433105E-11   0.00000000000000E+00  -1.55882965081277E-15   1.76437685006314E-24
      1.08856428264083E-08   1.08856412675786E-08  -1.09523417592732E-19  -5.60257516562884E-01  -5.60257516562937E-01
      0.00000000000000E+00   0.00000000000000E+00   5.30713211006405E-11   0.00000000000000E+00   5.30713211006405E-11
      5.98917024376751E-19  -5.27937713209050E-03  -1.83292661062466E-03   0.00000000000000E+00  -9.91606049773409E-15
     -1.87611496146449E-24  -1.09387026726188E-08  -1.09387125886793E-08  -4.89393606784019E-19
      7.24231424687082E-07
      0.00000000000000E+00  -1.08391485062835E-11   0.00000000000000E+00  -1.33128181300733E-15   1.84875398501944E-24
      1.08392253920905E-08   1.08392240608087E-08  -1.42371843492184E-19  -5.44945874730772E-01  -5.44945874730853E-01
      0.00000000000000E+00   0.00000000000000E+00   8.16369197841418E-11   0.00000000000000E+00   8.16369197841418E-11
      7.62190863945035E-19  -5.35087499017470E-03  -1.91005007438041E-03   0.00000000000000E+00  -1.70993015807638E-14
     -2.01665192810735E-24  -1.09208438812913E-08  -1.09208609805929E-08  -6.19819020452850E-19
      7.26231424687082E-07
      0.00000000000000E+00  -1.07790820481498E-11   0.00000000000000E+00  -3.90843842556409E-14   1.99276918339577E-24
      1.07790127448869E-08   1.07789736605027E-08  -1.89963438233866E-19  -5.23310611564751E-01  -5.23310611564863E-01
      0.00000000000000E+00   0.00000000000000E+00   1.11961859781338E-10   0.00000000000000E+00   1.11961859781338E-10
      9.86114583507710E-19  -5.47865889846420E-03  -2.04725226337870E-03   0.00000000000000E+00   1.15101020040300E-14
     -2.26761516236549E-24  -1.08909470303860E-08  -1.08909355202840E-08  -7.96151145273844E-19
      7.28231424687082E-07
      0.00000000000000E+00  -1.06917377030654E-11   0.00000000000000E+00  -2.93365507188312E-15   2.23958903146784E-24
      1.06917504612025E-08   1.06917475275474E-08  -2.55405293117373E-19  -4.94571060137727E-01  -4.94571060137869E-01
      0.00000000000000E+00   0.00000000000000E+00   1.41844780426340E-10   0.00000000000000E+00   1.41844780426340E-10
      1.26980414436039E-18  -5.71534897969703E-03  -2.30202375276591E-03   0.00000000000000E+00  -3.73719639655476E-14
     -2.74725409802521E-24  -1.08335549360098E-08  -1.08335923079738E-08  -1.01439885124302E-18
      7.30231424687082E-07
      0.00000000000000E+00  -1.05363364077103E-11   0.00000000000000E+00  -4.43631014905983E-15   2.67432676441432E-24
      1.05363670666427E-08   1.05363626303325E-08  -3.42226151732395E-19  -4.58009785856046E-01  -4.58009785856213E-01
      0.00000000000000E+00   0.00000000000000E+00   1.67650974390145E-10   0.00000000000000E+00   1.67650974390145E-10
      1.60510609314068E-18  -6.19988395734249E-03  -2.82738915263651E-03   0.00000000000000E+00  -5.50493034432755E-14
     -3.81713829637042E-24  -1.07039585554192E-08  -1.07040136047227E-08  -1.26287994140829E-18
      7.32231424687082E-07
      0.00000000000000E+00  -1.01650081351802E-11   0.00000000000000E+00  -1.00285083282854E-13   3.40568975080276E-24
      1.01650733979197E-08   1.01649731128364E-08  -4.53063328144619E-19  -4.13041478593598E-01  -4.13041478593783E-01
      0.00000000000000E+00   0.00000000000000E+00   1.85152404689171E-10   0.00000000000000E+00   1.85152404689171E-10
      1.97541090251902E-18  -7.36549448900609E-03  -4.10447657005351E-03   0.00000000000000E+00   8.95735677611655E-15
     -6.87946783718232E-24  -1.03501344748824E-08  -1.03501255175256E-08  -1.52234757437440E-18
      7.34231424687082E-07
      0.00000000000000E+00  -9.02108193326049E-12   0.00000000000000E+00  -2.95892540682425E-14   3.88159255464296E-24
      9.02107516827808E-09   9.02104557902401E-09  -5.85394910955056E-19  -3.59298782091153E-01  -3.59298782091349E-01
      0.00000000000000E+00   0.00000000000000E+00   1.95545729704722E-10   0.00000000000000E+00   1.95545729704722E-10
      2.36650236192847E-18  -1.07224242209383E-02  -7.81858419466348E-03   0.00000000000000E+00  -1.19470765312848E-13
     -1.78824916407155E-23  -9.21647183796340E-09  -9.21659130872874E-09  -1.78110745097341E-18
      7.36231424687082E-07
      0.00000000000000E+00  -5.89634028398601E-12   0.00000000000000E+00  -7.90913793953896E-14  -1.58902335800508E-24
      5.89640218729747E-09   5.89632309591808E-09  -7.27253253463226E-19  -2.96957296076537E-01  -2.96957296076752E-01
      0.00000000000000E+00   0.00000000000000E+00   2.15197476490625E-10   0.00000000000000E+00   2.15197476490625E-10
      2.79689731490972E-18  -2.00789383957619E-02  -1.81534126835752E-02   0.00000000000000E+00  -1.74174742488024E-13
     -4.87536430388220E-23  -6.11134639766616E-09  -6.11152057240870E-09  -2.06964406144649E-18
      7.38231424687082E-07
      0.00000000000000E+00  -2.10719380575229E-12   0.00000000000000E+00  -9.62513173905091E-14  -2.04904438316817E-23
      2.10733167664593E-09   2.10723542532852E-09  -8.70493114609874E-19  -2.27620131300718E-01  -2.27620131300958E-01
      0.00000000000000E+00   0.00000000000000E+00   2.40245087033082E-10   0.00000000000000E+00   2.40245087033082E-10
      3.27738748897588E-18  -3.66022732847597E-02  -3.58626701336520E-02   0.00000000000000E+00  -3.07416496219400E-13
     -7.83384022870011E-23  -2.34717309586530E-09  -2.34748051236160E-09  -2.40689437436601E-18
      7.40231424687082E-07
      0.00000000000000E+00  -4.20648896410473E-13   0.00000000000000E+00  -4.53434827777154E-14  -3.74691361041883E-23
      4.20704152323568E-10   4.20658808840753E-10  -1.01732303806745E-18  -1.54767632734985E-01  -1.54767632735228E-01
      0.00000000000000E+00   0.00000000000000E+00   2.42846823762124E-10   0.00000000000000E+00   2.42846823762124E-10
      3.76308113650013E-18  -5.60851572529765E-02  -5.58761131353286E-02   0.00000000000000E+00  -5.39664255723814E-13
     -8.86276517326962E-23  -6.62965968347065E-10  -6.63505632602877E-10  -2.74575809843268E-18
      7.42231424687082E-07
      0.00000000000000E+00  -1.46033132159968E-14   0.00000000000000E+00  -1.45063891296630E-14  -4.41707112992970E-23
      1.46539153275556E-11   1.46394089383818E-11  -1.15821312779041E-18  -8.54761474122750E-02  -8.54761474124931E-02
      0.00000000000000E+00   0.00000000000000E+00   2.18093060274669E-10   0.00000000000000E+00   2.18093060274669E-10
      4.19926725704947E-18  -7.60204436304042E-02  -7.59471191236064E-02   0.00000000000000E+00  -7.62172911780787E-13
     -9.57099430492581E-23  -2.31970296301174E-10  -2.32732469213050E-10  -3.04105412925906E-18
      7.44231424687082E-07
      0.00000000000000E+00   2.68186632645978E-14   0.00000000000000E+00  -4.32253723780901E-15  -4.57559984316803E-23
     -2.67698951272084E-11  -2.67742176644920E-11  -1.25246746766308E-18  -3.95912033999504E-02  -3.95912034001053E-02
      0.00000000000000E+00   0.00000000000000E+00   1.54962603076039E-10   0.00000000000000E+00   1.54962603076039E-10
      4.50919246320155E-18  -9.57614021704365E-02  -9.57210153202287E-02   0.00000000000000E+00  -7.01418461964705E-13
     -1.01353257224296E-22  -1.27486966949481E-10  -1.28188385411547E-10  -3.25672499553847E-18
      7.46231424687082E-07
      0.00000000000000E+00   7.25573423939461E-15   0.00000000000000E+00  -6.79442855791954E-16  -4.60105470110806E-23
     -7.21322696315150E-12  -7.21390640605331E-12  -1.29640469049603E-18  -1.93103581181098E-02  -1.93103581182037E-02
      0.00000000000000E+00   0.00000000000000E+00   9.39890776567927E-11   0.00000000000000E+00   9.39890776567927E-11
      4.69717061851513E-18  -1.15187159716094E-01  -1.15159820660638E-01   0.00000000000000E+00  -4.55578832094679E-13
     -1.04498832926632E-22  -8.63195924185407E-11  -8.67751712507399E-11  -3.40076592801910E-18
      7.48231424687082E-07
      0.00000000000000E+00  -1.04703000416580E-14   0.00000000000000E+00   3.49290925878881E-16  -4.56498054928859E-23
      1.04717923137646E-11   1.04721416046448E-11  -1.31402826390266E-18  -1.17277699638695E-02  -1.17277699639293E-02
      0.00000000000000E+00   0.00000000000000E+00   5.97573934644672E-11   0.00000000000000E+00   5.97573934644672E-11
      4.81668540544406E-18  -1.34253529420243E-01  -1.34231403350144E-01   0.00000000000000E+00  -3.16803195323415E-13
     -1.06504012754197E-22  -6.99127318736811E-11  -7.02295350691110E-11  -3.50265714154140E-18
      7.50231424687082E-07
      0.00000000000000E+00  -2.25019606158441E-14   0.00000000000000E+00   4.94747923149561E-16  -4.46125566337543E-23
      2.24835554845176E-11   2.24840502323961E-11  -1.32036484142075E-18  -8.90479304997257E-03  -8.90479305001489E-03
      0.00000000000000E+00   0.00000000000000E+00   4.23240993057100E-11   0.00000000000000E+00   4.23240993057100E-11
      4.90133360405549E-18  -1.52944368236302E-01  -1.52923950320953E-01   0.00000000000000E+00  -2.74924829816381E-13
     -1.08156932502656E-22  -6.45332247081827E-11  -6.48081495381073E-11  -3.58096876263474E-18
      7.52231424687082E-07
      0.00000000000000E+00  -3.10435211761440E-14   0.00000000000000E+00   4.35094446106193E-16  -4.25768838881192E-23
      3.10356514726297E-11   3.10360865670332E-11  -1.32201089725382E-18  -7.70318190029020E-03  -7.70318190032302E-03
      0.00000000000000E+00   0.00000000000000E+00   3.28239362454672E-11   0.00000000000000E+00   3.28239362454672E-11
      4.96698147654642E-18  -1.71257728277179E-01  -1.71237609181053E-01   0.00000000000000E+00  -2.71729018761207E-13
     -1.09728542972199E-22  -6.35882937936289E-11  -6.38600228124998E-11  -3.64497057929260E-18
      7.54231424687083E-07
      0.00000000000000E+00  -3.76563422550860E-14   0.00000000000000E+00   3.40903390694171E-16  -3.91317893984350E-23
      3.76138960780079E-11   3.76142369813595E-11  -1.32166932242768E-18  -7.06476838875133E-03  -7.06476838877840E-03
      0.00000000000000E+00   0.00000000000000E+00   2.70725830041625E-11   0.00000000000000E+00   2.70725830041625E-11
      5.02112664255474E-18  -1.89197974894968E-01  -1.89177595420111E-01   0.00000000000000E+00  -2.78748297749762E-13
     -1.11288156535272E-22  -6.44080716876609E-11  -6.46868199855219E-11  -3.69945732012706E-18
      7.56231424687083E-07
      0.00000000000000E+00  -4.29833370131225E-14   0.00000000000000E+00   2.67641793949675E-16  -3.38511302273472E-23
      4.30238689405510E-11   4.30241365823111E-11  -1.32047635345092E-18  -6.65175272470493E-03  -6.65175272472822E-03
      0.00000000000000E+00   0.00000000000000E+00   2.32879709120990E-11   0.00000000000000E+00   2.32879709120990E-11
      5.06770258437894E-18  -2.06772011716534E-01  -2.06751120305162E-01   0.00000000000000E+00  -2.86467343501525E-13
     -1.12844897167028E-22  -6.60256401507956E-11  -6.63121074944100E-11  -3.74722623092802E-18
      7.58231424687083E-07
      0.00000000000000E+00  -4.77592633479139E-14   0.00000000000000E+00   2.18234876950386E-16  -2.63698273013140E-23
      4.77264354731838E-11   4.77266537080344E-11  -1.31893680168615E-18  -6.35172801586043E-03  -6.35172801588109E-03
      0.00000000000000E+00   0.00000000000000E+00   2.06639641939872E-11   0.00000000000000E+00   2.06639641939872E-11
      5.10903051276692E-18  -2.23987508112893E-01  -2.23965961987675E-01   0.00000000000000E+00  -2.92549106162558E-13
     -1.14394362754676E-22  -6.80980687957445E-11  -6.83906179020215E-11  -3.79009371108077E-18
      7.60231424687083E-07
      0.00000000000000E+00  -5.19841212594601E-14   0.00000000000000E+00   1.86565743019146E-16  -1.64986874125186E-23
      5.19992438284157E-11   5.19994303941422E-11  -1.31728375890159E-18  -6.12094412146930E-03  -6.12094412148808E-03
      0.00000000000000E+00   0.00000000000000E+00   1.87820654108125E-11   0.00000000000000E+00   1.87820654108125E-11
      5.14659464358854E-18  -2.40852009339369E-01  -2.40829710101107E-01   0.00000000000000E+00  -2.96873475032581E-13
     -1.15931307198247E-22  -7.04846223298065E-11  -7.07814958049550E-11  -3.82931088468695E-18
      7.62231424687083E-07
      0.00000000000000E+00  -5.60252896965913E-14   0.00000000000000E+00   1.66515771956752E-16  -4.35087030676279E-24
      5.60094346343911E-11   5.60096011501587E-11  -1.31562424640280E-18  -5.93797211086578E-03  -5.93797211088318E-03
      0.00000000000000E+00   0.00000000000000E+00   1.73941604291705E-11   0.00000000000000E+00   1.73941604291705E-11
      5.18138296444688E-18  -2.57372589419281E-01  -2.57349464182062E-01   0.00000000000000E+00  -2.99876865897849E-13
     -1.17452353168909E-22  -7.31038847133135E-11  -7.34037615793288E-11  -3.86575871804409E-18
      7.64231424687083E-07
      0.00000000000000E+00  -5.98827686593074E-14   0.00000000000000E+00   1.53695138810626E-16   9.40344905438211E-24
      5.98559614294027E-11   5.98561151245509E-11  -1.31400411283945E-18  -5.79003704106164E-03  -5.79003704107798E-03
      0.00000000000000E+00   0.00000000000000E+00   1.63404999615678E-11   0.00000000000000E+00   1.63404999615678E-11
      5.21406396437002E-18  -2.73556072283507E-01  -2.73532067316319E-01   0.00000000000000E+00  -3.02069293887069E-13
     -1.18956292645609E-22  -7.58945457921122E-11  -7.61966150861182E-11  -3.90005985153057E-18
      7.66231424687083E-07
      0.00000000000000E+00  -6.35565581476085E-14   0.00000000000000E+00   1.45343977124297E-16   2.35022099453267E-23
      6.35990173446020E-11   6.35991626886027E-11  -1.31243945463929E-18  -5.66861840249120E-03  -5.66861840250671E-03
      0.00000000000000E+00   0.00000000000000E+00   1.55143680755439E-11   0.00000000000000E+00   1.55143680755439E-11
      5.24509270052111E-18  -2.89409690990531E-01  -2.89384767219411E-01   0.00000000000000E+00  -3.03912878433049E-13
     -1.20443607001572E-22  -7.88096178855937E-11  -7.91135307641472E-11  -3.93265324588181E-18
      7.68231424687083E-07
      0.00000000000000E+00  -6.73221923731171E-14   0.00000000000000E+00   1.39803025940807E-16   3.72113265617689E-23
      6.72775257402741E-11   6.72776655433372E-11  -1.31093243780973E-18  -5.56779068379901E-03  -5.56779068381385E-03
      0.00000000000000E+00   0.00000000000000E+00   1.48426856391380E-11   0.00000000000000E+00   1.48426856391380E-11
      5.27477807179938E-18  -3.04940752467208E-01  -3.04914881578721E-01   0.00000000000000E+00  -3.05772307032589E-13
     -1.21916113639234E-22  -8.18145788753205E-11  -8.21203511824750E-11  -3.96384563398965E-18
      7.70231424687083E-07
      0.00000000000000E+00  -7.09041371242107E-14   0.00000000000000E+00   1.36047791224170E-16   4.99485985115512E-23
      7.09171715132947E-11   7.09173075611359E-11  -1.30947932422985E-18  -5.48351045941403E-03  -5.48351045942830E-03
      0.00000000000000E+00   0.00000000000000E+00   1.42722755294489E-11   0.00000000000000E+00   1.42722755294489E-11
      5.30332262285828E-18  -3.20153196972095E-01  -3.20126359314169E-01   0.00000000000000E+00  -3.07837911107722E-13
     -1.23376171716311E-22  -8.48817451793540E-11  -8.51895830905851E-11  -3.99384329862843E-18
      7.72231424687083E-07
      0.00000000000000E+00  -7.45779266125117E-14   0.00000000000000E+00   1.33389926703525E-16   6.13209034082614E-23
      7.45335054560486E-11   7.45336388460366E-11  -1.30807476055832E-18  -5.41306488095386E-03  -5.41306488096762E-03
      0.00000000000000E+00   0.00000000000000E+00   1.37631197826601E-11   0.00000000000000E+00   1.37631197826601E-11
      5.33084886242360E-18  -3.35044339817140E-01  -3.35016523446114E-01   0.00000000000000E+00  -3.10133153877569E-13
     -1.24825789947778E-22  -8.79866254746946E-11  -8.82967586286970E-11  -4.02277410186529E-18
      7.74231424687083E-07
      0.00000000000000E+00  -7.81598713636053E-14   0.00000000000000E+00   1.31423074881756E-16   7.11533220500091E-23
      7.81367893660432E-11   7.81369207891892E-11  -1.30671309219017E-18  -5.35460481642949E-03  -5.35460481644278E-03
      0.00000000000000E+00   0.00000000000000E+00   1.32949872311575E-11   0.00000000000000E+00   1.32949872311575E-11
      5.35743883688591E-18  -3.49615930798030E-01  -3.49587126911244E-01   0.00000000000000E+00  -3.12903100360142E-13
     -1.26267840911498E-22  -9.11190049198597E-11  -9.14319080203461E-11  -4.05072574469574E-18
      7.76231424687083E-07
      0.00000000000000E+00  -8.17418161146988E-14   0.00000000000000E+00   1.30199987485262E-16   7.94636942212943E-23
      8.17397697957100E-11   8.17398999957769E-11  -1.30538720744701E-18  -5.30697370900527E-03  -5.30697370901814E-03
      0.00000000000000E+00   0.00000000000000E+00   1.28736365865781E-11   0.00000000000000E+00   1.28736365865781E-11
      5.38318611005907E-18  -3.63897747840922E-01  -3.63867941806001E-01   0.00000000000000E+00  -3.17014438178350E-13
     -1.27708823882874E-22  -9.42965221440490E-11  -9.46135365823551E-11  -4.07779890261207E-18
      7.78231424687083E-07
      0.00000000000000E+00  -8.53237608657924E-14   0.00000000000000E+00   1.29846641212646E-16   8.64030674980880E-23
      8.53615150890470E-11   8.53616449357746E-11  -1.30408758270444E-18  -5.26968217318498E-03  -5.26968217319750E-03
      0.00000000000000E+00   0.00000000000000E+00   1.25169628404991E-11   0.00000000000000E+00   1.25169628404991E-11
      5.40822003574007E-18  -3.77956748940264E-01  -3.77925914480582E-01   0.00000000000000E+00  -3.23648856956470E-13
     -1.29159999315597E-22  -9.75549589191880E-11  -9.78786077762736E-11  -4.10413245303563E-18
      7.80231424687083E-07
      0.00000000000000E+00  -8.89975503540934E-14   0.00000000000000E+00   1.29661102441261E-16   9.21684128118948E-23
      8.90028148670506E-11   8.90029445282452E-11  -1.30280962264889E-18  -5.24287517357330E-03  -5.24287517358546E-03
      0.00000000000000E+00   0.00000000000000E+00   1.21618935894673E-11   0.00000000000000E+00   1.21618935894673E-11
      5.43254382291901E-18  -3.91786243727220E-01  -3.91754374190327E-01   0.00000000000000E+00  -3.30690742263757E-13
     -1.30622436099487E-22  -1.00834147375318E-10  -1.01164838117712E-10  -4.12973420027012E-18
      7.82231424687083E-07
      0.00000000000000E+00  -9.26713398423945E-14   0.00000000000000E+00   1.29444717072439E-16   9.69657325608030E-23
      9.26586300112037E-11   9.26587594560178E-11  -1.30155020412103E-18  -5.22741385798390E-03  -5.22741385799569E-03
      0.00000000000000E+00   0.00000000000000E+00   1.17853684497687E-11   0.00000000000000E+00   1.17853684497687E-11
      5.45611455981854E-18  -4.05358432659421E-01  -4.05325530246107E-01   0.00000000000000E+00  -3.37513340947913E-13
     -1.32094230492464E-22  -1.04106614564707E-10  -1.04444127905787E-10  -4.15456435569751E-18
      7.84231424687083E-07
      0.00000000000000E+00  -9.63451293306956E-14   0.00000000000000E+00   1.29447480108560E-16   1.00990384185729E-22
      9.63301824102729E-11   9.63303118578540E-11  -1.30030420765889E-18  -5.22504433709641E-03  -5.22504433710780E-03
      0.00000000000000E+00   0.00000000000000E+00   1.13959742682595E-11   0.00000000000000E+00   1.13959742682595E-11
      5.47890650835506E-18  -4.18663631992236E-01  -4.18629695813157E-01   0.00000000000000E+00  -3.44630003437023E-13
     -1.33575533923624E-22  -1.07381656122543E-10  -1.07726286126113E-10  -4.17860230069617E-18
      7.86231424687083E-07
      0.00000000000000E+00  -1.00018918818997E-13   0.00000000000000E+00   1.29946861602986E-16   1.04413471319571E-22
      1.00024808621191E-10   1.00024938568157E-10  -1.29906349972239E-18  -5.23883175627398E-03  -5.23883175628498E-03
      0.00000000000000E+00   0.00000000000000E+00   1.09978873362683E-11   0.00000000000000E+00   1.09978873362683E-11
      5.50090228302760E-18  -4.31702055265079E-01  -4.31667080804372E-01   0.00000000000000E+00  -3.52226335010355E-13
     -1.35066993185719E-22  -1.10670599569280E-10  -1.11022825904426E-10  -4.20183878330521E-18
      7.88231424687083E-07
      0.00000000000000E+00  -1.03784553044505E-13   0.00000000000000E+00   1.31388641332436E-16   1.07380356556225E-22
      1.03759545449689E-10   1.03759676838437E-10  -1.29781468300260E-18  -5.27422311477236E-03  -5.27422311478295E-03
      0.00000000000000E+00   0.00000000000000E+00   1.05896845460096E-11   0.00000000000000E+00   1.05896845460096E-11
      5.52208165211962E-18  -4.44477380640942E-01  -4.44441358464741E-01   0.00000000000000E+00  -3.60216408566756E-13
     -1.36568526708810E-22  -1.13989144975743E-10  -1.14349361384446E-10  -4.22426696911701E-18
      7.90231424687083E-07
      0.00000000000000E+00  -1.07550187270014E-13   0.00000000000000E+00   1.34698894641225E-16   1.10019158670183E-22
      1.07571296692119E-10   1.07571431391123E-10  -1.29653360627355E-18  -5.34151617117063E-03  -5.34151617118079E-03
      0.00000000000000E+00   0.00000000000000E+00   1.01640974793604E-11   0.00000000000000E+00   1.01640974793604E-11
      5.54240984707834E-18  -4.56994303615729E-01  -4.56957214955195E-01   0.00000000000000E+00  -3.68320030823167E-13
     -1.38078548214479E-22  -1.17367208839523E-10  -1.17735528870484E-10  -4.24587624080479E-18
      7.92231424687083E-07
      0.00000000000000E+00  -1.11499510969937E-13   0.00000000000000E+00   1.41963559304940E-16   1.12461277139358E-22
      1.11542251799256E-10   1.11542393762928E-10  -1.29517205867499E-18  -5.46183874993022E-03  -5.46183874993992E-03
      0.00000000000000E+00   0.00000000000000E+00   9.70245859896716E-12   0.00000000000000E+00   9.70245859896716E-12
      5.56181476427627E-18  -4.69257683881734E-01  -4.69219489958305E-01   0.00000000000000E+00  -3.75968893404674E-13
     -1.39592927492355E-22  -1.20868883468351E-10  -1.21244852361895E-10  -4.26664270560129E-18
      7.94231424687083E-07
      0.00000000000000E+00  -1.15816213618691E-13   0.00000000000000E+00   1.59421803635960E-16   1.14890506342992E-22
      1.15869863072046E-10   1.15870022493964E-10  -1.29362226743430E-18  -5.68319756885638E-03  -5.68319756886553E-03
      0.00000000000000E+00   0.00000000000000E+00   9.15632425222833E-12   0.00000000000000E+00   9.15632425222833E-12
      5.58012741278073E-18  -4.81272132001138E-01  -4.81232747096976E-01   0.00000000000000E+00  -3.81900905044119E-13
     -1.41102523169475E-22  -1.24644445841008E-10  -1.25026346746193E-10  -4.28650514534643E-18
      7.96231424687083E-07
      0.00000000000000E+00  -1.21051363639520E-13   0.00000000000000E+00   2.00064864858771E-16   1.17690043466635E-22
      1.21092677186690E-10   1.21092877251673E-10  -1.29160691426551E-18  -6.13044725550302E-03  -6.13044725551140E-03
      0.00000000000000E+00   0.00000000000000E+00   8.38496192795435E-12   0.00000000000000E+00   8.38496192795435E-12
      5.59689733663664E-18  -4.93041447520424E-01  -4.93000660601271E-01   0.00000000000000E+00  -3.82704091137912E-13
     -1.42585560651728E-22  -1.29095135088347E-10  -1.29477839179627E-10  -4.30529042237113E-18
      7.98231424687083E-07
      0.00000000000000E+00  -1.28950011039368E-13   0.00000000000000E+00   3.30185014756654E-16   1.21982823912887E-22
      1.28954808770907E-10   1.28955138956044E-10  -1.28828184320392E-18  -7.18606366075880E-03  -7.18606366076571E-03
      0.00000000000000E+00   0.00000000000000E+00   6.91439840039359E-12   0.00000000000000E+00   6.91439840039359E-12
      5.61072613343742E-18  -5.04566907034329E-01  -5.04524106954688E-01   0.00000000000000E+00  -3.67243216844694E-13
     -1.43979884280220E-22  -1.35502294139449E-10  -1.35869537356437E-10  -4.32244429023350E-18
      8.00231424687084E-07
      0.00000000000000E+00  -1.46124976897175E-13   0.00000000000000E+00   7.19318135641483E-16   1.31784374843075E-22
      1.46128064402090E-10   1.46128783720358E-10  -1.28070499534154E-18  -1.01811177588431E-02  -1.01811177588461E-02
      0.00000000000000E+00   0.00000000000000E+00   2.98717785377558E-12   0.00000000000000E+00   2.98717785377558E-12
      5.61670048914498E-18  -5.15840222179312E-01  -5.15793249708418E-01   0.00000000000000E+00  -2.94296520100892E-13
     -1.45076566542424E-22  -1.48821665053887E-10  -1.49115961574133E-10  -4.33599549380343E-18
      8.02231424687084E-07
      0.00000000000000E+00  -1.95629290252032E-13   0.00000000000000E+00   1.99108287734304E-15   1.58386020084737E-22
      1.95633733877779E-10   1.95635724960815E-10  -1.26065589958847E-18  -1.87336983690698E-02  -1.87336983690620E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.83979639644717E-12   0.00000000000000E+00  -7.83979639644717E-12
      5.60102089635208E-18  -5.26817197863502E-01  -5.26758041394417E-01   0.00000000000000E+00  -6.58803978312981E-14
     -1.45318016432798E-22  -1.87730048166390E-10  -1.87795928564367E-10  -4.34036499676360E-18
      8.04231424687084E-07
      0.00000000000000E+00  -3.13190553877666E-13   0.00000000000000E+00   4.20766207633480E-15   2.04631738876384E-22
      3.13153490634916E-10   3.13157698297197E-10  -1.22273899531627E-18  -3.46975270632727E-02  -3.46975270632493E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.34725073031326E-11   0.00000000000000E+00  -2.34725073031326E-11
      5.55407588174582E-18  -5.37381194139436E-01  -5.37289942223125E-01   0.00000000000000E+00   2.32786557269953E-13
     -1.44449252201870E-22  -2.89917977551190E-10  -2.89685190994065E-10  -4.33133688642954E-18
      8.06231424687084E-07
      0.00000000000000E+00  -5.23331312608487E-13   0.00000000000000E+00   6.58937623317674E-15   2.47552392655634E-22
      5.23312854948462E-10   5.23319444324943E-10  -1.17494869063018E-18  -5.40388723090700E-02  -5.40388723090365E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.35003271046815E-11   0.00000000000000E+00  -3.35003271046815E-11
      5.48707522753645E-18  -5.47349900690584E-01  -5.47195604929375E-01   0.00000000000000E+00   3.44384237584063E-13
     -1.43138944202285E-22  -4.90163501457703E-10  -4.89819117220262E-10  -4.31212653690627E-18
      8.08231424687084E-07
      0.00000000000000E+00  -8.62789461327506E-13   0.00000000000000E+00   9.65992399134333E-15   2.76889983662050E-22
      8.62779145908784E-10   8.62788805833053E-10  -1.12484945560083E-18  -7.39753812306076E-02  -7.39753812305687E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.89640302970927E-11   0.00000000000000E+00  -3.89640302970927E-11
      5.40914716694227E-18  -5.56475489928213E-01  -5.56215978744693E-01   0.00000000000000E+00   3.38945601652882E-13
     -1.41818000506500E-22  -8.24163721137471E-10  -8.23824775535960E-10  -4.28429771134143E-18
      8.10231424687084E-07
      0.00000000000000E+00  -1.38511048182671E-12   0.00000000000000E+00   1.40443325084135E-14   2.97576674767546E-22
      1.38510231805760E-09   1.38511636239041E-09  -1.07610768692572E-18  -9.37444055183222E-02  -9.37444055182790E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.32666005108401E-11   0.00000000000000E+00  -4.32666005108401E-11
      5.32261396592059E-18  -5.64417724665936E-01  -5.63995029026097E-01   0.00000000000000E+00   3.09673741219361E-13
     -1.40579995973081E-22  -1.34215943562065E-09  -1.34184976187957E-09  -4.24650627899487E-18
      8.12231424687084E-07
      0.00000000000000E+00  -2.15403462172812E-12   0.00000000000000E+00   2.00065145621944E-14   3.14571896133744E-22
      2.15397033309438E-09   2.15399033960925E-09  -1.03033141531547E-18  -1.13205243716010E-01  -1.13205243715962E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.79491204581082E-11   0.00000000000000E+00  -4.79491204581082E-11
      5.22671572500437E-18  -5.70722471564928E-01  -5.70059044638661E-01   0.00000000000000E+00   2.83151823800725E-13
     -1.39416361539973E-22  -2.10632437097481E-09  -2.10604121915115E-09  -4.19638430968890E-18
      8.14231424687084E-07
      0.00000000000000E+00  -3.23073047601196E-12   0.00000000000000E+00   2.75004876108587E-14   3.29410415884912E-22
      3.23071002561068E-09   3.23073752609862E-09  -9.88103204974469E-19  -1.32309660402091E-01  -1.32309660402037E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.34391268715874E-11   0.00000000000000E+00  -5.34391268715874E-11
      5.11983747126120E-18  -5.74826298723099E-01  -5.73825408614241E-01   0.00000000000000E+00   2.65294784117064E-13
     -1.38293098182953E-22  -3.17756369401101E-09  -3.17729839922704E-09  -4.13173426628673E-18
      8.16231424687084E-07
      0.00000000000000E+00  -4.66415128960983E-12   0.00000000000000E+00   3.62070654926367E-14   3.41946433649660E-22
      4.66413555285743E-09   4.66417175992326E-09  -9.49326448184986E-19  -1.51039372295476E-01  -1.51039372295417E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.96614672317550E-11   0.00000000000000E+00  -5.96614672317550E-11
      5.00051453679768E-18  -5.76081795996691E-01  -5.74631308541941E-01   0.00000000000000E+00   2.63116284422246E-13
     -1.37145437502733E-22  -4.60477340897579E-09  -4.60451029269151E-09  -4.05118808861270E-18
      8.18231424687084E-07
      0.00000000000000E+00  -6.48708563370482E-12   0.00000000000000E+00   4.57354007538510E-14   3.51577099687143E-22
      6.48706739488055E-09   6.48711313028165E-09  -9.13529585934662E-19  -1.69391423394457E-01  -1.69391423394391E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.62109362030568E-11   0.00000000000000E+00  -6.62109362030568E-11
      4.86809266439157E-18  -5.73789403084705E-01  -5.71766715139292E-01   0.00000000000000E+00   2.85746253167429E-13
     -1.35866836407672E-22  -6.42118794033163E-09  -6.42090219407859E-09  -3.95456307845691E-18
      8.20231424687084E-07
      0.00000000000000E+00  -8.72120886627791E-12   0.00000000000000E+00   5.58133370760953E-14   3.57700015937883E-22
      8.72114928762643E-09   8.72120510096386E-09  -8.80117864619818E-19  -1.87369752776041E-01  -1.87369752775968E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.25820677499606E-11   0.00000000000000E+00  -7.25820677499606E-11
      4.72292852889165E-18  -5.67219610268225E-01  -5.64495137165540E-01   0.00000000000000E+00   3.41587006723662E-13
     -1.34307336483860E-22  -8.64896462022049E-09  -8.64862303321390E-09  -3.84281066427183E-18
      8.22231424687084E-07
      0.00000000000000E+00  -1.13847980900334E-11   0.00000000000000E+00   6.63624536671628E-14   3.59775966351552E-22
      1.13847742993100E-08   1.13848406617641E-08  -8.48526062572863E-19  -2.04981106259310E-01  -2.04981106259232E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.83915918405236E-11   0.00000000000000E+00  -7.83915918405236E-11
      4.56614534521060E-18  -5.55619618421177E-01  -5.52057853899362E-01   0.00000000000000E+00   4.33791793147771E-13
     -1.32289201827128E-22  -1.13068828617166E-08  -1.13064490699236E-08  -3.71761928263774E-18
      8.24231424687084E-07
      0.00000000000000E+00  -1.44966814760988E-11   0.00000000000000E+00   7.73905498829133E-14   3.57224071084144E-22
      1.44965768999945E-08   1.44966542905447E-08  -8.18284252979234E-19  -2.22233125918796E-01  -2.22233125918712E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.34981580493809E-11   0.00000000000000E+00  -8.34981580493809E-11
      4.39914902911184E-18  -5.38213038976969E-01  -5.33672552416121E-01   0.00000000000000E+00   5.55787637550703E-13
     -1.29643147023740E-22  -1.44137119201328E-08  -1.44131561324954E-08  -3.58086477613261E-18
      8.26231424687084E-07
      0.00000000000000E+00  -1.80699009771576E-11   0.00000000000000E+00   8.87652395976418E-14   3.49227465142031E-22
      1.80697803820466E-08   1.80698691472865E-08  -7.89033729680845E-19  -2.39133394146052E-01  -2.39133394145964E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.80082014321314E-11   0.00000000000000E+00  -8.80082014321314E-11
      4.22313262624758E-18  -5.14210083778987E-01  -5.08545300725282E-01   0.00000000000000E+00   6.89789506555620E-13
     -1.26258234526862E-22  -1.79825507353608E-08  -1.79818609458544E-08  -3.43409889656673E-18
      8.28231424687084E-07
      0.00000000000000E+00  -2.20980274616054E-11   0.00000000000000E+00   1.00002801603505E-13   3.34595444903998E-22
      2.20979474016963E-08   2.20980474044982E-08  -7.60518990838185E-19  -2.55689034096666E-01  -2.55689034096573E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.21644161301580E-11   0.00000000000000E+00  -9.21644161301580E-11
      4.03880379398726E-18  -4.82844315275392E-01  -4.75911753699276E-01   0.00000000000000E+00   8.11985634976660E-13
     -1.22118270205762E-22  -2.20066949740029E-08  -2.20058829883681E-08  -3.27828480314907E-18
      8.30231424687084E-07
      0.00000000000000E+00  -2.65405574003334E-11   0.00000000000000E+00   1.10258997942761E-13   3.12239431239284E-22
      2.65404044242667E-08   2.65405146832649E-08  -7.32561190998522E-19  -2.71906867211515E-01  -2.71906867211419E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.61118081236480E-11   0.00000000000000E+00  -9.61118081236480E-11
      3.84658017773997E-18  -4.43436367058267E-01  -4.35105393605036E-01   0.00000000000000E+00   9.05450016632848E-13
     -1.17271344009831E-22  -2.64453083251578E-08  -2.64444028751413E-08  -3.11401898674144E-18
      8.32231424687084E-07
      0.00000000000000E+00  -3.13209841272480E-11   0.00000000000000E+00   1.18653126144578E-13   2.83239180751794E-22
      3.13208607621834E-08   3.13209794153099E-08  -7.05014548713808E-19  -2.87794063015749E-01  -2.87794063015649E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.96525976489338E-11   0.00000000000000E+00  -9.96525976489338E-11
      3.64727498244210E-18  -3.95462569555289E-01  -3.85626513142258E-01   0.00000000000000E+00   9.70333415018256E-13
     -1.11708592973906E-22  -3.12222971510758E-08  -3.12213268176609E-08  -2.94226043372829E-18
      8.34231424687084E-07
      0.00000000000000E+00  -3.63068675312958E-11   0.00000000000000E+00   1.23788999350799E-13   2.53252524398809E-22
      3.63067351826642E-08   3.63068589716638E-08  -6.77761909480200E-19  -3.03358021263501E-01  -3.03358021263399E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02632892426723E-10   0.00000000000000E+00  -1.02632892426723E-10
      3.44200919758865E-18  -3.38681022557260E-01  -3.27274924512539E-01   0.00000000000000E+00   1.00130692419253E-12
     -1.05260292040474E-22  -3.62052273861612E-08  -3.62042260792371E-08  -2.76424728810846E-18
      8.36231424687084E-07
      0.00000000000000E+00  -4.11176948662260E-11   0.00000000000000E+00   1.19516127129728E-13   2.27894492545677E-22
      4.11175514124604E-08   4.11176709285877E-08  -6.50848136939945E-19  -3.18603253292053E-01  -3.18603253291947E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06479675379116E-10   0.00000000000000E+00  -1.06479675379116E-10
      3.22904984683042E-18  -2.73636232956809E-01  -2.60715463860442E-01   0.00000000000000E+00   9.44515995288012E-13
     -9.75792009297539E-23  -4.10121357692038E-08  -4.10111912532086E-08  -2.57820170989048E-18
      8.38231424687084E-07
      0.00000000000000E+00  -4.48341921573286E-11   0.00000000000000E+00   9.24522222065384E-14   1.97136524403256E-22
      4.48341339745656E-08   4.48342264267880E-08  -6.24608491638092E-19  -3.33527646434154E-01  -3.33527646434039E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14551012075008E-10   0.00000000000000E+00  -1.14551012075008E-10
      2.99994782268041E-18  -2.02632314647928E-01  -1.88542945704302E-01   0.00000000000000E+00   7.58374218040438E-13
     -8.89853781494884E-23  -4.47204337889310E-08  -4.47196754147131E-08  -2.37533933104232E-18
      8.40231424687084E-07
      0.00000000000000E+00  -4.65314829009237E-11   0.00000000000000E+00   4.24076834945874E-14   1.41735383563068E-22
      4.65314155321282E-08   4.65314579398119E-08  -5.99285480047864E-19  -3.48131468784531E-01  -3.48131468784406E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.25666189635029E-10   0.00000000000000E+00  -1.25666189635029E-10
      2.74861544341035E-18  -1.29702410888411E-01  -1.15081651301271E-01   0.00000000000000E+00   5.41406018317447E-13
     -8.13902806620129E-23  -4.64063331561950E-08  -4.64057917501768E-08  -2.14932996336248E-18
      8.42231424687084E-07
      0.00000000000000E+00  -4.24686391058115E-11   0.00000000000000E+00  -1.00360202034320E-13   7.08852106343829E-23
      4.24687581803838E-08   4.24686578201819E-08  -5.73772354114400E-19  -3.62439812154458E-01  -3.62439812154331E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.27147735849097E-10   0.00000000000000E+00  -1.27147735849097E-10
      2.49431997171215E-18  -6.60976287089344E-02  -5.27572793729940E-02   0.00000000000000E+00   4.54793873174458E-13
     -5.83020376988640E-23  -4.23419648782059E-08  -4.23415100843327E-08  -1.92054761759776E-18
      8.44231424687085E-07
      0.00000000000000E+00  -2.87926822013992E-11   0.00000000000000E+00  -3.38078693106044E-13   2.73183697623408E-23
      2.87929918993148E-08   2.87926538206218E-08  -5.43311639455327E-19  -3.76520680169342E-01  -3.76520680169245E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.68186623524144E-11   0.00000000000000E+00  -9.68186623524144E-11
      2.30068264700733E-18  -3.03606650632694E-02  -2.13195661347473E-02   0.00000000000000E+00   4.96002330907244E-13
     -2.53503135925872E-23  -2.86963311606002E-08  -2.86958351582694E-08  -1.75737100755200E-18
      8.46231424687085E-07
      0.00000000000000E+00  -1.82737962937584E-11   0.00000000000000E+00  -1.99624603172804E-13   1.19451962918692E-23
      1.82740601471577E-08   1.82738605225546E-08  -5.09668852307242E-19  -3.90375372408401E-01  -3.90375372408333E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.80729059755101E-11   0.00000000000000E+00  -6.80729059755101E-11
      2.16453683505630E-18  -1.57923287726481E-02  -1.00563042805818E-02   0.00000000000000E+00   2.69323918049495E-13
     -1.20311330560951E-23  -1.82060569404971E-08  -1.82057876165790E-08  -1.65486798274906E-18
      8.48231424687085E-07
      0.00000000000000E+00  -1.36802736070611E-11   0.00000000000000E+00  -1.13022504691707E-13   6.93712125813543E-24
      1.36803878082117E-08   1.36802747857070E-08  -4.75821124680815E-19  -4.03974732947071E-01  -4.03974732947015E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.64654896166568E-11   0.00000000000000E+00  -5.64654896166568E-11
      2.05160585582299E-18  -1.04406988735823E-02  -6.14828036942944E-03   0.00000000000000E+00   1.56910891472172E-13
     -7.55220529962454E-24  -1.36239662069818E-08  -1.36238092960904E-08  -1.57578473114218E-18
      8.50231424687085E-07
      0.00000000000000E+00  -1.20357935873603E-11   0.00000000000000E+00  -4.02532701721064E-14   5.04071949422870E-24
      1.20358740772875E-08   1.20358338240174E-08  -4.42566943351133E-19  -4.17307481356318E-01  -4.17307481356265E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.31627333698770E-11   0.00000000000000E+00  -5.31627333698770E-11
      1.94528038908324E-18  -8.38452591574756E-03  -4.60917369867601E-03   0.00000000000000E+00   7.41244708244714E-14
     -5.69639851152932E-24  -1.19827452151183E-08  -1.19826710906475E-08  -1.50271344573211E-18
      8.52231424687085E-07
      0.00000000000000E+00  -1.14791226351455E-11   0.00000000000000E+00  -1.34540061278198E-14   4.11508037867255E-24
      1.14791444754855E-08   1.14791310214794E-08  -4.10099301214613E-19  -4.30373204742356E-01  -4.30373204742303E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.27235383962853E-11   0.00000000000000E+00  -5.27235383962853E-11
      1.83983331229067E-18  -7.44390082092203E-03  -3.84380695320541E-03   0.00000000000000E+00   4.25123243330561E-14
     -4.72919757596374E-24  -1.14264499954075E-08  -1.14264074830831E-08  -1.42973401107605E-18
      8.54231424687085E-07
      0.00000000000000E+00  -1.12793603317192E-11   0.00000000000000E+00  -4.67436558734086E-15   3.54899339456160E-24
      1.12793319242363E-08   1.12793272498707E-08  -3.78507960034675E-19  -4.43175381988589E-01  -4.43175381988536E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.31524070397775E-11   0.00000000000000E+00  -5.31524070397775E-11
      1.73352849821111E-18  -6.90464871701169E-03  -3.36763971270041E-03   0.00000000000000E+00   3.05889824759904E-14
     -4.09951416872608E-24  -1.12262054318134E-08  -1.12261748428309E-08  -1.35502053817644E-18
      8.56231424687085E-07
      0.00000000000000E+00  -1.11938528813789E-11   0.00000000000000E+00  -1.87466256055816E-15   3.15263389731336E-24
      1.11938813412053E-08   1.11938794665428E-08  -3.47854558311947E-19  -4.55718657706882E-01  -4.55718657706828E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.37924871493518E-11   0.00000000000000E+00  -5.37924871493518E-11
      1.62594352391241E-18  -6.53826178476824E-03  -3.02837454175058E-03   0.00000000000000E+00   2.53327157862551E-14
     -3.63256688465964E-24  -1.11401123121092E-08  -1.11400869793934E-08  -1.27808896560046E-18
      8.58231424687085E-07
      0.00000000000000E+00  -1.11481142022496E-11   0.00000000000000E+00  -9.14889972629427E-16   2.85514907872562E-24
      1.11480981943543E-08   1.11480972794644E-08  -3.18177354477479E-19  -4.68007895979563E-01  -4.68007895979508E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.44268973668596E-11   0.00000000000000E+00  -5.44268973668596E-11
      1.51708972917869E-18  -6.26550033199632E-03  -2.77023589432101E-03   0.00000000000000E+00   2.23144707445287E-14
     -3.26575732680628E-24  -1.10936926965682E-08  -1.10936703820975E-08  -1.19891237470121E-18
      8.60231424687085E-07
      0.00000000000000E+00  -1.11189075758176E-11   0.00000000000000E+00  -5.21622063761659E-16   2.62301120851156E-24
      1.11189158658191E-08   1.11189153441970E-08  -2.89492702286183E-19  -4.80047751720397E-01  -4.80047751720342E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.49778233672137E-11   0.00000000000000E+00  -5.49778233672137E-11
      1.40713408244426E-18  -6.05307578505797E-03  -2.56717779569820E-03   0.00000000000000E+00   2.01533501855406E-14
     -2.96990175524908E-24  -1.10639576741800E-08  -1.10639375208298E-08  -1.11764138015808E-18
      8.62231424687085E-07
      0.00000000000000E+00  -1.10984261994203E-11   0.00000000000000E+00  -3.21783795554899E-16   2.43704910731501E-24
      1.10984215446439E-08   1.10984212228601E-08  -2.61799658900779E-19  -4.91842152870640E-01  -4.91842152870585E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.54126054150570E-11   0.00000000000000E+00  -5.54126054150570E-11
      1.29630887161415E-18  -5.88338774993471E-03  -2.40408249619485E-03   0.00000000000000E+00   1.84184730955237E-14
     -2.72747463253900E-24  -1.10430270359181E-08  -1.10430086174450E-08  -1.03450921271337E-18
      8.64231424687085E-07
      0.00000000000000E+00  -1.10832718177811E-11   0.00000000000000E+00  -2.02743251532944E-16   2.28502668888883E-24
      1.10832702139675E-08   1.10832700112243E-08  -2.35087742511154E-19  -5.03392802424817E-01  -5.03392802424761E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.57100293236468E-11   0.00000000000000E+00  -5.57100293236468E-11
      1.18488881296685E-18  -5.74542621720218E-03  -2.27098715800588E-03   0.00000000000000E+00   1.69548162726229E-14
     -2.52638048780528E-24  -1.10275769367169E-08  -1.10275599819007E-08  -9.49801070455701E-19
      8.66231424687085E-07
      0.00000000000000E+00  -1.10716075361557E-11   0.00000000000000E+00  -1.26811425444696E-16   2.15870077865287E-24
      1.10716474134882E-08   1.10716472866768E-08  -2.09354430496646E-19  -5.14693120085561E-01  -5.14693120085505E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58268921071533E-11   0.00000000000000E+00  -5.58268921071533E-11
      1.07323502875255E-18  -5.63168714448480E-03  -2.16094576577894E-03   0.00000000000000E+00   1.56829142312783E-14
     -2.35785384771443E-24  -1.10158360774839E-08  -1.10158203945696E-08  -8.63880598255902E-19
      8.68231424687085E-07
      0.00000000000000E+00  -1.10622393729606E-11   0.00000000000000E+00  -8.36849218465346E-17   2.05247731919234E-24
      1.10622339339942E-08   1.10622338503093E-08  -1.84659780774797E-19  -5.25704651707446E-01  -5.25704651707390E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.56009073006052E-11   0.00000000000000E+00  -5.56009073006052E-11
      9.62033214151337E-19  -5.53695486040881E-03  -2.06910717133630E-03   0.00000000000000E+00   1.45256443252128E-14
     -2.21566936209323E-24  -1.10066474686530E-08  -1.10066329430087E-08  -7.77373433376541E-19
      8.70231424687085E-07
      0.00000000000000E+00  -1.10537896571375E-11   0.00000000000000E+00  -7.07937076526657E-17   1.96272608657891E-24
      1.10537935627302E-08   1.10537934919365E-08  -1.61208653959671E-19  -5.36318539382731E-01  -5.36318539382676E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.46581536983758E-11   0.00000000000000E+00  -5.46581536983758E-11
      8.52716906754586E-19  -5.45771182898330E-03  -1.99222563983887E-03   0.00000000000000E+00   1.33734185049119E-14
     -2.09571847685589E-24  -1.09991487116566E-08  -1.09991353382381E-08  -6.91508252794914E-19
      8.72231424687085E-07
      0.00000000000000E+00  -1.10453399413144E-11   0.00000000000000E+00  -8.27322375307990E-17   1.88713272276464E-24
      1.10453619789810E-08   1.10453618962488E-08  -1.39336345611191E-19  -5.46358606942900E-01  -5.46358606942848E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.26151807442176E-11   0.00000000000000E+00  -5.26151807442176E-11
      7.47486545266150E-19  -5.39158047696264E-03  -1.92810653986942E-03   0.00000000000000E+00   1.21478759931276E-14
     -1.99520651605302E-24  -1.09927588633806E-08  -1.09927467155046E-08  -6.08150199654957E-19
      8.74231424687085E-07
      0.00000000000000E+00  -1.10361554675936E-11   0.00000000000000E+00  -1.15247411366317E-16   1.82423452364352E-24
      1.10361745846291E-08   1.10361744693817E-08  -1.19496325553916E-19  -5.55584764831102E-01  -5.55584764831053E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.90912224503436E-11   0.00000000000000E+00  -4.90912224503436E-11
      6.49304100365463E-19  -5.33695973457646E-03  -1.87526959251729E-03   0.00000000000000E+00   1.07764490367037E-14
     -1.91228114346556E-24  -1.09870940233804E-08  -1.09870832469314E-08  -5.29807774811546E-19
      8.76231424687085E-07
      0.00000000000000E+00  -1.10254096333403E-11   0.00000000000000E+00  -1.70993234356420E-16   1.77329957214473E-24
      1.10253964017770E-08   1.10253962307837E-08  -1.02312505308210E-19  -5.63667645178636E-01  -5.63667645178593E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.35632341933528E-11   0.00000000000000E+00  -4.35632341933528E-11
      5.62177631978758E-19  -5.29292539457552E-03  -1.83288893195924E-03   0.00000000000000E+00   9.17284001523071E-15
     -1.84606285942734E-24  -1.09818421694304E-08  -1.09818329965904E-08  -4.59865126670547E-19
      8.78231424687085E-07
      0.00000000000000E+00  -1.10120003017080E-11   0.00000000000000E+00  -2.54812464030840E-16   1.73432261700672E-24
      1.10120427496382E-08   1.10120424948258E-08  -8.86288988311633E-20  -5.70165053978419E-01  -5.70165053978383E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.53788518622784E-11   0.00000000000000E+00  -3.53788518622784E-11
      4.91419928254201E-19  -5.25920747419606E-03  -1.80079931594544E-03   0.00000000000000E+00   7.22399271303200E-15
     -1.79668524551751E-24  -1.09766708669562E-08  -1.09766636429635E-08  -4.02791029423038E-19
      8.80231424687085E-07
      0.00000000000000E+00  -1.09951008700619E-11   0.00000000000000E+00  -3.68771783626006E-16   1.70802388876712E-24
      1.09950941662472E-08   1.09950937974754E-08  -7.95115743125831E-20  -5.74523890330102E-01  -5.74523890330078E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.39105661120959E-11   0.00000000000000E+00  -2.39105661120959E-11
      4.43598796030009E-19  -5.23618471679334E-03  -1.77950300567512E-03   0.00000000000000E+00   4.81468565380627E-15
     -1.76531071968653E-24  -1.09711880460490E-08  -1.09711832313633E-08  -3.64087221717425E-19
      8.82231424687085E-07
      0.00000000000000E+00  -1.09737010462925E-11   0.00000000000000E+00  -5.09775256704027E-16   1.69593277749081E-24
      1.09737037208711E-08   1.09737032110958E-08  -7.62173277834890E-20  -5.76103878166575E-01  -5.76103878166567E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.70787469601097E-12   0.00000000000000E+00  -8.70787469601097E-12
      4.26183046637987E-19  -5.22499775633661E-03  -1.77026556426488E-03   0.00000000000000E+00   1.83492245478753E-15
     -1.75431941277168E-24  -1.09649971713223E-08  -1.09649953363998E-08  -3.49965718854498E-19
      8.84231424687085E-07
      0.00000000000000E+00  -1.09471579172395E-11   0.00000000000000E+00  -5.15928401638369E-16   1.70064820179960E-24
      1.09471795604024E-08   1.09471790444740E-08  -8.01618004872562E-20  -5.74209532800657E-01  -5.74209532800668E-01
      0.00000000000000E+00   0.00000000000000E+00   1.04129148269143E-11   0.00000000000000E+00   1.04129148269143E-11
      4.47008876291815E-19  -5.22777717400986E-03  -1.77537771469299E-03   0.00000000000000E+00  -1.98833292757326E-15
     -1.76785263532577E-24  -1.09575899709679E-08  -1.09575919593009E-08  -3.66847075804560E-19
      8.86231424687085E-07
      0.00000000000000E+00  -1.09148285697425E-11   0.00000000000000E+00  -8.67750986553178E-16   1.72648407606833E-24
      1.09147850147458E-08   1.09147841469949E-08  -9.29246939197112E-20  -5.68113879424636E-01  -5.68113879424669E-01
      0.00000000000000E+00   0.00000000000000E+00   3.33584100580948E-11   0.00000000000000E+00   3.33584100580948E-11
      5.13725696408005E-19  -5.24824341146176E-03  -1.79882147467504E-03   0.00000000000000E+00  -6.32829540911158E-15
     -1.81311897157792E-24  -1.09481362287575E-08  -1.09481425570529E-08  -4.20801002488293E-19
      8.88231424687085E-07
      0.00000000000000E+00  -1.08753353327432E-11   0.00000000000000E+00  -1.10231487669534E-15   1.78085167900404E-24
      1.08753091131440E-08   1.08753080108292E-08  -1.16314082220900E-19  -5.57066533756581E-01  -5.57066533756641E-01
      0.00000000000000E+00   0.00000000000000E+00   5.97628490448120E-11   0.00000000000000E+00   5.97628490448120E-11
      6.33251394497629E-19  -5.29312931985998E-03  -1.84782655384005E-03   0.00000000000000E+00  -1.19069304639281E-14
     -1.90334559335072E-24  -1.09350589529435E-08  -1.09350708598740E-08  -5.16937312276729E-19
      8.90231424687086E-07
      0.00000000000000E+00  -1.08261983983372E-11   0.00000000000000E+00  -8.32748232326303E-15   1.87714961660001E-24
      1.08261751490060E-08   1.08261668215237E-08  -1.52487524198855E-19  -5.40293390861586E-01  -5.40293390861675E-01
      0.00000000000000E+00   0.00000000000000E+00   8.88937384135923E-11   0.00000000000000E+00   8.88937384135923E-11
      8.11038871324814E-19  -5.37550445569124E-03  -1.93650516125393E-03   0.00000000000000E+00  -1.20834601826844E-14
     -2.06480772669677E-24  -1.09150484764771E-08  -1.09150605599373E-08  -6.58551347125959E-19
      8.92231424687086E-07
      0.00000000000000E+00  -1.07611723243943E-11   0.00000000000000E+00  -1.53683333957333E-15   2.04097929636691E-24
      1.07611535747132E-08   1.07611520378799E-08  -2.04102779940081E-19  -5.17004885873825E-01  -5.17004885873944E-01
      0.00000000000000E+00   0.00000000000000E+00   1.19362698653655E-10   0.00000000000000E+00   1.19362698653655E-10
      1.04976426863212E-18  -5.52306894285443E-03  -2.09495800684018E-03   0.00000000000000E+00  -2.87228406368107E-14
     -2.35583147402308E-24  -1.08804860136929E-08  -1.08805147365336E-08  -8.45661488692042E-19
      8.94231424687086E-07
      0.00000000000000E+00  -1.06630821450566E-11   0.00000000000000E+00  -2.86382129083218E-15   2.32351940427081E-24
      1.06630522214225E-08   1.06630493576012E-08  -2.74406106375638E-19  -4.86429563239403E-01  -4.86429563239551E-01
      0.00000000000000E+00   0.00000000000000E+00   1.48644866192914E-10   0.00000000000000E+00   1.48644866192914E-10
      1.34705400101795E-18  -5.80150591419398E-03  -2.39508105348763E-03   0.00000000000000E+00  -4.13453616440411E-14
     -2.92832505791392E-24  -1.08116528784325E-08  -1.08116942237941E-08  -1.07264789464231E-18
      8.96231424687086E-07
      0.00000000000000E+00  -1.04764536390510E-11   0.00000000000000E+00  -5.10867185123939E-15   2.82260219630124E-24
      1.04765157423593E-08   1.04765106336875E-08  -3.66908041426722E-19  -4.47875864516554E-01  -4.47875864516727E-01
      0.00000000000000E+00   0.00000000000000E+00   1.72781336950262E-10   0.00000000000000E+00   1.72781336950262E-10
      1.69261667491847E-18  -6.39110250479781E-03  -3.03585011282113E-03   0.00000000000000E+00  -6.05933800357985E-14
     -4.27425086212607E-24  -1.06492313772577E-08  -1.06492919706377E-08  -1.32570863349175E-18
      8.98231424687086E-07
      0.00000000000000E+00  -9.99665673187883E-12   0.00000000000000E+00  -1.41664669519804E-14   3.61437740885144E-24
      9.99660032179066E-09   9.99658615532371E-09  -4.83533244320128E-19  -4.00800751471078E-01  -4.00800751471265E-01
      0.00000000000000E+00   0.00000000000000E+00   1.87977794113094E-10   0.00000000000000E+00   1.87977794113094E-10
      2.06857226314466E-18  -7.87644828811591E-03  -4.66762355310715E-03   0.00000000000000E+00  -8.80815231615026E-14
     -8.39630689238714E-24  -1.01844758679136E-08  -1.01845639494368E-08  -1.58503901882454E-18
      9.00231424687086E-07
      0.00000000000000E+00  -8.48314730743600E-12   0.00000000000000E+00  -3.88466430484443E-14   3.54582483097036E-24
      8.48321761239715E-09   8.48317876575411E-09  -6.19540406147115E-19  -3.44920195909433E-01  -3.44920195909631E-01
      0.00000000000000E+00   0.00000000000000E+00   1.98663293960835E-10   0.00000000000000E+00   1.98663293960835E-10
      2.46589885106633E-18  -1.22679469299670E-02  -9.53259147800677E-03   0.00000000000000E+00  -1.30515241664688E-13
     -2.33287372438335E-23  -8.68171154447326E-09  -8.68184205971494E-09  -1.84635844491922E-18
      9.02231424687086E-07
      0.00000000000000E+00  -4.87410835886624E-12   0.00000000000000E+00  -9.10031927520967E-14  -5.17469952272563E-24
      4.87422987505686E-09   4.87413887186410E-09  -7.61871436777277E-19  -2.80655840738956E-01  -2.80655840739178E-01
      0.00000000000000E+00   0.00000000000000E+00   2.22195962848741E-10   0.00000000000000E+00   2.22195962848741E-10
      2.91029077676382E-18  -2.35770046825024E-02  -2.19713311023264E-02   0.00000000000000E+00  -1.95567164623252E-13
     -5.79944105943312E-23  -5.09613926754816E-09  -5.09633483471284E-09  -2.14841933998654E-18
      9.04231424687086E-07
      0.00000000000000E+00  -1.50212067702910E-12   0.00000000000000E+00  -8.61813543841543E-14  -2.54759296447680E-23
      1.50220691337327E-09   1.50212073201886E-09  -9.05751408509176E-19  -2.10100182086841E-01  -2.10100182087084E-01
      0.00000000000000E+00   0.00000000000000E+00   2.43240291313494E-10   0.00000000000000E+00   2.43240291313494E-10
      3.39677135939080E-18  -4.12067202476449E-02  -4.06568235121816E-02   0.00000000000000E+00  -3.58189219858223E-13
     -8.19413917525791E-23  -1.74500283411241E-09  -1.74536102333235E-09  -2.49101995088163E-18
      9.06231424687086E-07
      0.00000000000000E+00  -2.54042543116019E-13   0.00000000000000E+00  -3.49470411491970E-14  -3.99309064745373E-23
      2.54076133481952E-10   2.54041186440763E-10  -1.05317030841682E-18  -1.37104039550375E-01  -1.37104039550614E-01
      0.00000000000000E+00   0.00000000000000E+00   2.39675773085967E-10   0.00000000000000E+00   2.39675773085967E-10
      3.87612290556274E-18  -6.09293134450512E-02  -6.07737631037637E-02   0.00000000000000E+00  -6.00327914975657E-13
     -9.02783851528633E-23  -4.93116631611663E-10  -4.93716959526729E-10  -2.82295259714592E-18
      9.08231424687086E-07
      0.00000000000000E+00   1.07458342532806E-14   0.00000000000000E+00  -1.09764160760858E-14  -4.47954976080975E-23
     -1.07199187254080E-11  -1.07308951415289E-11  -1.18672225258602E-18  -7.14744796200595E-02  -7.14744796202655E-02
      0.00000000000000E+00   0.00000000000000E+00   2.06038440421384E-10   0.00000000000000E+00   2.06038440421384E-10
      4.28819978640551E-18  -8.08409425728111E-02  -8.07794091340013E-02   0.00000000000000E+00  -7.84579384702254E-13
     -9.73489115714388E-23  -1.94522965895056E-10  -1.95307545279856E-10  -3.10147753381949E-18
      9.10231424687086E-07
      0.00000000000000E+00   2.31448737762967E-14   0.00000000000000E+00  -3.04321896043012E-15  -4.58899634695310E-23
     -2.31368224568040E-11  -2.31398656758103E-11  -1.26682231956599E-18  -3.28105247618974E-02  -3.28105247620352E-02
      0.00000000000000E+00   0.00000000000000E+00   1.37852643665227E-10   0.00000000000000E+00   1.37852643665227E-10
      4.56390507373596E-18  -1.00511667675281E-01  -1.00475526484085E-01   0.00000000000000E+00  -6.41130207592736E-13
     -1.02295136306334E-22  -1.14071647781722E-10  -1.14712777989417E-10  -3.29708275416997E-18
      9.12231424687086E-07
      0.00000000000000E+00   2.29611843018817E-15   0.00000000000000E+00  -2.81315284970432E-16  -4.59750269976249E-23
     -2.31542559791812E-12  -2.31570691324907E-12  -1.30234240718585E-18  -1.67128732010227E-02  -1.67128732011061E-02
      0.00000000000000E+00   0.00000000000000E+00   8.34534794055004E-11   0.00000000000000E+00   8.34534794055004E-11
      4.73081203254696E-18  -1.19852833404614E-01  -1.19827270500090E-01   0.00000000000000E+00  -4.09460321489821E-13
     -1.05048470778481E-22  -8.07283121706563E-11  -8.11377724922512E-11  -3.42846962536111E-18
      9.14231424687086E-07
      0.00000000000000E+00  -1.38685553183365E-14   0.00000000000000E+00   4.30490206251170E-16  -4.54698120966869E-23
      1.38246614764156E-11   1.38250919665764E-11  -1.31625520886471E-18  -1.07790952479410E-02  -1.07790952479954E-02
      0.00000000000000E+00   0.00000000000000E+00   5.44115767946272E-11   0.00000000000000E+00   5.44115767946272E-11
      4.83963518613622E-18  -1.38828738380497E-01  -1.38807240206893E-01   0.00000000000000E+00  -3.00355549262941E-13
     -1.06922114197940E-22  -6.79363132118338E-11  -6.82366687612036E-11  -3.52337997727151E-18
      9.16231424687086E-07
      0.00000000000000E+00  -2.47980790460322E-14   0.00000000000000E+00   4.96086404620714E-16  -4.42247546671024E-23
      2.48067497073483E-11   2.48072457937087E-11  -1.32105240378261E-18  -8.52439578103228E-03  -8.52439578107179E-03
      0.00000000000000E+00   0.00000000000000E+00   3.95069483150179E-11   0.00000000000000E+00   3.95069483150179E-11
      4.91864908276625E-18  -1.57427725161151E-01  -1.57407462897664E-01   0.00000000000000E+00  -2.72147937181112E-13
     -1.08541793287790E-22  -6.40420461714370E-11  -6.43141941087266E-11  -3.59759667898364E-18
      9.18231424687086E-07
      0.00000000000000E+00  -3.27885711830871E-14   0.00000000000000E+00   4.11479917581040E-16  -4.18860373348894E-23
      3.27760533921963E-11   3.27764648720720E-11  -1.32205130527017E-18  -7.51573013904273E-03  -7.51573013907390E-03
      0.00000000000000E+00   0.00000000000000E+00   3.11759415381655E-11   0.00000000000000E+00   3.11759415381655E-11
      4.98100096584258E-18  -1.75649906493339E-01  -1.75629758316763E-01   0.00000000000000E+00  -2.73052821697553E-13
     -1.10107740847846E-22  -6.36793535884299E-11  -6.39524064102376E-11  -3.65894966057242E-18
      9.20231424687086E-07
      0.00000000000000E+00  -3.90340133131989E-14   0.00000000000000E+00   3.20752209235173E-16  -3.80334610218458E-23
      3.90136808475147E-11   3.90140015996859E-11  -1.32143188479310E-18  -6.95002286410897E-03  -6.95002286413499E-03
      0.00000000000000E+00   0.00000000000000E+00   2.60133926325131E-11   0.00000000000000E+00   2.60133926325131E-11
      5.03302775110761E-18  -1.93500507164224E-01  -1.93480020417426E-01   0.00000000000000E+00  -2.80711554667521E-13
     -1.11666713435716E-22  -6.47466826774196E-11  -6.50273942321987E-11  -3.71159586631451E-18
      9.22231424687086E-07
      0.00000000000000E+00  -4.41773185968204E-14   0.00000000000000E+00   2.53642879329278E-16  -3.22472538377887E-23
      4.42182056413629E-11   4.42184592842100E-11  -1.32012233458968E-18  -6.57081034321424E-03  -6.57081034323681E-03
      0.00000000000000E+00   0.00000000000000E+00   2.25641510835418E-11   0.00000000000000E+00   2.25641510835418E-11
      5.07815605327469E-18  -2.10986735374708E-01  -2.10965695759713E-01   0.00000000000000E+00  -2.88116509129767E-13
     -1.13222208660879E-22  -6.64944938585086E-11  -6.67826103677515E-11  -3.75803371868502E-18
      9.24231424687086E-07
      0.00000000000000E+00  -4.87695554571967E-14   0.00000000000000E+00   2.09170440401294E-16  -2.41932770054391E-23
      4.87959652311120E-11   4.87961744015282E-11  -1.31854015156065E-18  -6.29037394665850E-03  -6.29037394667865E-03
      0.00000000000000E+00   0.00000000000000E+00   2.01502006118719E-11   0.00000000000000E+00   2.01502006118719E-11
      5.11845645449844E-18  -2.28116288775284E-01  -2.28094567589943E-01   0.00000000000000E+00  -2.93747123246280E-13
     -1.14769053163817E-22  -6.86526278900399E-11  -6.89463750134009E-11  -3.79991630293779E-18
      9.26231424687086E-07
      0.00000000000000E+00  -5.29944133687429E-14   0.00000000000000E+00   1.80827315008524E-16  -1.37448151329116E-23
      5.29928381512378E-11   5.29930189785391E-11  -1.31687876209813E-18  -6.07271651892486E-03  -6.07271651894327E-03
      0.00000000000000E+00   0.00000000000000E+00   1.84068424948039E-11   0.00000000000000E+00   1.84068424948039E-11
      5.15527013948805E-18  -2.44896611106123E-01  -2.44874117086010E-01   0.00000000000000E+00  -2.97704106275265E-13
     -1.16302356596480E-22  -7.11021573669513E-11  -7.13998614733428E-11  -3.83839137738991E-18
      9.28231424687086E-07
      0.00000000000000E+00  -5.69437370686666E-14   0.00000000000000E+00   1.62865963680755E-16  -1.10452658767279E-24
      5.69560762473905E-11   5.69562391133531E-11  -1.31522609824495E-18  -5.89921925625066E-03  -5.89921925626778E-03
      0.00000000000000E+00   0.00000000000000E+00   1.71123500922864E-11   0.00000000000000E+00   1.71123500922864E-11
      5.18949483967262E-18  -2.61334670948326E-01  -2.61311336294537E-01   0.00000000000000E+00  -3.00464733844229E-13
     -1.17819276505360E-22  -7.37681244716774E-11  -7.40685892056395E-11  -3.87426874142767E-18
      9.30231424687086E-07
      0.00000000000000E+00  -6.08012160313827E-14   0.00000000000000E+00   1.51333859003282E-16   1.28278972221920E-23
      6.07729672600340E-11   6.07731185939059E-11  -1.31361867470453E-18  -5.75838784348785E-03  -5.75838784350397E-03
      0.00000000000000E+00   0.00000000000000E+00   1.61221976513766E-11   0.00000000000000E+00   1.61221976513766E-11
      5.22173923497537E-18  -2.77437330734099E-01  -2.77413105681442E-01   0.00000000000000E+00  -3.02532844077451E-13
     -1.19319079400533E-22  -7.65927834010858E-11  -7.68953162452825E-11  -3.90812056027084E-18
      9.32231424687086E-07
      0.00000000000000E+00  -6.44750055196838E-14   0.00000000000000E+00   1.43785125908995E-16   2.68929725333700E-23
      6.44973619836078E-11   6.44975057687606E-11  -1.31206813784474E-18  -5.64243206209888E-03  -5.64243206211422E-03
      0.00000000000000E+00   0.00000000000000E+00   1.53393276777408E-11   0.00000000000000E+00   1.53393276777408E-11
      5.25241789033085E-18  -2.93211965732083E-01  -2.93186814127526E-01   0.00000000000000E+00  -3.04352036827843E-13
     -1.20802588821618E-22  -7.95324814095523E-11  -7.98368334465010E-11  -3.94034975248611E-18
      9.34231424687086E-07
      0.00000000000000E+00  -6.81487950079849E-14   0.00000000000000E+00   1.38757550221618E-16   4.04133788048435E-23
      6.81644989510353E-11   6.81646377086259E-11  -1.31057467173792E-18  -5.54593222236811E-03  -5.54593222238280E-03
      0.00000000000000E+00   0.00000000000000E+00   1.46965843804417E-11   0.00000000000000E+00   1.46965843804417E-11
      5.28181105909174E-18  -3.08665501887321E-01  -3.08639397633148E-01   0.00000000000000E+00  -3.06252262561467E-13
     -1.22271861867100E-22  -8.25549698263843E-11  -8.28612220890680E-11  -3.97123638735382E-18
      9.36231424687087E-07
      0.00000000000000E+00  -7.18225844962859E-14   0.00000000000000E+00   1.35324501644956E-16   5.28469338296504E-23
      7.17973901643849E-11   7.17975254889394E-11  -1.30913384881314E-18  -5.46522138302665E-03  -5.46522138304080E-03
      0.00000000000000E+00   0.00000000000000E+00   1.41442139380130E-11   0.00000000000000E+00   1.41442139380130E-11
      5.31009948696776E-18  -3.23800356663733E-01  -3.23773282087196E-01   0.00000000000000E+00  -3.08374071988894E-13
     -1.23729206431500E-22  -8.56333653548395E-11  -8.59417394269521E-11  -4.00096563815462E-18
      9.38231424687087E-07
      0.00000000000000E+00  -7.54045292473795E-14   0.00000000000000E+00   1.32856205417436E-16   6.38531294802986E-23
      7.54096337162939E-11   7.54097665725632E-11  -1.30774025501385E-18  -5.39782757306616E-03  -5.39782757307981E-03
      0.00000000000000E+00   0.00000000000000E+00   1.36458187843457E-11   0.00000000000000E+00   1.36458187843457E-11
      5.33739112453646E-18  -3.38613006562475E-01  -3.38584951173873E-01   0.00000000000000E+00  -3.10739519754514E-13
     -1.25176626908311E-22  -8.87448458370297E-11  -8.90555853569094E-11  -4.02965086952261E-18
      9.40231424687087E-07
      0.00000000000000E+00  -7.89864739984730E-14   0.00000000000000E+00   1.31066279350420E-16   7.33078388557503E-23
      7.90113336122835E-11   7.90114646786361E-11  -1.30638805920217E-18  -5.34207752488627E-03  -5.34207752489946E-03
      0.00000000000000E+00   0.00000000000000E+00   1.31872726376092E-11   0.00000000000000E+00   1.31872726376092E-11
      5.36376566981167E-18  -3.53109463820462E-01  -3.53080418397489E-01   0.00000000000000E+00  -3.13718847497829E-13
     -1.26617567846613E-22  -9.18850184686215E-11  -9.21987373162460E-11  -4.05737761060950E-18
      9.42231424687087E-07
      0.00000000000000E+00  -8.26602634867741E-14   0.00000000000000E+00   1.30042265675969E-16   8.12682337667171E-23
      8.26173695222103E-11   8.26174995645573E-11  -1.30506933739188E-18  -5.29697761412359E-03  -5.29697761413637E-03
      0.00000000000000E+00   0.00000000000000E+00   1.27824212088105E-11   0.00000000000000E+00   1.27824212088105E-11
      5.38933051222929E-18  -3.67332360377702E-01  -3.67302306648576E-01   0.00000000000000E+00  -3.18427595251279E-13
     -1.28060173468739E-22  -9.50814931779883E-11  -9.53999207733676E-11  -4.08426117483742E-18
      9.44231424687087E-07
      0.00000000000000E+00  -8.62422082378676E-14   0.00000000000000E+00   1.29814407581993E-16   8.79036783418793E-23
      8.62445871276587E-11   8.62447169421541E-11  -1.30377522593993E-18  -5.26219334745816E-03  -5.26219334747059E-03
      0.00000000000000E+00   0.00000000000000E+00   1.24327359419999E-11   0.00000000000000E+00   1.24327359419999E-11
      5.41419598411329E-18  -3.81338739854878E-01  -3.81307653778394E-01   0.00000000000000E+00  -3.25397741014207E-13
     -1.29514338263177E-22  -9.83520551430094E-11  -9.86774528841532E-11  -4.11042075817336E-18
      9.46231424687087E-07
      0.00000000000000E+00  -8.99159977261687E-14   0.00000000000000E+00   1.29516693776189E-16   9.34149943588737E-23
      8.98896214070029E-11   8.98897509237901E-11  -1.30250211694006E-18  -5.23803237744439E-03  -5.23803237745646E-03
      0.00000000000000E+00   0.00000000000000E+00   1.20720880719328E-11   0.00000000000000E+00   1.20720880719328E-11
      5.43834016025716E-18  -3.95107539632553E-01  -3.95075419063288E-01   0.00000000000000E+00  -3.32345692082125E-13
     -1.30979123653712E-22  -1.01629493303510E-10  -1.01961838995723E-10  -4.13583804331710E-18
      9.48231424687087E-07
      0.00000000000000E+00  -9.35897872144698E-14   0.00000000000000E+00   1.29414976420995E-16   9.80074513366352E-23
      9.35489307382325E-11   9.35490601533069E-11  -1.30124652623972E-18  -5.22555010454910E-03  -5.22555010456079E-03
      0.00000000000000E+00   0.00000000000000E+00   1.16916906765767E-11   0.00000000000000E+00   1.16916906765767E-11
      5.46172354161031E-18  -4.08615219336678E-01  -4.08582066013552E-01   0.00000000000000E+00  -3.39201903774900E-13
     -1.32453172111096E-22  -1.04901548925976E-10  -1.05240750829884E-10  -4.16047701537059E-18
      9.50231424687087E-07
      0.00000000000000E+00  -9.72635767027708E-14   0.00000000000000E+00   1.29510021437305E-16   1.01871278602467E-22
      9.72251392485330E-11   9.72252687586563E-11  -1.30000271074395E-18  -5.22675656397015E-03  -5.22675656398145E-03
      0.00000000000000E+00   0.00000000000000E+00   1.13000434061383E-11   0.00000000000000E+00   1.13000434061383E-11
      5.48432362842259E-18  -4.21855392904959E-01  -4.21821205062537E-01   0.00000000000000E+00  -3.46431086820852E-13
     -1.33936894618174E-22  -1.08178881077839E-10  -1.08525312164794E-10  -4.18432091767864E-18
      9.52231424687087E-07
      0.00000000000000E+00  -1.00937366191072E-13   0.00000000000000E+00   1.30186351961585E-16   1.05171051921843E-22
      1.00927423043103E-10   1.00927553229560E-10  -1.29876154918712E-18  -5.24516249737792E-03  -5.24516249738882E-03
      0.00000000000000E+00   0.00000000000000E+00   1.08998195167843E-11   0.00000000000000E+00   1.08998195167843E-11
      5.50612326745615E-18  -4.34829503334916E-01  -4.34794275475358E-01   0.00000000000000E+00  -3.54138501818731E-13
     -1.35430853577987E-22  -1.11473234244390E-10  -1.11827372746344E-10  -4.20736171826903E-18
      9.54231424687087E-07
      0.00000000000000E+00  -1.04703000416580E-13   0.00000000000000E+00   1.31991774260260E-16   1.08046799766870E-22
      1.04676350842578E-10   1.04676482834461E-10  -1.29750772207441E-18  -5.28708396395325E-03  -5.28708396396374E-03
      0.00000000000000E+00   0.00000000000000E+00   1.04883490041589E-11   0.00000000000000E+00   1.04883490041589E-11
      5.52709996546447E-18  -4.47541610077479E-01  -4.47505331065158E-01   0.00000000000000E+00  -3.62189927289536E-13
     -1.36934669501856E-22  -1.14802641911194E-10  -1.15164831838620E-10  -4.22959224339006E-18
      9.56231424687087E-07
      0.00000000000000E+00  -1.08560479379297E-13   0.00000000000000E+00   1.35976283423004E-16   1.10624917380421E-22
      1.08516549703333E-10   1.08516685679727E-10  -1.29621293520631E-18  -5.36468364340993E-03  -5.36468364341999E-03
      0.00000000000000E+00   0.00000000000000E+00   1.00563916968060E-11   0.00000000000000E+00   1.00563916968060E-11
      5.54721274885808E-18  -4.59996497983108E-01  -4.59959145535623E-01   0.00000000000000E+00  -3.70251315044087E-13
     -1.38446260729826E-22  -1.18202826061350E-10  -1.18573077376533E-10  -4.25099981365177E-18
      9.58231424687087E-07
      0.00000000000000E+00  -1.12509803079220E-13   0.00000000000000E+00   1.45075378549792E-16   1.13043150209150E-22
      1.12548811878004E-10   1.12548956953495E-10  -1.29481922851651E-18  -5.50348153646676E-03  -5.50348153647635E-03
      0.00000000000000E+00   0.00000000000000E+00   9.58057223018181E-12   0.00000000000000E+00   9.58057223018181E-12
      5.56637389331845E-18  -4.72199000894753E-01  -4.72160528342853E-01   0.00000000000000E+00  -3.77643388036648E-13
     -1.39960605308399E-22  -1.21751885795502E-10  -1.22129529183678E-10  -4.27155466480194E-18
      9.60231424687087E-07
      0.00000000000000E+00  -1.17010195202389E-13   0.00000000000000E+00   1.65229737910394E-16   1.15513372498453E-22
      1.17021756955914E-10   1.17021922185767E-10  -1.29319288866265E-18  -5.76321902823922E-03  -5.76321902824822E-03
      0.00000000000000E+00   0.00000000000000E+00   8.99886463566902E-12   0.00000000000000E+00   8.99886463566902E-12
      5.58437162258979E-18  -4.84153602502359E-01  -4.84113904397741E-01   0.00000000000000E+00  -3.82783723707287E-13
     -1.41466550873296E-22  -1.25638003097587E-10  -1.26020786821436E-10  -4.29117873392713E-18
      9.62231424687087E-07
      0.00000000000000E+00  -1.22612724172048E-13   0.00000000000000E+00   2.17473786447485E-16   1.18519601255710E-22
      1.22639359956715E-10   1.22639577430620E-10  -1.29097643337394E-18  -6.30515529654243E-03  -6.30515529655055E-03
      0.00000000000000E+00   0.00000000000000E+00   8.12503812140439E-12   0.00000000000000E+00   8.12503812140439E-12
      5.60062169883259E-18  -4.95863734160991E-01  -4.95822541959298E-01   0.00000000000000E+00  -3.81212258717911E-13
     -1.42936542224323E-22  -1.30383403293162E-10  -1.30764615552023E-10  -4.30964526545866E-18
      9.64231424687087E-07
      0.00000000000000E+00  -1.31705353155593E-13   0.00000000000000E+00   3.86601209216167E-16   1.23576795015199E-22
      1.31789059242342E-10   1.31789445843675E-10  -1.28703509980572E-18  -7.64378760572455E-03  -7.64378760573086E-03
      0.00000000000000E+00   0.00000000000000E+00   6.30868436948078E-12   0.00000000000000E+00   6.30868436948078E-12
      5.61323906757156E-18  -5.07329399909400E-01  -5.07285897878947E-01   0.00000000000000E+00  -3.57657239316409E-13
     -1.44287915363310E-22  -1.37740472973696E-10  -1.38098130213157E-10  -4.32620396776583E-18
      9.66231424687086E-07
      0.00000000000000E+00  -1.53748090085400E-13   0.00000000000000E+00   9.18870281457756E-16   1.36127019119714E-22
      1.53760714781936E-10   1.53761633652353E-10  -1.27741046803617E-18  -1.15647667532502E-02  -1.15647667532514E-02
      0.00000000000000E+00   0.00000000000000E+00   1.18354480703609E-12   0.00000000000000E+00   1.18354480703609E-12
      5.61560615718563E-18  -5.18537160765879E-01  -5.18488352149273E-01   0.00000000000000E+00  -2.56936769795364E-13
     -1.45241715901440E-22  -1.54688241689448E-10  -1.54945178459388E-10  -4.33819568914946E-18
      9.68231424687086E-07
      0.00000000000000E+00  -2.16937269284178E-13   0.00000000000000E+00   2.48245825167244E-15   1.68504565153764E-22
      2.16928096655987E-10   2.16930579114407E-10  -1.25290883378669E-18  -2.20440196194913E-02  -2.20440196194796E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.16819069500927E-11   0.00000000000000E+00  -1.16819069500927E-11
      5.59224234328545E-18  -5.29427361706419E-01  -5.29362707623213E-01   0.00000000000000E+00   1.35913889187763E-14
     -1.45189309967974E-22  -2.05262263553088E-10  -2.05248672164314E-10  -4.33933350949876E-18
      9.70231424687086E-07
      0.00000000000000E+00  -3.54612530358261E-13   0.00000000000000E+00   4.76772317210398E-15   2.16167572012511E-22
      3.54610825348470E-10   3.54615593071858E-10  -1.21166944499036E-18  -3.92412992830324E-02  -3.92412992830059E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.65468532905062E-11   0.00000000000000E+00  -2.65468532905062E-11
      5.53914863670443E-18  -5.39865722136248E-01  -5.39762379146277E-01   0.00000000000000E+00   2.78351234751316E-13
     -1.44146684517351E-22  -3.28347091015959E-10  -3.28068739781352E-10  -4.32747919171407E-18
      9.72231424687086E-07
      0.00000000000000E+00  -5.92123020776925E-13   0.00000000000000E+00   7.24259115571906E-15   2.55845226834987E-22
      5.92102650396238E-10   5.92109892987649E-10  -1.16279948429690E-18  -5.88769401305029E-02  -5.88769401304678E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.50863026886540E-11   0.00000000000000E+00  -3.50863026886540E-11
      5.46897603132712E-18  -5.49655392886201E-01  -5.49479927042435E-01   0.00000000000000E+00   3.48780248948027E-13
     -1.42812109094450E-22  -5.57372370547800E-10  -5.57023590298995E-10  -4.30617654703022E-18
      9.74231424687086E-07
      0.00000000000000E+00  -9.70523338071935E-13   0.00000000000000E+00   1.05862207738092E-14   2.82454869402889E-22
      9.70495724356069E-10   9.70506310577126E-10  -1.11280130441222E-18  -7.88016012571351E-02  -7.88016012570951E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.00279763045190E-11   0.00000000000000E+00  -4.00279763045190E-11
      5.38892007871809E-18  -5.58528979959224E-01  -5.58235871623235E-01   0.00000000000000E+00   3.32253269521019E-13
     -1.41509407779690E-22  -9.30810587541987E-10  -9.30478334272608E-10  -4.27611877430587E-18
      9.76231424687086E-07
      0.00000000000000E+00  -1.54675721931196E-12   0.00000000000000E+00   1.53389041773317E-14   3.01940516965470E-22
      1.54673858993396E-09   1.54675392883844E-09  -1.06467868692970E-18  -9.85026876601912E-02  -9.85026876601469E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.43422965585946E-11   0.00000000000000E+00  -4.43422965585946E-11
      5.30023548560090E-18  -5.66119628124020E-01  -5.65646353293606E-01   0.00000000000000E+00   3.02715760142622E-13
     -1.40291394723850E-22  -1.50271434803985E-09  -1.50241163227984E-09  -4.23555679867120E-18
      9.78231424687086E-07
      0.00000000000000E+00  -2.38511598054226E-12   0.00000000000000E+00   2.16952640884078E-14   3.18364787470334E-22
      2.38509659996112E-09   2.38511829522552E-09  -1.01974166318013E-18  -1.17879946754728E-01  -1.17879946754679E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.92042522292523E-11   0.00000000000000E+00  -4.92042522292523E-11
      5.20182698114239E-18  -5.71945268666987E-01  -5.71209428276141E-01   0.00000000000000E+00   2.77799707979301E-13
     -1.39141639215133E-22  -2.33619184270411E-09  -2.33591404299627E-09  -4.18208531796226E-18
      9.80231424687086E-07
      0.00000000000000E+00  -3.54465578778729E-12   0.00000000000000E+00   2.95187841415244E-14   3.32688128496234E-22
      3.54461347158540E-09   3.54464299036987E-09  -9.78380015122004E-19  -1.36894247433246E-01  -1.36894247433191E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.48947397299828E-11   0.00000000000000E+00  -5.48947397299828E-11
      5.09203750168243E-18  -5.75419204074712E-01  -5.74319886916822E-01   0.00000000000000E+00   2.62998674448713E-13
     -1.38019850299907E-22  -3.49001124931420E-09  -3.48974825063989E-09  -4.11365748656043E-18
      9.82231424687086E-07
      0.00000000000000E+00  -5.07019687280431E-12   0.00000000000000E+00   3.84598100002915E-14   3.44577389391480E-22
      5.07019738128397E-09   5.07023584109431E-09  -9.40378714161737E-19  -1.55532127591159E-01  -1.55532127591097E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.12418759515111E-11   0.00000000000000E+00  -6.12418759515111E-11
      4.96955374977940E-18  -5.75878562926022E-01  -5.74300655310545E-01   0.00000000000000E+00   2.65970007858649E-13
     -1.36851916492107E-22  -5.00925993515052E-09  -5.00899396514280E-09  -4.02917503561767E-18
      9.84231424687086E-07
      0.00000000000000E+00  -6.99131324097414E-12   0.00000000000000E+00   4.81258656426622E-14   3.53408200955687E-22
      6.99126276741716E-09   6.99131089328315E-09  -9.05216608595632E-19  -1.73792878577230E-01  -1.73792878577162E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.77930106592940E-11   0.00000000000000E+00  -6.77930106592940E-11
      4.83396772846082E-18  -5.72615077966691E-01  -5.70434054875854E-01   0.00000000000000E+00   2.96022221111117E-13
     -1.35520338842415E-22  -6.92381390484483E-09  -6.92351788262385E-09  -3.92875111986519E-18
      9.86231424687086E-07
      0.00000000000000E+00  -9.32802704500804E-12   0.00000000000000E+00   5.83322924805238E-14   3.58596630780664E-22
      9.32798829999328E-09   9.32804663228612E-09  -8.72295926001179E-19  -1.91681384782441E-01  -1.91681384782367E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.40548155926682E-11   0.00000000000000E+00  -7.40548155926682E-11
      4.68585809727548E-18  -5.64893472887460E-01  -5.61978292561136E-01   0.00000000000000E+00   3.60700895515436E-13
     -1.33866209961226E-22  -9.25435251758884E-09  -9.25399181669346E-09  -3.81356217127430E-18
      9.88231424687086E-07
      0.00000000000000E+00  -1.20988909218219E-11   0.00000000000000E+00   6.89983100705905E-14   3.59607250073832E-22
      1.20988088928069E-08   1.20988778911174E-08  -8.41071066308209E-19  -2.09204736552636E-01  -2.09204736552557E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.96963246588666E-11   0.00000000000000E+00  -7.96963246588666E-11
      4.52646544795774E-18  -5.51955164342854E-01  -5.48168866008096E-01   0.00000000000000E+00   4.61192364354557E-13
     -1.31709736641065E-22  -1.20196427588227E-08  -1.20191815664585E-08  -3.68539438164954E-18
      9.90231424687086E-07
      0.00000000000000E+00  -1.53219982846456E-11   0.00000000000000E+00   8.01331189837203E-14   3.55821167085469E-22
      1.53219398674193E-08   1.53220200005386E-08  -8.11098863587822E-19  -2.26370625321149E-01  -2.26370625321064E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.46404163697681E-11   0.00000000000000E+00  -8.46404163697681E-11
      4.35718461521821E-18  -5.33018781208135E-01  -5.28218631368453E-01   0.00000000000000E+00   5.88108827094357E-13
     -1.28891146317291E-22  -1.52379676929958E-08  -1.52373795841688E-08  -3.54608575163039E-18
      9.92231424687086E-07
      0.00000000000000E+00  -1.90074520545721E-11   0.00000000000000E+00   9.15352869483357E-14   3.46335010235961E-22
      1.90073763660903E-08   1.90074679013776E-08  -7.82047039704240E-19  -2.43186539863041E-01  -2.43186539862952E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.90408708290054E-11   0.00000000000000E+00  -8.90408708290054E-11
      4.17910287356020E-18  -5.07295601453342E-01  -5.01335754348712E-01   0.00000000000000E+00   7.21443366664765E-13
     -1.25320568855917E-22  -1.89191484739151E-08  -1.89184270305486E-08  -3.39705583385596E-18
      9.94231424687086E-07
      0.00000000000000E+00  -2.31414755210201E-11   0.00000000000000E+00   1.02620549287144E-13   3.29893747666499E-22
      2.31413840829622E-08   2.31414867035118E-08  -7.53681999579905E-19  -2.59659491332115E-01  -2.59659491332022E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.31434179146558E-11   0.00000000000000E+00  -9.31434179146558E-11
      3.99281603773089E-18  -4.74033849801790E-01  -4.66772852081437E-01   0.00000000000000E+00   8.37617514710182E-13
     -1.21004084144160E-22  -2.30491809031117E-08  -2.30483432855972E-08  -3.23913403815099E-18
      9.96231424687086E-07
      0.00000000000000E+00  -2.76742888364231E-11   0.00000000000000E+00   1.12500072305757E-13   3.05673755228482E-22
      2.76742035844057E-08   2.76743160844783E-08  -7.25837067942980E-19  -2.75796319977968E-01  -2.75796319977871E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.70238402822075E-11   0.00000000000000E+00  -9.70238402822075E-11
      3.79876835716647E-18  -4.32585809886803E-01  -4.23897897832678E-01   0.00000000000000E+00   9.23577388146250E-13
     -1.15989237706242E-22  -2.75782158215841E-08  -2.75772922441961E-08  -3.07293128922349E-18
      9.98231424687085E-07
      0.00000000000000E+00  -3.25210274636015E-11   0.00000000000000E+00   1.20302545659008E-13   2.75742220253698E-22
      3.25208708047026E-08   3.25209911072486E-08  -6.98369901027602E-19  -2.91604343883682E-01  -2.91604343883582E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00414639932984E-10   0.00000000000000E+00  -1.00414639932984E-10
      3.59793907730051E-18  -3.82477927962343E-01  -3.72264010666793E-01   0.00000000000000E+00   9.82052684966071E-13
     -1.10234230892616E-22  -3.24215585200004E-08  -3.24205764673156E-08  -2.89956917627290E-18
      1.00000000000000E-06
      0.00000000000000E+00  -3.69698028444597E-11   0.00000000000000E+00   1.24915647223902E-13   2.49645654413999E-22
      3.69696395486581E-08   3.69697644643055E-08  -6.74267291311892E-19  -3.05331141587786E-01  -3.05331141587683E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02991497784577E-10   0.00000000000000E+00  -1.02991497784577E-10
      3.41579085687862E-18  -3.31228995032307E-01  -3.19614135392353E-01   0.00000000000000E+00   9.92561864995216E-13
     -1.04404475339537E-22  -3.68677655283859E-08  -3.68667729665210E-08  -2.74152356556672E-18
}
